/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.validator.IUpdateValidator;
import org.teiid.query.optimizer.relational.PartitionAnalyzer;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class UpdateValidator
implements IUpdateValidator<Command, ElementSymbol> {
    private IQueryMetadataInterface metadata;
    private UpdateInfo updateInfo = new UpdateInfo();
    private ValidatorReport report = new ValidatorReport();
    private ValidatorReport insertReport = new ValidatorReport();
    private ValidatorReport updateReport = new ValidatorReport();
    private ValidatorReport deleteReport = new ValidatorReport();

    public UpdateValidator(IQueryMetadataInterface qmi, UpdateType insertType, UpdateType updateType, UpdateType deleteType) {
        this.metadata = qmi;
        this.updateInfo.deleteType = deleteType;
        this.updateInfo.insertType = insertType;
        this.updateInfo.updateType = updateType;
    }

    public UpdateInfo getUpdateInfo() {
        return this.updateInfo;
    }

    public ValidatorReport getReport() {
        return this.report;
    }

    public ValidatorReport getDeleteReport() {
        return this.deleteReport;
    }

    public ValidatorReport getInsertReport() {
        return this.insertReport;
    }

    public ValidatorReport getUpdateReport() {
        return this.updateReport;
    }

    private void handleValidationError(String error, boolean update, boolean insert, boolean delete) {
        if (update && insert && delete) {
            this.report.handleValidationError(error);
            this.updateInfo.setUpdateValidationError(error);
            this.updateInfo.setInsertValidationError(error);
            this.updateInfo.setDeleteValidationError(error);
        } else {
            if (update) {
                this.updateReport.handleValidationError(error);
                this.updateInfo.setUpdateValidationError(error);
            }
            if (insert) {
                this.insertReport.handleValidationError(error);
                this.updateInfo.setInsertValidationError(error);
            }
            if (delete) {
                this.deleteReport.handleValidationError(error);
                this.updateInfo.setDeleteValidationError(error);
            }
        }
    }

    public void validate(Command command, List<ElementSymbol> viewSymbols) throws Exception {
        if (this.updateInfo.deleteType != UpdateType.INHERENT && this.updateInfo.updateType != UpdateType.INHERENT && this.updateInfo.insertType != UpdateType.INHERENT) {
            return;
        }
        if (command instanceof SetQuery) {
            SetQuery setQuery = (SetQuery)command;
            if (setQuery.getLimit() != null) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0013, new Object[0]), true, true, true);
                return;
            }
            LinkedList<Query> queries = new LinkedList<Query>();
            if (!PartitionAnalyzer.extractQueries((SetQuery)command, queries)) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0001, new Object[0]), true, true, true);
                return;
            }
            Map<ElementSymbol, List<Set<Constant>>> partitions = PartitionAnalyzer.extractPartionInfo((SetQuery)command, viewSymbols);
            this.updateInfo.partitionInfo = partitions;
            if (partitions.isEmpty()) {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0018, new Object[0]), false, true, false);
            }
            boolean first = true;
            for (Query query : queries) {
                UpdateInfo ui = this.updateInfo;
                if (!first) {
                    this.updateInfo = new UpdateInfo();
                    this.updateInfo.deleteType = ui.deleteType;
                    this.updateInfo.insertType = ui.insertType;
                    this.updateInfo.updateType = ui.updateType;
                }
                this.internalValidate(query, viewSymbols);
                if (this.updateInfo.getDeleteValidationError() != null) {
                    ui.setDeleteValidationError(this.updateInfo.getDeleteValidationError());
                }
                if (this.updateInfo.getUpdateValidationError() != null) {
                    ui.setUpdateValidationError(this.updateInfo.getUpdateValidationError());
                }
                if (this.updateInfo.getInsertValidationError() != null) {
                    ui.setInsertValidationError(this.updateInfo.getInsertValidationError());
                }
                if (!first) {
                    ui.unionBranches.add(this.updateInfo);
                    this.updateInfo = ui;
                    continue;
                }
                first = false;
            }
            return;
        }
        this.internalValidate(command, viewSymbols);
        if (this.updateInfo.deleteType != UpdateType.INHERENT) {
            this.deleteReport.getItems().clear();
            this.updateInfo.deleteValidationError = null;
        }
        if (this.updateInfo.updateType != UpdateType.INHERENT) {
            this.updateReport.getItems().clear();
            this.updateInfo.updateValidationError = null;
        }
        if (this.updateInfo.insertType != UpdateType.INHERENT) {
            this.insertReport.getItems().clear();
            this.updateInfo.insertValidationError = null;
        }
    }

    private void internalValidate(Command command, List<ElementSymbol> viewSymbols) throws Exception {
        if (!(command instanceof Query)) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0001, new Object[0]), true, true, true);
            return;
        }
        Query query = (Query)command;
        if (query.getFrom() == null || query.getInto() != null) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0001, new Object[0]), true, true, true);
            return;
        }
        if (query.getWith() != null) {
            String warning = Messages.getString(Messages.ERR.ERR_015_012_0002, new Object[0]);
            this.updateReport.handleValidationWarning(warning);
            this.deleteReport.handleValidationWarning(warning);
            this.updateInfo.isSimple = false;
        }
        if (query.hasAggregates()) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0006, new Object[0]), true, true, true);
            return;
        }
        if (query.getLimit() != null) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0013, new Object[0]), true, true, true);
            return;
        }
        if (query.getSelect().isDistinct()) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0008, new Object[0]), true, true, true);
            return;
        }
        this.updateInfo.view = query;
        List<Expression> projectedSymbols = query.getSelect().getProjectedSymbols();
        int i = 0;
        while (i < projectedSymbols.size()) {
            Expression symbol = projectedSymbols.get(i);
            Expression ex = SymbolMap.getExpression(symbol);
            if (this.metadata.elementSupports(viewSymbols.get(i).getMetadataID(), 5)) {
                if (ex instanceof ElementSymbol) {
                    Object es = (ElementSymbol)ex;
                    String groupName = ((ElementSymbol)es).getGroupSymbol().getName();
                    UpdateMapping info = (UpdateMapping)this.updateInfo.updatableGroups.get(groupName);
                    if (((ElementSymbol)es).getGroupSymbol().getDefinition() != null) {
                        ElementSymbol clone = ((ElementSymbol)es).clone();
                        clone.setOutputName(null);
                        clone.getGroupSymbol().setName(clone.getGroupSymbol().getNonCorrelationName());
                        clone.getGroupSymbol().setDefinition(null);
                        es = clone;
                    }
                    if (info == null) {
                        info = new UpdateMapping();
                        info.group = ((ElementSymbol)es).getGroupSymbol();
                        info.correlatedName = ((ElementSymbol)ex).getGroupSymbol();
                        this.updateInfo.updatableGroups.put(groupName, info);
                    }
                    info.updatableViewSymbols.put(viewSymbols.get(i), es);
                } else {
                    this.report.handleValidationWarning(Messages.getString(Messages.ERR.ERR_015_012_0007, viewSymbols.get(i), symbol));
                }
            }
            ++i;
        }
        if (query.getFrom().getClauses().size() > 1 || !(query.getFrom().getClauses().get(0) instanceof UnaryFromClause)) {
            String warning = Messages.getString(Messages.ERR.ERR_015_012_0009, query.getFrom());
            this.updateReport.handleValidationWarning(warning);
            this.deleteReport.handleValidationWarning(warning);
            this.updateInfo.isSimple = false;
        }
        List<GroupSymbol> allGroups = query.getFrom().getGroups();
        HashSet<GroupSymbol> keyPreservingGroups = new HashSet<GroupSymbol>();
        ResolverUtil.findKeyPreserved(query, keyPreservingGroups, this.metadata);
        for (GroupSymbol groupSymbol : keyPreservingGroups) {
            this.setUpdateFlags(groupSymbol);
        }
        allGroups.removeAll(keyPreservingGroups);
        if (this.updateInfo.isSimple) {
            if (!allGroups.isEmpty()) {
                this.setUpdateFlags(allGroups.iterator().next());
            }
        } else {
            for (GroupSymbol groupSymbol : allGroups) {
                UpdateMapping info = (UpdateMapping)this.updateInfo.updatableGroups.get(groupSymbol.getName());
                if (info == null) continue;
                String warning = Messages.getString(Messages.ERR.ERR_015_012_0004, info.correlatedName);
                this.report.handleValidationWarning(warning);
            }
        }
        boolean updatable = false;
        boolean insertable = false;
        for (UpdateMapping info : this.updateInfo.updatableGroups.values()) {
            if (info.updateAllowed) {
                if (!updatable) {
                    this.updateInfo.deleteTarget = info;
                } else if (!info.getGroup().equals(this.updateInfo.deleteTarget.getGroup())) {
                    this.updateInfo.deleteTarget = null;
                }
            }
            updatable |= info.updateAllowed;
            insertable |= info.insertAllowed;
        }
        if (this.updateInfo.insertType == UpdateType.INHERENT && !insertable) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0015, new Object[0]), false, true, false);
        }
        if (this.updateInfo.updateType == UpdateType.INHERENT && !updatable) {
            this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0005, new Object[0]), true, false, false);
        }
        if (this.updateInfo.deleteType == UpdateType.INHERENT && this.updateInfo.deleteTarget == null) {
            if (this.updateInfo.isSimple && updatable) {
                this.updateInfo.deleteTarget = (UpdateMapping)this.updateInfo.updatableGroups.values().iterator().next();
            } else {
                this.handleValidationError(Messages.getString(Messages.ERR.ERR_015_012_0014, new Object[0]), false, false, true);
            }
        }
    }

    private void setUpdateFlags(GroupSymbol groupSymbol) throws Exception {
        UpdateMapping info = (UpdateMapping)this.updateInfo.updatableGroups.get(groupSymbol.getName());
        if (info == null) {
            return;
        }
        if (!this.metadata.groupSupports(groupSymbol.getMetadataID(), 0)) {
            this.report.handleValidationWarning(Messages.getString(Messages.ERR.ERR_015_012_0003, groupSymbol));
            return;
        }
        info.insertAllowed = true;
        for (ElementSymbol es : ResolverUtil.resolveElementsInGroup(info.group, this.metadata)) {
            if (info.updatableViewSymbols.values().contains(es) || this.validateInsertElement(es)) continue;
            info.insertAllowed = false;
        }
        info.updateAllowed = true;
    }

    private boolean validateInsertElement(ElementSymbol element) throws Exception {
        if (this.metadata.elementSupports(element.getMetadataID(), 4) || this.metadata.elementSupports(element.getMetadataID(), 7) || this.metadata.elementSupports(element.getMetadataID(), 8)) {
            return true;
        }
        if (this.updateInfo.insertType == UpdateType.INHERENT) {
            this.insertReport.handleValidationWarning(Messages.getString(Messages.ERR.ERR_015_012_0010, element, element.getGroupSymbol()));
        }
        return false;
    }

    public static class UpdateInfo {
        private Map<String, UpdateMapping> updatableGroups = new HashMap<String, UpdateMapping>();
        private boolean isSimple = true;
        private UpdateMapping deleteTarget;
        private UpdateType updateType;
        private String updateValidationError;
        private UpdateType deleteType;
        private String deleteValidationError;
        private UpdateType insertType;
        private String insertValidationError;
        private Query view;
        private Map<ElementSymbol, List<Set<Constant>>> partitionInfo;
        private List<UpdateInfo> unionBranches = new LinkedList<UpdateInfo>();

        public Map<ElementSymbol, List<Set<Constant>>> getPartitionInfo() {
            return this.partitionInfo;
        }

        public boolean isSimple() {
            return this.isSimple;
        }

        public UpdateMapping getDeleteTarget() {
            return this.deleteTarget;
        }

        public boolean isInherentDelete() {
            return this.deleteType == UpdateType.INHERENT;
        }

        public boolean isInherentInsert() {
            return this.insertType == UpdateType.INHERENT;
        }

        public boolean isInherentUpdate() {
            return this.updateType == UpdateType.INHERENT;
        }

        public UpdateType getUpdateType() {
            return this.updateType;
        }

        public UpdateType getDeleteType() {
            return this.deleteType;
        }

        public boolean hasValidUpdateMapping(Collection<ElementSymbol> updateCols) {
            if (this.findUpdateMapping(updateCols, false) == null) {
                return false;
            }
            for (UpdateInfo info : this.unionBranches) {
                if (info.findUpdateMapping(updateCols, false) != null) continue;
                return false;
            }
            return true;
        }

        public UpdateMapping findUpdateMapping(Collection<ElementSymbol> updateCols, boolean insert) {
            if (updateCols.isEmpty() && this.updatableGroups.size() > 1) {
                return null;
            }
            for (UpdateMapping entry : this.updatableGroups.values()) {
                if ((!insert || !entry.insertAllowed) && (insert || !entry.updateAllowed) || !entry.updatableViewSymbols.keySet().containsAll(updateCols)) continue;
                return entry;
            }
            return null;
        }

        public UpdateMapping findInsertUpdateMapping(Insert insert, boolean rewrite) throws Exception {
            if (this.getUnionBranches().isEmpty()) {
                return this.findUpdateMapping(insert.getVariables(), true);
            }
            if (insert.getQueryExpression() != null) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30239, insert.getGroup()));
            }
            int partition = -1;
            LinkedList<ElementSymbol> filteredColumns = new LinkedList<ElementSymbol>();
            for (Map.Entry<ElementSymbol, List<Set<Constant>>> entry : this.partitionInfo.entrySet()) {
                Expression value;
                int index = insert.getVariables().indexOf(entry.getKey());
                if (index == -1 || !((value = insert.getValues().get(index)) instanceof Constant)) continue;
                int i = 0;
                while (i < entry.getValue().size()) {
                    if (entry.getValue().get(i).contains(value)) {
                        if (entry.getValue().get(i).size() == 1) {
                            filteredColumns.add(entry.getKey());
                        }
                        if (partition == -1) {
                            partition = i;
                        } else if (partition != i) {
                            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30240, insert.getGroup(), insert.getVariables()));
                        }
                    }
                    ++i;
                }
            }
            if (partition == -1) {
                throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID30241, insert.getGroup(), insert.getVariables()));
            }
            UpdateInfo info = this;
            if (partition > 0) {
                info = info.getUnionBranches().get(partition - 1);
            }
            ArrayList<ElementSymbol> variables = new ArrayList<ElementSymbol>(insert.getVariables());
            variables.removeAll(filteredColumns);
            UpdateMapping mapping = info.findUpdateMapping(variables, true);
            if (rewrite && mapping != null && !filteredColumns.isEmpty()) {
                for (ElementSymbol elementSymbol : filteredColumns) {
                    if (mapping.getUpdatableViewSymbols().containsKey(elementSymbol)) continue;
                    int index = insert.getVariables().indexOf(elementSymbol);
                    insert.getVariables().remove(index);
                    if (!rewrite) continue;
                    insert.getValues().remove(index);
                }
            }
            return mapping;
        }

        public Query getViewDefinition() {
            return this.view;
        }

        public String getDeleteValidationError() {
            return this.deleteValidationError;
        }

        public String getInsertValidationError() {
            return this.insertValidationError;
        }

        public String getUpdateValidationError() {
            return this.updateValidationError;
        }

        public List<UpdateInfo> getUnionBranches() {
            return this.unionBranches;
        }

        private void setUpdateValidationError(String updateValidationError) {
            if (this.updateValidationError == null) {
                this.updateValidationError = updateValidationError;
            }
        }

        private void setInsertValidationError(String insertValidationError) {
            if (this.insertValidationError == null) {
                this.insertValidationError = insertValidationError;
            }
        }

        private void setDeleteValidationError(String deleteValidationError) {
            if (this.deleteValidationError == null) {
                this.deleteValidationError = deleteValidationError;
            }
        }
    }

    public static class UpdateMapping {
        private GroupSymbol group;
        private GroupSymbol correlatedName;
        private Map<ElementSymbol, ElementSymbol> updatableViewSymbols = new HashMap<ElementSymbol, ElementSymbol>();
        private boolean insertAllowed = false;
        private boolean updateAllowed = false;

        public Map<ElementSymbol, ElementSymbol> getUpdatableViewSymbols() {
            return this.updatableViewSymbols;
        }

        public boolean isInsertAllowed() {
            return this.insertAllowed;
        }

        public boolean isUpdateAllowed() {
            return this.updateAllowed;
        }

        public GroupSymbol getGroup() {
            return this.group;
        }

        public GroupSymbol getCorrelatedName() {
            return this.correlatedName;
        }
    }

    public static enum UpdateType {
        INHERENT,
        INSTEAD_OF;

    }
}

