/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.designer.query.sql.symbol.IReference;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.SimpleNode;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class Reference
extends SimpleNode
implements Expression,
IReference<LanguageVisitor> {
    private int refIndex;
    private Class<?> type;
    private ElementSymbol expression;
    private boolean positional;
    private boolean optional;
    private Constraint constraint;

    public Reference(TeiidParser p, int id) {
        super(p, id);
    }

    @Override
    public Class<?> getType() {
        if (this.isPositional() && this.expression == null) {
            return this.type;
        }
        return this.expression.getType();
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public boolean isCorrelated() {
        if (this.isPositional()) {
            return false;
        }
        if (this.expression.getGroupSymbol() == null || !(this.expression.getGroupSymbol().getMetadataID() instanceof TempMetadataID)) {
            return true;
        }
        TempMetadataID tid = (TempMetadataID)this.expression.getGroupSymbol().getMetadataID();
        return !tid.isScalarGroup();
    }

    public boolean isPositional() {
        return this.positional;
    }

    public void setPositional(boolean positional) {
        this.positional = positional;
    }

    public ElementSymbol getExpression() {
        return this.expression;
    }

    public void setExpression(ElementSymbol expression) {
        this.expression = expression;
    }

    public int getIndex() {
        return this.refIndex;
    }

    public void setIndex(int refIndex) {
        this.refIndex = refIndex;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.expression == null ? 0 : this.expression.hashCode());
        result = 31 * result + (this.positional ? 1231 : 1237);
        result = 31 * result + this.refIndex;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reference other = (Reference)obj;
        if (this.expression == null ? other.expression != null : !this.expression.equals(other.expression)) {
            return false;
        }
        if (this.positional != other.positional) {
            return false;
        }
        if (this.refIndex != other.refIndex) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Reference clone() {
        Reference clone = new Reference(this.parser, this.id);
        if (this.getExpression() != null) {
            clone.setExpression(this.getExpression().clone());
        }
        if (this.type != null) {
            clone.setType(this.type);
        }
        clone.setPositional(this.isPositional());
        clone.setIndex(this.getIndex());
        clone.setConstraint(clone.getConstraint());
        return clone;
    }

    public static interface Constraint {
        public void validate(Object var1) throws Exception;
    }
}

