/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.designer.query.sql.lang.ISPParameter;
import org.teiid.designer.query.sql.lang.IStoredProcedure;
import org.teiid.query.parser.LanguageVisitor;
import org.teiid.query.parser.TeiidNodeFactory;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.TargetedCommand;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.runtime.client.Messages;

public class StoredProcedure
extends ProcedureContainer
implements TargetedCommand,
IStoredProcedure<SPParameter, Expression, LanguageVisitor> {
    private Map<Integer, SPParameter> mapOfParameters = new TreeMap<Integer, SPParameter>();
    private Integer resultSetParameterKey;
    private boolean isCallableStatement;
    private boolean calledWithReturn;
    private boolean displayNamedParameters;
    private boolean isProcedureRelational;
    private String procedureName;
    private String callableName;
    private GroupSymbol groupSymbol;
    private Object procedureID;
    private Object modelID;

    public StoredProcedure(TeiidParser p, int id) {
        super(p, id);
    }

    public int getType() {
        return 6;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public void setProcedureID(Object procedureID) {
        this.procedureID = procedureID;
    }

    public Object getProcedureID() {
        return this.procedureID;
    }

    public String getProcedureCallableName() {
        return this.callableName != null ? this.callableName : this.procedureName;
    }

    public void setProcedureCallableName(String callableName) {
        this.callableName = callableName;
    }

    public boolean isCallableStatement() {
        return this.isCallableStatement;
    }

    public void setCallableStatement(boolean isCallableStatement) {
        this.isCallableStatement = isCallableStatement;
    }

    private SPParameter getResultSetParameter() {
        if (this.resultSetParameterKey != null) {
            return this.mapOfParameters.get(this.resultSetParameterKey);
        }
        return null;
    }

    public Collection<SPParameter> getParameters() {
        return this.mapOfParameters.values();
    }

    public SPParameter getParameter(int index) {
        return this.mapOfParameters.get(new Integer(index));
    }

    public int getParameterCount() {
        return this.mapOfParameters.size();
    }

    public void setParameter(SPParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_015_010_0011, new Object[0]));
        }
        Integer key = parameter.getIndex();
        if (parameter.getParameterType() == ISPParameter.ParameterInfo.RESULT_SET.index()) {
            this.resultSetParameterKey = key;
        }
        this.mapOfParameters.put(key, parameter);
    }

    public void clearParameters() {
        this.mapOfParameters.clear();
    }

    public void setCalledWithReturn(boolean calledWithReturn) {
        this.calledWithReturn = calledWithReturn;
    }

    public boolean isCalledWithReturn() {
        return this.calledWithReturn;
    }

    public boolean isDisplayNamedParameters() {
        return this.displayNamedParameters;
    }

    public void setDisplayNamedParameters(boolean displayNamedParameters) {
        this.displayNamedParameters = displayNamedParameters;
    }

    public boolean isProcedureRelational() {
        return this.isProcedureRelational;
    }

    public void setProcedureRelational(boolean isProcedureRelational) {
        this.isProcedureRelational = isProcedureRelational;
    }

    @Override
    public boolean returnsResultSet() {
        SPParameter param = this.getResultSetParameter();
        return param != null && !param.getResultSetColumns().isEmpty();
    }

    public boolean returnParameters() {
        return this.isCallableStatement || !this.returnsResultSet();
    }

    public GroupSymbol getGroupSymbol() {
        if (this.groupSymbol == null) {
            this.groupSymbol = (GroupSymbol)this.parser.createASTNode(TeiidNodeFactory.ASTNodes.GROUP_SYMBOL);
            this.groupSymbol.setName(this.getProcedureCallableName());
        }
        return this.groupSymbol;
    }

    public void setGroupSymbol(GroupSymbol group) {
        this.groupSymbol = group;
    }

    @Override
    public GroupSymbol getGroup() {
        return this.getGroupSymbol();
    }

    public void setGroup(GroupSymbol group) {
        this.setGroupSymbol(group);
    }

    public String getGroupName() {
        return this.getGroupSymbol().getName();
    }

    public List<ElementSymbol> getResultSetColumns() {
        SPParameter resultSetParameter = this.getResultSetParameter();
        if (resultSetParameter != null) {
            ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>(resultSetParameter.getResultSetColumns().size());
            Iterator<ElementSymbol> i = resultSetParameter.getResultSetColumns().iterator();
            while (i.hasNext()) {
                ElementSymbol symbol = i.next().clone();
                symbol.setGroupSymbol(this.getGroupSymbol());
                result.add(symbol);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List getProjectedSymbols() {
        if (!this.returnParameters()) {
            return this.getResultSetColumns();
        }
        ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>(this.getResultSetColumns());
        for (SPParameter parameter : this.mapOfParameters.values()) {
            ElementSymbol symbol;
            if (parameter.getParameterType() == ISPParameter.ParameterInfo.RETURN_VALUE.index()) {
                symbol = parameter.getParameterSymbol();
                symbol.setGroupSymbol(this.getGroupSymbol());
                result.add(0, symbol);
                continue;
            }
            if (parameter.getParameterType() != ISPParameter.ParameterInfo.INOUT.index() && parameter.getParameterType() != ISPParameter.ParameterInfo.OUT.index()) continue;
            symbol = parameter.getParameterSymbol();
            symbol.setGroupSymbol(this.getGroupSymbol());
            result.add(symbol);
        }
        return result;
    }

    public List<SPParameter> getInputParameters() {
        ArrayList<SPParameter> parameters = new ArrayList<SPParameter>(this.getParameters());
        Iterator params = parameters.iterator();
        while (params.hasNext()) {
            SPParameter param = (SPParameter)params.next();
            if (param.getParameterType() == ISPParameter.ParameterInfo.IN.index() || param.getParameterType() == ISPParameter.ParameterInfo.INOUT.index()) continue;
            params.remove();
        }
        return parameters;
    }

    public Object getModelID() {
        return this.modelID;
    }

    public void setModelID(Object modelID) {
        this.modelID = modelID;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.calledWithReturn ? 1231 : 1237);
        result = 31 * result + (this.displayNamedParameters ? 1231 : 1237);
        result = 31 * result + (this.isCallableStatement ? 1231 : 1237);
        result = 31 * result + (this.isProcedureRelational ? 1231 : 1237);
        result = 31 * result + (this.mapOfParameters == null ? 0 : this.mapOfParameters.hashCode());
        result = 31 * result + (this.procedureName == null ? 0 : this.procedureName.hashCode());
        result = 31 * result + (this.resultSetParameterKey == null ? 0 : this.resultSetParameterKey.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredProcedure other = (StoredProcedure)obj;
        if (this.calledWithReturn != other.calledWithReturn) {
            return false;
        }
        if (this.displayNamedParameters != other.displayNamedParameters) {
            return false;
        }
        if (this.isCallableStatement != other.isCallableStatement) {
            return false;
        }
        if (this.isProcedureRelational != other.isProcedureRelational) {
            return false;
        }
        if (this.mapOfParameters == null ? other.mapOfParameters != null : !this.mapOfParameters.equals(other.mapOfParameters)) {
            return false;
        }
        if (this.procedureName == null ? other.procedureName != null : !this.procedureName.equals(other.procedureName)) {
            return false;
        }
        return !(this.resultSetParameterKey == null ? other.resultSetParameterKey != null : !this.resultSetParameterKey.equals(other.resultSetParameterKey));
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StoredProcedure clone() {
        StoredProcedure clone = new StoredProcedure(this.parser, this.id);
        if (this.getProcedureName() != null) {
            clone.setProcedureName(this.getProcedureName());
        }
        clone.setCallableStatement(this.isCallableStatement());
        if (this.getParameters() != null) {
            for (SPParameter parameter : this.getParameters()) {
                clone.setParameter(parameter.clone());
            }
        }
        clone.setCalledWithReturn(this.isCalledWithReturn());
        clone.setDisplayNamedParameters(this.isDisplayNamedParameters());
        clone.setProcedureRelational(this.isProcedureRelational());
        if (this.getSourceHint() != null) {
            clone.setSourceHint(this.getSourceHint());
        }
        if (this.getOption() != null) {
            clone.setOption(this.getOption().clone());
        }
        this.copyMetadataState(clone);
        return clone;
    }
}

