/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.metadata.FunctionMethod;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.translator.CacheDirective;

public class CacheHint
extends CacheDirective {
    private static final long serialVersionUID = -4119606289701982511L;
    public static final String PREF_MEM = "pref_mem";
    public static final String TTL = "ttl:";
    public static final String UPDATABLE = "updatable";
    public static final String CACHE = "cache";
    public static final String SCOPE = "scope:";

    public CacheHint(TeiidParser parser) {
        super(parser);
    }

    public CacheHint(TeiidParser teiidParser, Boolean prefersMemory, Long ttl) {
        super(teiidParser, prefersMemory, ttl);
    }

    public boolean isPrefersMemory() {
        if (this.getPrefersMemory() != null) {
            return this.getPrefersMemory();
        }
        return false;
    }

    public String toString() {
        SQLStringVisitor ssv = new SQLStringVisitor(this.getTeiidParser().getVersion());
        ssv.addCacheHint(this);
        return ssv.getSQLString();
    }

    public FunctionMethod.Determinism getDeterminism() {
        if (this.getScope() == null) {
            return null;
        }
        switch (this.getScope()) {
            case SESSION: {
                return FunctionMethod.Determinism.SESSION_DETERMINISTIC;
            }
            case VDB: {
                return FunctionMethod.Determinism.VDB_DETERMINISTIC;
            }
        }
        return FunctionMethod.Determinism.USER_DETERMINISTIC;
    }

    public void setScope(String scope) {
        if (scope == null) {
            this.setScope((CacheDirective.Scope)null);
        } else {
            this.setScope(CacheDirective.Scope.valueOf(scope.toUpperCase()));
        }
    }

    public boolean isUpdatable(boolean b) {
        if (this.getUpdatable() != null) {
            return this.getUpdatable();
        }
        return b;
    }

    public CacheHint clone() {
        CacheHint copy = new CacheHint(this.getTeiidParser());
        copy.setInvalidation(this.getInvalidation());
        copy.setPrefersMemory(this.getPrefersMemory());
        copy.setReadAll(this.getReadAll());
        copy.setScope(this.getScope());
        copy.setTtl(this.getTtl());
        copy.setUpdatable(this.getUpdatable());
        return copy;
    }
}

