/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.proc.wsdl;

import java.util.Properties;
import org.teiid.designer.query.proc.wsdl.IWsdlAttributeInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlColumnInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlConstants;
import org.teiid.designer.query.proc.wsdl.IWsdlProcedureInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlRequestInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlResponseInfo;
import org.teiid.designer.query.proc.wsdl.IWsdlWrapperInfo;
import org.teiid.designer.query.sql.ISQLConstants;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.query.proc.wsdl.AbstractWsdlHelper;

public class WsdlWrapperHelper
extends AbstractWsdlHelper
implements IWsdlConstants,
ISQLConstants {
    private final IWsdlWrapperInfo wrapperInfo;
    private final IWsdlRequestInfo requestInfo;
    private final IWsdlResponseInfo responseInfo;

    public WsdlWrapperHelper(ITeiidServerVersion teiidVersion, IWsdlWrapperInfo wrapperInfo) {
        super(teiidVersion);
        this.wrapperInfo = wrapperInfo;
        this.requestInfo = wrapperInfo.getRequestInfo();
        this.responseInfo = wrapperInfo.getResponseInfo();
    }

    private String getWrapperProcedureParameterName(String parameterName) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.wrapperInfo.getViewModelName());
        builder.append(".").append(this.wrapperInfo.getWrapperProcedureName()).append(".").append(parameterName);
        return builder.toString();
    }

    private String getProcedureFullName(IWsdlProcedureInfo info) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.wrapperInfo.getViewModelName());
        builder.append('.').append(info.getProcedureName());
        return builder.toString();
    }

    private String getModelNameWithoutExtension(String modelName) {
        String name = modelName;
        if (name.endsWith(".xmi")) {
            name = name.substring(0, name.lastIndexOf(".xmi"));
        }
        return name;
    }

    private String getParameterFullName(String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.wrapperInfo.getViewModelName());
        builder.append('.').append(this.wrapperInfo.getWrapperProcedureName()).append('.').append(this.convertSqlNameSegment(name));
        return builder.toString();
    }

    public String getWrapperStatement() {
        IWsdlColumnInfo[] reqBodyColumnInfoList = this.requestInfo.getBodyColumnInfoList();
        StringBuilder sb = new StringBuilder();
        String tableAlias = "t";
        sb.append("CREATE VIRTUAL PROCEDURE\nBEGIN\n");
        sb.append("\t").append("SELECT").append(" ").append(tableAlias).append(".").append("*").append(" ").append("FROM").append("\n");
        sb.append("\t").append("\t").append("TABLE(EXEC ");
        sb.append(this.getModelNameWithoutExtension(this.wrapperInfo.getViewModelName()));
        sb.append(".").append(this.requestInfo.getProcedureName());
        sb.append("(");
        int nColumns = reqBodyColumnInfoList.length;
        int i = 0;
        IWsdlColumnInfo[] iWsdlColumnInfoArray = reqBodyColumnInfoList;
        int n = reqBodyColumnInfoList.length;
        int n2 = 0;
        while (n2 < n) {
            IWsdlColumnInfo columnInfo = iWsdlColumnInfoArray[n2];
            String name = columnInfo.getSymbolName();
            sb.append(this.getParameterFullName(name));
            int nAttributes = columnInfo.getAttributeInfoArray().length;
            if (nAttributes > 0) {
                int index = 0;
                sb.append(",").append(" ");
                IWsdlAttributeInfo[] iWsdlAttributeInfoArray = columnInfo.getAttributeInfoArray();
                int n3 = iWsdlAttributeInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWsdlAttributeInfo attrInfo = iWsdlAttributeInfoArray[n4];
                    sb.append(this.getParameterFullName(attrInfo.getSymbolName()));
                    if (nAttributes > 1 && index < nAttributes - 1) {
                        sb.append(",").append(" ");
                    }
                    ++index;
                    ++n4;
                }
            }
            if (i < nColumns - 1) {
                sb.append(",").append(" ");
            }
            ++i;
            ++n2;
        }
        sb.append(")").append("\n");
        sb.append("\t").append("AS").append(" ").append("request").append(",").append("\n");
        sb.append("\t").append("\t").append("TABLE(EXEC ").append(this.getModelNameWithoutExtension(this.wrapperInfo.getSourceModelName())).append(".").append("invoke('").append(this.wrapperInfo.getBindingType()).append("', null, REQUEST.xml_out, null, TRUE))").append("\n");
        sb.append("\t").append("AS").append(" ").append("response").append(",").append("\n");
        sb.append("\t").append("\t").append("TABLE(EXEC ").append(this.getModelNameWithoutExtension(this.wrapperInfo.getViewModelName())).append(".").append(this.responseInfo.getProcedureName()).append("(").append("RESPONSE").append(".").append("result").append(")").append(")").append("\n");
        sb.append("\t").append("AS").append(" ").append(tableAlias).append(";").append("\n");
        sb.append("\nEND");
        return sb.toString();
    }

    public String getWrapperProcedureStatement(Properties properties) {
        IWsdlColumnInfo columnInfo;
        IWsdlColumnInfo[] reqBodyColumnInfoList = this.requestInfo.getBodyColumnInfoList();
        StringBuilder sb = new StringBuilder();
        String tableAlias = "t";
        sb.append("CREATE VIRTUAL PROCEDURE\nBEGIN\n");
        sb.append("\t").append("SELECT").append(" ").append(tableAlias).append(".").append("*").append(" ").append("FROM").append("\n");
        sb.append("\t\t").append("TABLE").append("(").append("EXEC").append(" ");
        sb.append(this.getProcedureFullName((IWsdlProcedureInfo)this.requestInfo));
        sb.append("(");
        int i = 0;
        int nColumns = reqBodyColumnInfoList.length;
        int hColumns = this.requestInfo.getHeaderColumnInfoList().length;
        IWsdlColumnInfo[] iWsdlColumnInfoArray = this.requestInfo.getHeaderColumnInfoList();
        int n = iWsdlColumnInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            columnInfo = iWsdlColumnInfoArray[n2];
            String nameSegment = this.convertSqlNameSegment(columnInfo.getSymbolName());
            sb.append("\t\t\t\t").append(this.getWrapperProcedureParameterName(nameSegment));
            if (i < hColumns - 1) {
                sb.append(",").append(" ").append("\n");
            }
            ++i;
            ++n2;
        }
        i = 0;
        nColumns = reqBodyColumnInfoList.length;
        if (hColumns > 0) {
            sb.append(",");
        }
        iWsdlColumnInfoArray = reqBodyColumnInfoList;
        n = reqBodyColumnInfoList.length;
        n2 = 0;
        while (n2 < n) {
            columnInfo = iWsdlColumnInfoArray[n2];
            int nAttributes = columnInfo.getAttributeInfoArray().length;
            String nameSegment = this.convertSqlNameSegment(columnInfo.getSymbolName());
            sb.append("\t\t\t\t").append(this.getWrapperProcedureParameterName(nameSegment));
            if (i < nColumns - 1) {
                sb.append(",").append(" ").append("\n");
            }
            ++i;
            if (nAttributes > 0) {
                int index = 0;
                sb.append(",").append(" ");
                IWsdlAttributeInfo[] iWsdlAttributeInfoArray = columnInfo.getAttributeInfoArray();
                int n3 = iWsdlAttributeInfoArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWsdlAttributeInfo attrInfo = iWsdlAttributeInfoArray[n4];
                    String attrNameSegment = this.convertSqlNameSegment(attrInfo.getSymbolName());
                    sb.append("\t\t\t\t").append(this.getWrapperProcedureParameterName(attrNameSegment));
                    if (nAttributes > 1 && index < nAttributes - 1) {
                        sb.append(",").append(" ");
                    }
                    ++index;
                    ++n4;
                }
            }
            ++n2;
        }
        sb.append(")");
        sb.append(")").append("\n").append("\t\t\t\t").append("AS").append(" ").append("request").append(",").append("\n");
        sb.append("\t\t").append("TABLE").append("(").append("EXEC").append(" ");
        sb.append(this.getModelNameWithoutExtension(this.wrapperInfo.getSourceModelName())).append(".");
        String actionStr = "'" + this.wrapperInfo.getSoapAction() + "'";
        sb.append("invoke");
        sb.append("(").append("binding").append("=>").append("'").append(this.wrapperInfo.getBindingType()).append("'").append(",").append(" ").append("action").append("=>").append(" ").append(actionStr).append(",").append(" ").append("request").append("=>").append("REQUEST").append(".").append(XML_OUT).append(",").append(" ").append("endpoint").append("=>").append("null").append(",").append(" ").append("stream").append("=>").append("TRUE").append(")");
        sb.append(")").append("\n").append("\t\t\t\t").append("AS").append(" ").append("response").append(",").append("\n");
        sb.append("\t\t").append("TABLE").append("(").append("EXEC").append(" ");
        sb.append(this.getProcedureFullName((IWsdlProcedureInfo)this.responseInfo));
        sb.append("(").append("RESPONSE").append(".").append("result").append(")").append(")").append("\n");
        sb.append("\t\t\t\t").append("AS").append(" ").append(tableAlias).append(";");
        sb.append("\nEND");
        return sb.toString();
    }
}

