/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.designer.query.metadata.IQueryMetadataInterface;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Table;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.client.Messages;

public class SystemMetadata {
    private static Map<ITeiidServerVersion, SystemMetadata> instances = new HashMap<ITeiidServerVersion, SystemMetadata>();
    private final ITeiidServerVersion teiidVersion;
    private final DataTypeManagerService dataTypeManager;
    private List<Datatype> dataTypes = new ArrayList<Datatype>();
    private Map<String, Datatype> typeMap = new TreeMap<String, Datatype>(String.CASE_INSENSITIVE_ORDER);
    private MetadataStore systemStore;

    public static SystemMetadata getInstance(ITeiidServerVersion teiidVersion) {
        SystemMetadata instance = instances.get(teiidVersion);
        if (instance == null) {
            instance = new SystemMetadata(teiidVersion);
            instances.put(teiidVersion, instance);
        }
        return instance;
    }

    public SystemMetadata(ITeiidServerVersion teiidVersion) {
        if (teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_0.get())) {
            throw new UnsupportedOperationException(Messages.getString(Messages.Misc.TeiidVersionFailure, this.getClass().getSimpleName(), teiidVersion));
        }
        this.teiidVersion = teiidVersion;
        this.dataTypeManager = DataTypeManagerService.getInstance(teiidVersion);
        String resourceLocation = this.getClass().getPackage().getName();
        resourceLocation = resourceLocation.replaceAll("\\.", File.separator);
        resourceLocation = String.valueOf(resourceLocation) + File.separator;
        InputStream is = SystemMetadata.class.getClassLoader().getResourceAsStream(String.valueOf(resourceLocation) + "types.dat");
        try {
            try {
                InputStreamReader isr = new InputStreamReader(is, Charset.forName("UTF-8"));
                BufferedReader br = new BufferedReader(isr);
                String s = br.readLine();
                String[] props = s.split("\\|");
                while ((s = br.readLine()) != null) {
                    Datatype dt = new Datatype();
                    String[] vals = s.split("\\|");
                    Properties p = new Properties();
                    int i = 0;
                    while (i < props.length) {
                        if (vals[i].length() != 0) {
                            p.setProperty(props[i], new String(vals[i]));
                        }
                        ++i;
                    }
                    PropertiesUtils.setBeanProperties(dt, p, null);
                    if ("string".equals(dt.getName())) {
                        dt.setLength(DataTypeManagerService.MAX_STRING_LENGTH);
                    } else if ("varbinary".equals(dt.getName())) {
                        dt.setLength(DataTypeManagerService.MAX_LOB_MEMORY_BYTES);
                    }
                    this.dataTypes.add(dt);
                    if (!dt.isBuiltin()) continue;
                    this.typeMap.put(dt.getRuntimeTypeName(), dt);
                }
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.addAliasType(IDataTypeManagerService.DataTypeAliases.BIGINT);
        this.addAliasType(IDataTypeManagerService.DataTypeAliases.DECIMAL);
        this.addAliasType(IDataTypeManagerService.DataTypeAliases.REAL);
        this.addAliasType(IDataTypeManagerService.DataTypeAliases.SMALLINT);
        this.addAliasType(IDataTypeManagerService.DataTypeAliases.TINYINT);
        this.addAliasType(IDataTypeManagerService.DataTypeAliases.VARCHAR);
        for (String name : this.dataTypeManager.getAllDataTypeNames()) {
            if (name.equals(DataTypeManagerService.DefaultDataTypes.NULL.getId())) continue;
            ArgCheck.isNotNull(this.typeMap.get(name), name);
        }
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("System");
        vdb.setVersion(1);
        Properties p = new Properties();
        QueryParser parser = new QueryParser(teiidVersion);
        this.systemStore = this.loadSchema(vdb, p, resourceLocation, "SYS", parser).asMetadataStore();
        this.systemStore.addDataTypes(this.dataTypes);
        this.loadSchema(vdb, p, resourceLocation, "SYSADMIN", parser).mergeInto(this.systemStore);
        SystemFunctionManager systemFunctionManager = new SystemFunctionManager(teiidVersion, this.getClass().getClassLoader());
        TransformationMetadata tm = new TransformationMetadata(parser.getTeiidParser(), vdb, new CompositeMetadataStore(this.systemStore), null, systemFunctionManager.getSystemFunctions(), null);
        vdb.addAttchment(IQueryMetadataInterface.class, tm);
        MetadataValidator validator = new MetadataValidator(this.teiidVersion, this.typeMap);
        ValidatorReport report = validator.validate(vdb, this.systemStore);
        if (report.hasItems()) {
            throw new RuntimeException(report.getFailureMessage());
        }
    }

    private MetadataFactory loadSchema(VDBMetaData vdb, Properties p, String resourceLocation, String name, QueryParser parser) {
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName(name);
        vdb.addModel(mmd);
        InputStream is = SystemMetadata.class.getClassLoader().getResourceAsStream(String.valueOf(resourceLocation) + name + ".sql");
        try {
            MetadataFactory factory = new MetadataFactory(this.teiidVersion, vdb.getName(), vdb.getVersion(), name, this.typeMap, p, null);
            parser.parseDDL(factory, new InputStreamReader(is, Charset.forName("UTF-8")));
            for (Table t : factory.getSchema().getTables().values()) {
                t.setSystem(true);
            }
            MetadataFactory metadataFactory = factory;
            return metadataFactory;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addAliasType(IDataTypeManagerService.DataTypeAliases alias) {
        DataTypeManagerService.DefaultDataTypes dataType = this.dataTypeManager.getDataType(alias);
        String primaryType = dataType.getId();
        Datatype dt = this.typeMap.get(primaryType);
        ArgCheck.isNotNull(dt, alias.getId());
        this.typeMap.put(alias.getId(), dt);
    }

    public List<Datatype> getDataTypes() {
        return this.dataTypes;
    }

    public Map<String, Datatype> getRuntimeTypeMap() {
        return this.typeMap;
    }

    public MetadataStore getSystemStore() {
        return this.systemStore;
    }
}

