/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.teiid.designer.xml.IMappingElement;
import org.teiid.query.mapping.xml.MappingAttribute;
import org.teiid.query.mapping.xml.MappingBaseNode;
import org.teiid.query.mapping.xml.MappingCommentNode;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.mapping.xml.MappingNodeConstants;
import org.teiid.query.mapping.xml.MappingSourceNode;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Namespace;
import org.teiid.query.parser.TeiidParser;
import org.teiid.query.sql.symbol.ElementSymbol;

public class MappingElement
extends MappingBaseNode
implements IMappingElement<MappingAttribute, MappingNode> {
    ElementSymbol symbol;
    Namespace namespace;

    public MappingElement(TeiidParser teiidParser, String name) {
        this(teiidParser, name, MappingNodeConstants.NO_NAMESPACE);
    }

    public MappingElement(TeiidParser teiidParser, String name, String nameInSource) {
        this(teiidParser, name, MappingNodeConstants.NO_NAMESPACE);
        this.setNameInSource(nameInSource);
    }

    public MappingElement(TeiidParser teiidParser, String name, Namespace namespace) {
        super(teiidParser);
        this.setProperty(MappingNodeConstants.Properties.NAME, name);
        this.setProperty(MappingNodeConstants.Properties.NODE_TYPE, "element");
        this.namespace = namespace;
        if (namespace != MappingNodeConstants.NO_NAMESPACE) {
            this.setProperty(MappingNodeConstants.Properties.NAMESPACE_PREFIX, namespace.getPrefix());
        }
    }

    @Override
    public void acceptVisitor(MappingVisitor visitor) {
        visitor.visit(this);
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNameInSource(String srcName) {
        if (srcName != null) {
            this.setProperty(MappingNodeConstants.Properties.ELEMENT_NAME, srcName);
        }
    }

    public void setNillable(boolean nil) {
        this.setProperty(MappingNodeConstants.Properties.IS_NILLABLE, nil);
    }

    public void setDefaultValue(String value) {
        if (value != null) {
            this.setProperty(MappingNodeConstants.Properties.DEFAULT_VALUE, value);
        }
    }

    public void setValue(String value) {
        if (value != null) {
            this.setProperty(MappingNodeConstants.Properties.FIXED_VALUE, value);
        }
    }

    public void setOptional(boolean optional) {
        this.setProperty(MappingNodeConstants.Properties.IS_OPTIONAL, optional);
    }

    public void setNormalizeText(String normalize) {
        if (normalize != null) {
            this.setProperty(MappingNodeConstants.Properties.NORMALIZE_TEXT, normalize);
        }
    }

    public void setType(String type) {
        if (type != null) {
            this.setProperty(MappingNodeConstants.Properties.BUILT_IN_TYPE, type);
        }
    }

    public void setAlwaysInclude(boolean include) {
        this.setProperty(MappingNodeConstants.Properties.ALWAYS_INCLUDE, include);
    }

    public void addCommentNode(MappingCommentNode elem) {
        this.addChild(elem);
    }

    public void addCommentNode(String text) {
        this.addChild(new MappingCommentNode(this.getTeiidParser(), text));
    }

    public void addAttribute(MappingAttribute attr) {
        this.addChild(attr);
    }

    public void addSibilingElement(MappingElement elem) {
        this.getParent().addChild(elem);
    }

    public void removeAttribute(MappingAttribute toRemove) {
        List<MappingNode> children = this.getChildren();
        Iterator<MappingNode> i = children.iterator();
        while (i.hasNext()) {
            if (i.next() != toRemove) continue;
            i.remove();
            break;
        }
    }

    public void setNamespaces(Namespace[] spaces) {
        if (spaces != null && spaces.length > 0) {
            Properties props = new Properties();
            int i = 0;
            while (i < spaces.length) {
                props.put(spaces[i].getPrefix(), spaces[i].getUri());
                ++i;
            }
            this.setProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS, props);
        }
    }

    public void addNamespace(Namespace space) {
        if (space != null) {
            Properties props = (Properties)this.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
            if (props == null) {
                props = new Properties();
            }
            props.put(space.getPrefix(), space.getUri());
            this.setProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS, props);
        }
    }

    public List getAttributes() {
        return this.getChildren("attribute");
    }

    public boolean hasAttributes() {
        List attr = this.getAttributes();
        return attr != null && !attr.isEmpty();
    }

    public boolean isRecursive() {
        return false;
    }

    @Override
    public String getName() {
        return (String)this.getProperty(MappingNodeConstants.Properties.NAME);
    }

    public String getNamespacePrefix() {
        return (String)this.getProperty(MappingNodeConstants.Properties.NAMESPACE_PREFIX);
    }

    public Namespace[] getNamespaces() {
        ArrayList<Namespace> list = new ArrayList<Namespace>();
        Properties props = (Properties)this.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
        if (props != null && !props.isEmpty()) {
            for (String string : props.keySet()) {
                String value = props.getProperty(string);
                list.add(new Namespace(string, value));
            }
        }
        return list.toArray(new Namespace[list.size()]);
    }

    public Properties getNamespacesAsProperties() {
        Properties props = (Properties)this.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS);
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    @Override
    public String getNameInSource() {
        return (String)this.getProperty(MappingNodeConstants.Properties.ELEMENT_NAME);
    }

    public boolean isNillable() {
        Boolean nillable = (Boolean)this.getProperty(MappingNodeConstants.Properties.IS_NILLABLE);
        if (nillable != null) {
            return nillable;
        }
        return false;
    }

    public String getDefaultValue() {
        return (String)this.getProperty(MappingNodeConstants.Properties.DEFAULT_VALUE);
    }

    public String getValue() {
        return (String)this.getProperty(MappingNodeConstants.Properties.FIXED_VALUE);
    }

    public boolean isOptional() {
        Boolean optional = (Boolean)this.getProperty(MappingNodeConstants.Properties.IS_OPTIONAL);
        if (optional != null) {
            return optional;
        }
        return false;
    }

    public String getNormalizeText() {
        String text = (String)this.getProperty(MappingNodeConstants.Properties.NORMALIZE_TEXT);
        if (text == null) {
            text = "preserve";
        }
        return text;
    }

    public String getType() {
        return (String)this.getProperty(MappingNodeConstants.Properties.BUILT_IN_TYPE);
    }

    public boolean isAlwaysInclude() {
        Boolean include = (Boolean)this.getProperty(MappingNodeConstants.Properties.ALWAYS_INCLUDE);
        if (include != null) {
            return include;
        }
        return true;
    }

    @Override
    public boolean isTagRoot() {
        MappingBaseNode parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof MappingElement) {
                return false;
            }
            parent = parent.getParentNode();
        }
        return true;
    }

    public void setElementSymbol(ElementSymbol symbol) {
        this.symbol = symbol;
    }

    @Override
    public ElementSymbol getElementSymbol() {
        return this.symbol;
    }

    @Override
    public MappingSourceNode getSourceNode() {
        String nameInSource = this.getNameInSource();
        if (nameInSource != null) {
            String source = nameInSource.substring(0, nameInSource.lastIndexOf(46));
            MappingBaseNode parent = this.getParentNode();
            while (parent != null) {
                MappingSourceNode sourceNode;
                if (parent instanceof MappingSourceNode && (sourceNode = (MappingSourceNode)parent).getResultName().equalsIgnoreCase(source)) {
                    return sourceNode;
                }
                parent = parent.getParentNode();
            }
        }
        return super.getSourceNode();
    }

    @Override
    public MappingNode clone() {
        Properties p;
        MappingElement node = (MappingElement)super.clone();
        if (this.namespace != null) {
            node.namespace = new Namespace(this.namespace.getPrefix(), this.namespace.getUri());
        }
        if ((p = (Properties)this.getProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS)) != null) {
            node.setProperty(MappingNodeConstants.Properties.NAMESPACE_DECLARATIONS, p.clone());
        }
        return node;
    }
}

