/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.util.CommandContext;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

@Since(value=TeiidServerVersion.Version.TEIID_8_0)
public class SystemFunctionMethods {
    private static final int MAX_VARIABLES = 512;
    private static transient Map<String, Object> sessionVariables = Collections.synchronizedMap(new HashMap(2));

    @TeiidFunction(category="System", nullOnNull=true, determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC)
    public static Object teiid_session_get(CommandContext context, String key) {
        return context.getSessionVariable(key);
    }

    @TeiidFunction(category="System", determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC)
    public static Object teiid_session_set(CommandContext context, String key, Object value) throws Exception {
        if (sessionVariables.size() > 512 && !sessionVariables.containsKey(key)) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID31136, 512));
        }
        return context.setSessionVariable(key, value);
    }
}

