/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.Table;

public class Column
extends BaseColumn
implements Comparable<Column> {
    private static final long serialVersionUID = -1310120788764453726L;
    private boolean selectable = true;
    private boolean updatable;
    private boolean autoIncremented;
    private boolean caseSensitive;
    private boolean signed;
    private boolean currency;
    private boolean fixedLength;
    private SearchType searchType;
    private volatile String minimumValue;
    private volatile String maximumValue;
    private String nativeType;
    private String format;
    private int charOctetLength;
    private volatile int distinctValues = -1;
    private volatile int nullValues = -1;
    private ColumnSet<?> parent;

    public Column(ITeiidServerVersion teiidVersion) {
        super(teiidVersion);
    }

    @Override
    public void setDatatype(Datatype datatype, boolean copyAttributes, int arrayDimensions) {
        super.setDatatype(datatype, copyAttributes, arrayDimensions);
        if (datatype != null && copyAttributes) {
            this.signed = datatype.isSigned();
            this.autoIncremented = datatype.isAutoIncrement();
            this.caseSensitive = datatype.isCaseSensitive();
            this.signed = datatype.isSigned();
        }
    }

    public void setParent(ColumnSet<?> parent) {
        this.parent = parent;
    }

    @Override
    public ColumnSet<?> getParent() {
        return this.parent;
    }

    @Override
    public int compareTo(Column record) {
        return this.getPosition() - record.getPosition();
    }

    public int getCharOctetLength() {
        return this.charOctetLength;
    }

    public String getMaximumValue() {
        return this.maximumValue;
    }

    public String getMinimumValue() {
        return this.minimumValue;
    }

    public SearchType getSearchType() {
        if (this.searchType == null) {
            return this.getDatatype().getSearchType();
        }
        return this.searchType;
    }

    public boolean isSearchTypeSet() {
        return this.searchType != null;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isAutoIncremented() {
        return this.autoIncremented;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isFixedLength() {
        return this.fixedLength;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    @Override
    public String getNativeType() {
        return this.nativeType;
    }

    public int getNullValues() {
        if (this.nullValues >= -1) {
            return this.nullValues;
        }
        return Integer.MAX_VALUE;
    }

    public float getNullValuesAsFloat() {
        return Table.asFloat(this.nullValues);
    }

    public int getDistinctValues() {
        if (this.distinctValues >= -1) {
            return this.distinctValues;
        }
        return Integer.MAX_VALUE;
    }

    public float getDistinctValuesAsFloat() {
        return Table.asFloat(this.distinctValues);
    }

    public void setAutoIncremented(boolean b) {
        this.autoIncremented = b;
    }

    public void setCaseSensitive(boolean b) {
        this.caseSensitive = b;
    }

    public void setCharOctetLength(int i) {
        this.charOctetLength = i;
    }

    public void setCurrency(boolean b) {
        this.currency = b;
    }

    public void setFixedLength(boolean b) {
        this.fixedLength = b;
    }

    public void setMaximumValue(String object) {
        this.maximumValue = object;
    }

    public void setMinimumValue(String object) {
        this.minimumValue = object;
    }

    public void setSearchType(SearchType s) {
        this.searchType = s;
    }

    public void setSelectable(boolean b) {
        this.selectable = b;
    }

    public void setSigned(boolean b) {
        this.signed = b;
    }

    public void setUpdatable(boolean b) {
        this.updatable = b;
    }

    public void setFormat(String string) {
        this.format = string;
    }

    public void setDistinctValues(int distinctValues) {
        this.distinctValues = Table.asInt(distinctValues);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_7)
    public void setDistinctValues(long distinctValues) {
        this.distinctValues = Table.asInt(distinctValues);
    }

    public void setNullValues(int nullValues) {
        this.nullValues = Table.asInt(nullValues);
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_7)
    public void setNullValues(long nullValues) {
        this.nullValues = Table.asInt(nullValues);
    }

    @Override
    public void setNativeType(String nativeType) {
        this.nativeType = nativeType;
    }

    public void setColumnStats(ColumnStats stats) {
        if (stats.getDistinctValues() != null) {
            this.setDistinctValues(stats.getDistinctValues().longValue());
        }
        if (stats.getNullValues() != null) {
            this.setNullValues(stats.getNullValues().longValue());
        }
        if (stats.getMaximumValue() != null) {
            this.setMaximumValue(stats.getMaximumValue());
        }
        if (stats.getMinimumValue() != null) {
            this.setMinimumValue(stats.getMinimumValue());
        }
    }

    public static enum SearchType {
        Unsearchable,
        Like_Only{

            public String toString() {
                return "Like Only";
            }
        }
        ,
        All_Except_Like{

            public String toString() {
                return "All Except Like";
            }
        }
        ,
        Searchable;

    }
}

