/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.gss;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.gss.GSSCallbackHandler;
import org.teiid.gss.GssAction;
import org.teiid.net.CommunicationException;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class MakeGSS {
    private static Logger logger = Logger.getLogger("org.teiid.jdbc");

    public static LogonResult authenticate(ILogon logon, Properties props) throws LogonException, TeiidClientException, CommunicationException {
        String kerberosPrincipalName;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("GSS Authentication Request");
        }
        Object result = null;
        StringBuilder errors = new StringBuilder();
        String jaasApplicationName = props.getProperty("jaasName");
        String nl = System.getProperty("line.separator");
        if (jaasApplicationName == null) {
            errors.append(Messages.getString(Messages.GSS.client_prop_missing, "jaasName"));
            errors.append(nl);
        }
        if ((kerberosPrincipalName = props.getProperty("kerberosServicePrincipleName")) == null) {
            kerberosPrincipalName = "demo/host.example.com@EXAMPLE.COM";
        }
        String krb5 = System.getProperty("java.security.krb5.conf");
        String realm = System.getProperty("java.security.krb5.realm");
        String kdc = System.getProperty("java.security.krb5.kdc");
        if (krb5 == null && realm == null && kdc == null) {
            errors.append(Messages.getString(Messages.GSS.no_gss_selection, new Object[0]));
            errors.append(nl);
        } else if (krb5 != null && (realm != null || kdc != null)) {
            errors.append(Messages.getString(Messages.GSS.ambigious_gss_selection, new Object[0]));
            errors.append(nl);
        } else if (realm != null && kdc == null || realm == null && kdc != null) {
            if (realm == null) {
                errors.append(Messages.getString(Messages.GSS.system_prop_missing, "java.security.krb5.realm"));
                errors.append(nl);
            }
            if (kdc == null) {
                errors.append(Messages.getString(Messages.GSS.system_prop_missing, "java.security.krb5.kdc"));
                errors.append(nl);
            }
        }
        String config = System.getProperty("java.security.auth.login.config");
        if (config == null) {
            errors.append(Messages.getString(Messages.GSS.system_prop_missing, "java.security.auth.login.config"));
            errors.append(nl);
        }
        if (errors.length() > 0) {
            throw new LogonException(errors.toString());
        }
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        try {
            LoginContext lc = new LoginContext(jaasApplicationName, new GSSCallbackHandler(user, password));
            lc.login();
            Subject sub = lc.getSubject();
            GssAction action = new GssAction(logon, kerberosPrincipalName, props);
            result = Subject.doAs(sub, action);
        }
        catch (Exception e) {
            throw new LogonException(e, Messages.gs(Messages.TEIID.TEIID20005, new Object[0]));
        }
        if (result instanceof LogonException) {
            throw (LogonException)result;
        }
        if (result instanceof TeiidClientException) {
            throw (TeiidClientException)result;
        }
        if (result instanceof CommunicationException) {
            throw (CommunicationException)result;
        }
        if (result instanceof Exception) {
            throw new LogonException(result, Messages.gs(Messages.TEIID.TEIID20005, new Object[0]));
        }
        return result;
    }
}

