/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import org.teiid.core.types.DataTypeManagerService;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public abstract class Transform {
    protected final DataTypeManagerService dataTypeManager;

    public Transform(DataTypeManagerService dataTypeManager) {
        this.dataTypeManager = dataTypeManager;
    }

    public Object transform(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        return this.transformDirect(value);
    }

    protected abstract Object transformDirect(Object var1) throws Exception;

    public abstract Class<?> getSourceType();

    public String getSourceTypeName() {
        return this.dataTypeManager.getDataTypeName(this.getSourceType());
    }

    public abstract Class<?> getTargetType();

    public String getTargetTypeName() {
        return this.dataTypeManager.getDataTypeName(this.getTargetType());
    }

    public String getDisplayName() {
        return String.valueOf(this.getSourceTypeName()) + " to " + this.getTargetTypeName();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public boolean isExplicit() {
        return false;
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected void checkValueRange(Object value, Number min, Number max) throws Exception {
        DataTypeManagerService.DefaultDataTypes sourceDataType = this.dataTypeManager.getDataType(this.getSourceType());
        if (((Comparable)value).compareTo(this.dataTypeManager.transformValue((Object)min, sourceDataType)) < 0 || ((Comparable)value).compareTo(this.dataTypeManager.transformValue((Object)max, sourceDataType)) > 0) {
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID10058, value, this.getSourceType().getSimpleName(), this.getTargetType().getSimpleName()));
        }
    }
}

