/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.NullType;
import org.teiid.core.types.Transform;
import org.teiid.core.types.XMLType;
import org.teiid.core.types.basic.AnyToObjectTransform;
import org.teiid.core.types.basic.AnyToStringTransform;
import org.teiid.core.types.basic.BigDecimalToBigIntegerTransform;
import org.teiid.core.types.basic.BigIntegerToBigDecimalTransform;
import org.teiid.core.types.basic.BinaryToBlobTransform;
import org.teiid.core.types.basic.BlobToBinaryTransform;
import org.teiid.core.types.basic.BooleanToNumberTransform;
import org.teiid.core.types.basic.ClobToStringTransform;
import org.teiid.core.types.basic.DateToTimestampTransform;
import org.teiid.core.types.basic.FixedNumberToBigDecimalTransform;
import org.teiid.core.types.basic.FixedNumberToBigIntegerTransform;
import org.teiid.core.types.basic.FloatingNumberToBigDecimalTransform;
import org.teiid.core.types.basic.FloatingNumberToBigIntegerTransform;
import org.teiid.core.types.basic.NullToAnyTransform;
import org.teiid.core.types.basic.NumberToBooleanTransform;
import org.teiid.core.types.basic.NumberToByteTransform;
import org.teiid.core.types.basic.NumberToDoubleTransform;
import org.teiid.core.types.basic.NumberToFloatTransform;
import org.teiid.core.types.basic.NumberToIntegerTransform;
import org.teiid.core.types.basic.NumberToLongTransform;
import org.teiid.core.types.basic.NumberToShortTransform;
import org.teiid.core.types.basic.ObjectToAnyTransform;
import org.teiid.core.types.basic.SQLXMLToStringTransform;
import org.teiid.core.types.basic.StringToBigDecimalTransform;
import org.teiid.core.types.basic.StringToBigIntegerTransform;
import org.teiid.core.types.basic.StringToBooleanTransform;
import org.teiid.core.types.basic.StringToByteTransform;
import org.teiid.core.types.basic.StringToCharacterTransform;
import org.teiid.core.types.basic.StringToClobTransform;
import org.teiid.core.types.basic.StringToDateTransform;
import org.teiid.core.types.basic.StringToDoubleTransform;
import org.teiid.core.types.basic.StringToFloatTransform;
import org.teiid.core.types.basic.StringToIntegerTransform;
import org.teiid.core.types.basic.StringToLongTransform;
import org.teiid.core.types.basic.StringToSQLXMLTransform;
import org.teiid.core.types.basic.StringToShortTransform;
import org.teiid.core.types.basic.StringToTimeTransform;
import org.teiid.core.types.basic.StringToTimestampTransform;
import org.teiid.core.types.basic.TimeToTimestampTransform;
import org.teiid.core.types.basic.TimestampToDateTransform;
import org.teiid.core.types.basic.TimestampToTimeTransform;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.designer.annotation.AnnotationUtils;
import org.teiid.designer.annotation.Since;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.runtime.client.Messages;
import org.teiid.runtime.client.TeiidClientException;

public class DataTypeManagerService
implements IDataTypeManagerService {
    public static final int MAX_STRING_LENGTH = PropertiesUtils.getIntProperty(System.getProperties(), "org.teiid.maxStringLength", 4000);
    private static final boolean COMPARABLE_LOBS = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.comparableLobs", false);
    private static final boolean COMPARABLE_OBJECT = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.comparableObject", false);
    public static final int MAX_LOB_MEMORY_BYTES = Math.max(DataTypeManagerService.nextPowOf2(2 * MAX_STRING_LENGTH), 8192);
    private static final String ARRAY_SUFFIX = "[]";
    private static Map<DefaultDataTypes, Map<DefaultDataTypes, Transform>> transforms = new HashMap<DefaultDataTypes, Map<DefaultDataTypes, Transform>>(128);
    private static Map<ITeiidServerVersion, DataTypeManagerService> instances = new HashMap<ITeiidServerVersion, DataTypeManagerService>();
    private final ITeiidServerVersion teiidVersion;

    public static DataTypeManagerService getInstance(ITeiidServerVersion teiidVersion) {
        DataTypeManagerService instance = instances.get(teiidVersion);
        if (instance == null) {
            instance = new DataTypeManagerService(teiidVersion);
            instances.put(teiidVersion, instance);
        }
        return instance;
    }

    public static int nextPowOf2(int val) {
        int result = 1;
        while (result < val) {
            result <<= 1;
        }
        return result;
    }

    private DataTypeManagerService(ITeiidServerVersion teiidVersion) {
        this.teiidVersion = teiidVersion;
        this.loadBasicTransforms();
    }

    private void loadBasicTransforms() {
        Class<?> byteClass = DefaultDataTypes.BYTE.getTypeClass();
        Class<?> longClass = DefaultDataTypes.LONG.getTypeClass();
        Class<?> shortClass = DefaultDataTypes.SHORT.getTypeClass();
        Class<?> integerClass = DefaultDataTypes.INTEGER.getTypeClass();
        Class<?> doubleClass = DefaultDataTypes.DOUBLE.getTypeClass();
        Class<?> bigDecimalClass = DefaultDataTypes.BIG_DECIMAL.getTypeClass();
        Class<?> bigIntegerClass = DefaultDataTypes.BIG_INTEGER.getTypeClass();
        Class<?> floatClass = DefaultDataTypes.FLOAT.getTypeClass();
        this.addTransform(new BooleanToNumberTransform(this, (byte)1, (byte)0));
        this.addTransform(new BooleanToNumberTransform(this, (short)1, (short)0));
        this.addTransform(new BooleanToNumberTransform(this, 1, 0));
        this.addTransform(new BooleanToNumberTransform(this, 1L, 0L));
        this.addTransform(new BooleanToNumberTransform(this, BigInteger.valueOf(1L), BigInteger.valueOf(0L)));
        this.addTransform(new BooleanToNumberTransform(this, Float.valueOf(1.0f), Float.valueOf(0.0f)));
        this.addTransform(new BooleanToNumberTransform(this, 1.0, 0.0));
        this.addTransform(new BooleanToNumberTransform(this, BigDecimal.valueOf(1L), BigDecimal.valueOf(0L)));
        this.addTransform(new AnyToStringTransform(this, DefaultDataTypes.BOOLEAN.getTypeClass()));
        this.addTransform(new NumberToBooleanTransform(this, Byte.valueOf((byte)0)));
        this.addTransform(new NumberToShortTransform(this, byteClass, false));
        this.addTransform(new NumberToIntegerTransform(this, byteClass, false));
        this.addTransform(new NumberToLongTransform(this, byteClass, false, false));
        this.addTransform(new FixedNumberToBigIntegerTransform(this, byteClass));
        this.addTransform(new NumberToFloatTransform(this, byteClass, false, false));
        this.addTransform(new NumberToDoubleTransform(this, byteClass, false, false));
        this.addTransform(new FixedNumberToBigDecimalTransform(this, byteClass));
        this.addTransform(new AnyToStringTransform(this, byteClass));
        this.addTransform(new AnyToStringTransform(this, DefaultDataTypes.CHAR.getTypeClass()));
        this.addTransform(new NumberToBooleanTransform(this, Short.valueOf((short)0)));
        this.addTransform(new NumberToByteTransform(this, shortClass));
        this.addTransform(new NumberToIntegerTransform(this, shortClass, false));
        this.addTransform(new NumberToLongTransform(this, shortClass, false, false));
        this.addTransform(new FixedNumberToBigIntegerTransform(this, shortClass));
        this.addTransform(new NumberToFloatTransform(this, shortClass, false, false));
        this.addTransform(new NumberToDoubleTransform(this, shortClass, false, false));
        this.addTransform(new FixedNumberToBigDecimalTransform(this, shortClass));
        this.addTransform(new AnyToStringTransform(this, shortClass));
        this.addTransform(new NumberToBooleanTransform(this, Integer.valueOf(0)));
        this.addTransform(new NumberToByteTransform(this, integerClass));
        this.addTransform(new NumberToShortTransform(this, integerClass, true));
        this.addTransform(new NumberToLongTransform(this, integerClass, false, false));
        this.addTransform(new FixedNumberToBigIntegerTransform(this, integerClass));
        this.addTransform(new NumberToFloatTransform(this, integerClass, false, true));
        this.addTransform(new NumberToDoubleTransform(this, integerClass, false, false));
        this.addTransform(new FixedNumberToBigDecimalTransform(this, integerClass));
        this.addTransform(new AnyToStringTransform(this, integerClass));
        this.addTransform(new NumberToBooleanTransform(this, Long.valueOf(0L)));
        this.addTransform(new NumberToByteTransform(this, longClass));
        this.addTransform(new NumberToShortTransform(this, longClass, true));
        this.addTransform(new NumberToIntegerTransform(this, longClass, true));
        this.addTransform(new FixedNumberToBigIntegerTransform(this, longClass));
        this.addTransform(new NumberToFloatTransform(this, longClass, false, true));
        this.addTransform(new NumberToDoubleTransform(this, longClass, false, true));
        this.addTransform(new FixedNumberToBigDecimalTransform(this, longClass));
        this.addTransform(new AnyToStringTransform(this, longClass));
        this.addTransform(new NumberToBooleanTransform(this, BigInteger.valueOf(0L)));
        this.addTransform(new NumberToByteTransform(this, bigIntegerClass));
        this.addTransform(new NumberToShortTransform(this, bigIntegerClass, true));
        this.addTransform(new NumberToIntegerTransform(this, bigIntegerClass, true));
        this.addTransform(new NumberToLongTransform(this, bigIntegerClass, true, false));
        this.addTransform(new NumberToFloatTransform(this, bigIntegerClass, true, false));
        this.addTransform(new NumberToDoubleTransform(this, bigIntegerClass, true, false));
        this.addTransform(new BigIntegerToBigDecimalTransform(this));
        this.addTransform(new AnyToStringTransform(this, bigIntegerClass));
        this.addTransform(new NumberToBooleanTransform(this, BigDecimal.valueOf(0L)));
        this.addTransform(new NumberToByteTransform(this, bigDecimalClass));
        this.addTransform(new NumberToShortTransform(this, bigDecimalClass, true));
        this.addTransform(new NumberToIntegerTransform(this, bigDecimalClass, true));
        this.addTransform(new NumberToLongTransform(this, bigDecimalClass, true, false));
        this.addTransform(new BigDecimalToBigIntegerTransform(this));
        this.addTransform(new NumberToFloatTransform(this, bigDecimalClass, true, false));
        this.addTransform(new NumberToDoubleTransform(this, bigDecimalClass, true, false));
        this.addTransform(new AnyToStringTransform(this, bigDecimalClass));
        this.addTransform(new NumberToBooleanTransform(this, Float.valueOf(0.0f)));
        this.addTransform(new NumberToByteTransform(this, floatClass));
        this.addTransform(new NumberToShortTransform(this, floatClass, true));
        this.addTransform(new NumberToIntegerTransform(this, floatClass, true));
        this.addTransform(new NumberToLongTransform(this, floatClass, false, true));
        this.addTransform(new FloatingNumberToBigIntegerTransform(this, floatClass));
        this.addTransform(new NumberToDoubleTransform(this, floatClass, false, false));
        this.addTransform(new FloatingNumberToBigDecimalTransform(this, floatClass));
        this.addTransform(new AnyToStringTransform(this, floatClass));
        this.addTransform(new NumberToBooleanTransform(this, Double.valueOf(0.0)));
        this.addTransform(new NumberToByteTransform(this, doubleClass));
        this.addTransform(new NumberToShortTransform(this, doubleClass, true));
        this.addTransform(new NumberToIntegerTransform(this, doubleClass, true));
        this.addTransform(new NumberToLongTransform(this, doubleClass, false, true));
        this.addTransform(new FloatingNumberToBigIntegerTransform(this, doubleClass));
        this.addTransform(new NumberToFloatTransform(this, doubleClass, true, false));
        this.addTransform(new FloatingNumberToBigDecimalTransform(this, doubleClass));
        this.addTransform(new AnyToStringTransform(this, doubleClass));
        this.addTransform(new DateToTimestampTransform(this));
        this.addTransform(new AnyToStringTransform(this, DefaultDataTypes.DATE.getTypeClass()));
        this.addTransform(new TimeToTimestampTransform(this));
        this.addTransform(new AnyToStringTransform(this, DefaultDataTypes.TIME.getTypeClass()));
        this.addTransform(new TimestampToTimeTransform(this));
        this.addTransform(new TimestampToDateTransform(this));
        this.addTransform(new AnyToStringTransform(this, DefaultDataTypes.TIMESTAMP.getTypeClass()));
        this.addTransform(new StringToBooleanTransform(this));
        this.addTransform(new StringToByteTransform(this));
        this.addTransform(new StringToShortTransform(this));
        this.addTransform(new StringToIntegerTransform(this));
        this.addTransform(new StringToLongTransform(this));
        this.addTransform(new StringToBigIntegerTransform(this));
        this.addTransform(new StringToFloatTransform(this));
        this.addTransform(new StringToDoubleTransform(this));
        this.addTransform(new StringToBigDecimalTransform(this));
        this.addTransform(new StringToTimeTransform(this));
        this.addTransform(new StringToDateTransform(this));
        this.addTransform(new StringToTimestampTransform(this));
        this.addTransform(new StringToCharacterTransform(this));
        this.addTransform(new StringToClobTransform(this));
        this.addTransform(new StringToSQLXMLTransform(this));
        this.addTransform(new BinaryToBlobTransform(this));
        this.addTransform(new ClobToStringTransform(this));
        this.addTransform(new BlobToBinaryTransform(this));
        this.addTransform(new SQLXMLToStringTransform(this));
        if (this.teiidVersion.isLessThan(TeiidServerVersion.Version.TEIID_8_5.get())) {
            for (Class<?> type : this.getAllDataTypeClasses()) {
                if (type != DefaultDataTypes.OBJECT.getTypeClass()) {
                    this.addTransform(new AnyToObjectTransform(this, type));
                    this.addTransform(new ObjectToAnyTransform(this, type));
                }
                if (type == DefaultDataTypes.NULL.getTypeClass()) continue;
                this.addTransform(new NullToAnyTransform(this, type));
            }
        }
        this.addTransform(new AnyToStringTransform(this, DefaultDataTypes.OBJECT.getTypeClass()){

            @Override
            public boolean isExplicit() {
                return true;
            }
        });
    }

    private void checkDataType(DefaultDataTypes dataType, String dataTypeName) {
        ArgCheck.isNotNull((Object)dataType, Messages.getString(Messages.ERR.ERR_100_001_0001, this.teiidVersion, dataTypeName));
    }

    private Transform getTransformFromMaps(DefaultDataTypes srcType, DefaultDataTypes targetType) {
        Map<DefaultDataTypes, Transform> innerMap = transforms.get((Object)srcType);
        boolean found = false;
        if (innerMap != null) {
            Transform result = innerMap.get((Object)targetType);
            if (result != null) {
                return result;
            }
            found = true;
        }
        if (srcType.equals((Object)targetType)) {
            return null;
        }
        if (DefaultDataTypes.OBJECT.equals((Object)targetType)) {
            return new AnyToObjectTransform(this, srcType.getTypeClass());
        }
        if (srcType.equals((Object)DefaultDataTypes.NULL)) {
            return new NullToAnyTransform(this, targetType.getTypeClass());
        }
        if (srcType.equals((Object)DefaultDataTypes.OBJECT)) {
            return new ObjectToAnyTransform(this, targetType.getTypeClass());
        }
        if (found) {
            return null;
        }
        return null;
    }

    private DefaultDataTypes findDefaultDataType(String id) {
        for (DefaultDataTypes defaultDataType : DefaultDataTypes.getValues(this.teiidVersion)) {
            if (defaultDataType.getId().equalsIgnoreCase(id)) {
                return defaultDataType;
            }
            if (!defaultDataType.hasAlias(id)) continue;
            return defaultDataType;
        }
        return null;
    }

    private DefaultDataTypes findDefaultDataType(IDataTypeManagerService.DataTypeName dataTypeName) {
        ArgCheck.isTrue(AnnotationUtils.isApplicable((Enum)dataTypeName, (ITeiidServerVersion)this.teiidVersion), Messages.getString(Messages.ERR.ERR_100_001_0001, this.teiidVersion, dataTypeName));
        for (DefaultDataTypes defaultDataType : DefaultDataTypes.getValues(this.teiidVersion)) {
            if (defaultDataType.getDataTypeName().equals((Object)dataTypeName)) {
                return defaultDataType;
            }
            if (!defaultDataType.hasAlias(dataTypeName.name())) continue;
            return defaultDataType;
        }
        return null;
    }

    private DefaultDataTypes findDefaultDataType(Class<?> typeClass) {
        for (DefaultDataTypes defaultDataType : DefaultDataTypes.getValues(this.teiidVersion)) {
            if (!defaultDataType.getTypeClass().equals(typeClass) && !defaultDataType.getTypeArrayClass().equals(typeClass)) continue;
            return defaultDataType;
        }
        return null;
    }

    public static boolean isArrayType(String name) {
        return name.endsWith(ARRAY_SUFFIX);
    }

    private String getComponentType(String name) {
        return name.substring(0, name.lastIndexOf(ARRAY_SUFFIX));
    }

    public String getDefaultDataType(IDataTypeManagerService.DataTypeName dataTypeName) {
        ArgCheck.isNotNull(dataTypeName);
        ArgCheck.isTrue(AnnotationUtils.isApplicable((Enum)dataTypeName, (ITeiidServerVersion)this.teiidVersion), Messages.getString(Messages.ERR.ERR_100_001_0001, this.teiidVersion, dataTypeName));
        DefaultDataTypes dataType = this.findDefaultDataType(dataTypeName);
        this.checkDataType(dataType, dataTypeName.toString());
        return dataType.getId();
    }

    public DefaultDataTypes getDataType(String name) {
        if (name == null) {
            return DefaultDataTypes.NULL;
        }
        DefaultDataTypes dataType = null;
        if (DataTypeManagerService.isArrayType(name)) {
            String compName = this.getComponentType(name);
            dataType = this.findDefaultDataType(compName);
        } else {
            dataType = this.findDefaultDataType(name);
        }
        if (dataType == null) {
            dataType = DefaultDataTypes.OBJECT;
        }
        return dataType;
    }

    public Class<?> getDataTypeClass(String name) {
        if (name == null) {
            return DefaultDataTypes.NULL.getTypeClass();
        }
        DefaultDataTypes dataType = this.getDataType(name);
        if (DataTypeManagerService.isArrayType(name)) {
            return dataType.getTypeArrayClass();
        }
        return dataType.getTypeClass();
    }

    public Class<?> getDefaultDataClass(IDataTypeManagerService.DataTypeName dataTypeName) {
        ArgCheck.isNotNull(dataTypeName);
        ArgCheck.isTrue(AnnotationUtils.isApplicable((Enum)dataTypeName, (ITeiidServerVersion)this.teiidVersion), Messages.getString(Messages.ERR.ERR_100_001_0001, this.teiidVersion, dataTypeName));
        DefaultDataTypes dataType = this.findDefaultDataType(dataTypeName);
        this.checkDataType(dataType, dataTypeName.toString());
        return dataType.getTypeClass();
    }

    public DefaultDataTypes getDataType(Class<?> typeClass) {
        ArgCheck.isNotNull(typeClass);
        DefaultDataTypes dataType = this.findDefaultDataType(typeClass);
        if (dataType != null) {
            return dataType;
        }
        return DefaultDataTypes.OBJECT;
    }

    @Since(value=TeiidServerVersion.Version.TEIID_8_0)
    public DefaultDataTypes getDataType(IDataTypeManagerService.DataTypeAliases alias) {
        ArgCheck.isNotNull(alias);
        for (DefaultDataTypes defaultDataType : DefaultDataTypes.getValues(this.teiidVersion)) {
            if (!defaultDataType.hasAlias(alias)) continue;
            return defaultDataType;
        }
        throw new IllegalArgumentException("No data type for the alias " + alias.getId() + " for teiid version " + this.teiidVersion);
    }

    public String getDataTypeName(Class<?> typeClass) {
        if (typeClass == null) {
            return DefaultDataTypes.NULL.getId();
        }
        DefaultDataTypes dataType = this.findDefaultDataType(typeClass);
        if (dataType == null) {
            dataType = DefaultDataTypes.OBJECT;
        }
        if (typeClass.isArray()) {
            return String.valueOf(dataType.getId()) + ARRAY_SUFFIX;
        }
        return dataType.getId();
    }

    public Set<String> getAllDataTypeNames() {
        LinkedHashSet<String> dataTypeNames = new LinkedHashSet<String>();
        for (DefaultDataTypes defaultDataType : DefaultDataTypes.getValues(this.teiidVersion)) {
            dataTypeNames.add(defaultDataType.getId());
        }
        return dataTypeNames;
    }

    public Set<Class<?>> getAllDataTypeClasses() {
        HashSet dataTypeNames = new HashSet();
        for (DefaultDataTypes defaultDataType : DefaultDataTypes.getValues(this.teiidVersion)) {
            dataTypeNames.add(defaultDataType.getTypeClass());
        }
        return dataTypeNames;
    }

    public Integer getDataTypeLimit(String dataType) {
        ArgCheck.isNotNull(dataType);
        for (DefaultDataTypes defaultDataType : DefaultDataTypes.getValues(this.teiidVersion)) {
            if (!defaultDataType.getId().equals(dataType)) continue;
            return defaultDataType.getLimit();
        }
        return -1;
    }

    public String getDataTypeValidChars(String dataType) {
        ArgCheck.isNotNull(dataType);
        for (DefaultDataTypes defaultDataType : DefaultDataTypes.getValues(this.teiidVersion)) {
            if (!defaultDataType.getId().equals(dataType)) continue;
            return defaultDataType.getValidChars();
        }
        return null;
    }

    public String getDataSourceType(IDataTypeManagerService.DataSourceTypes dataSourceType) {
        if (dataSourceType == null) {
            return IDataTypeManagerService.DataSourceTypes.UNKNOWN.id();
        }
        ArgCheck.isTrue(AnnotationUtils.isApplicable((Enum)dataSourceType, (ITeiidServerVersion)this.teiidVersion), Messages.getString(Messages.ERR.ERR_100_001_0001, this.teiidVersion, dataSourceType.id()));
        return AnnotationUtils.getUpdatedName((Enum)dataSourceType, (String)dataSourceType.id(), (ITeiidServerVersion)this.teiidVersion);
    }

    public boolean isNonComparable(String type) {
        DefaultDataTypes dataType = this.findDefaultDataType(type);
        this.checkDataType(dataType, type);
        return this.isNonComparable(dataType.getTypeClass());
    }

    public boolean isNonComparable(Class<?> type) {
        return !COMPARABLE_OBJECT && DefaultDataTypes.OBJECT.getTypeClass().equals(type) || !COMPARABLE_LOBS && DefaultDataTypes.BLOB.getTypeClass().equals(type) || !COMPARABLE_LOBS && DefaultDataTypes.CLOB.getTypeClass().equals(type) || DefaultDataTypes.XML.getTypeClass().equals(type);
    }

    public Transform getTransform(String sourceTypeName, String targetTypeName) {
        if (sourceTypeName == null || targetTypeName == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_003_029_0002, sourceTypeName, targetTypeName));
        }
        DefaultDataTypes sourceType = this.findDefaultDataType(sourceTypeName);
        DefaultDataTypes targetType = this.findDefaultDataType(targetTypeName);
        if (sourceType == null || targetType == null) {
            return null;
        }
        return this.getTransformFromMaps(sourceType, targetType);
    }

    public Transform getTransform(Class<?> sourceType, Class<?> targetType) {
        if (sourceType == null || targetType == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_003_029_0002, sourceType, targetType));
        }
        DefaultDataTypes sourceDataType = this.findDefaultDataType(sourceType);
        DefaultDataTypes targetDataType = this.findDefaultDataType(targetType);
        if (sourceDataType == null || targetDataType == null) {
            return null;
        }
        return this.getTransformFromMaps(sourceDataType, targetDataType);
    }

    public Transform getTransform(DefaultDataTypes sourceDataType, DefaultDataTypes targetDataType) {
        return this.getTransformFromMaps(sourceDataType, targetDataType);
    }

    public boolean isTransformable(String sourceTypeName, String targetTypeName) {
        if (sourceTypeName == null || targetTypeName == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_003_029_0002, sourceTypeName, targetTypeName));
        }
        return this.getTransform(sourceTypeName, targetTypeName) != null;
    }

    public boolean isTransformable(Class<?> srcTypeClass, Class<?> targetTypeClass) {
        if (srcTypeClass == null || targetTypeClass == null) {
            throw new IllegalArgumentException(Messages.getString(Messages.ERR.ERR_003_029_0002, srcTypeClass, targetTypeClass));
        }
        return this.getTransform(srcTypeClass, targetTypeClass) != null;
    }

    public boolean isExplicitConversion(String sourceTypeName, String targetTypeName) {
        Transform t = this.getTransform(sourceTypeName, targetTypeName);
        if (t != null) {
            return t.isExplicit();
        }
        return false;
    }

    public void getImplicitConversions(String sourceTypeName, Collection<String> result) {
        Map<DefaultDataTypes, Transform> innerMap;
        if (sourceTypeName == null || result == null) {
            throw new IllegalArgumentException();
        }
        DefaultDataTypes sourceType = this.findDefaultDataType(sourceTypeName);
        if (sourceType != null && (innerMap = transforms.get((Object)sourceType)) != null) {
            for (Map.Entry<DefaultDataTypes, Transform> entry : innerMap.entrySet()) {
                if (entry.getValue().isExplicit()) continue;
                result.add(entry.getKey().getId());
            }
            result.add(DefaultDataTypes.OBJECT.getId());
            return;
        }
        String previous = DefaultDataTypes.OBJECT.getId();
        result.add(previous);
        while (DataTypeManagerService.isArrayType(sourceTypeName)) {
            previous = String.valueOf(previous) + ARRAY_SUFFIX;
            result.add(previous);
            sourceTypeName = this.getComponentType(sourceTypeName);
        }
    }

    public boolean isImplicitConversion(String sourceTypeName, String targetTypeName) {
        Transform t = this.getTransform(sourceTypeName, targetTypeName);
        if (t != null) {
            return !t.isExplicit();
        }
        if (DefaultDataTypes.NULL.getId().equals(sourceTypeName) && !DefaultDataTypes.NULL.getId().equals(targetTypeName)) {
            return true;
        }
        if (DefaultDataTypes.OBJECT.getId().equals(targetTypeName) && !DefaultDataTypes.OBJECT.getId().equals(sourceTypeName)) {
            return true;
        }
        if (DataTypeManagerService.isArrayType(sourceTypeName) && DataTypeManagerService.isArrayType(targetTypeName)) {
            return this.isImplicitConversion(this.getComponentType(sourceTypeName), this.getComponentType(targetTypeName));
        }
        return false;
    }

    public void addTransform(Transform transform) {
        ArgCheck.isNotNull(transform);
        String sourceName = transform.getSourceTypeName();
        String targetName = transform.getTargetTypeName();
        DefaultDataTypes sourceDataType = this.findDefaultDataType(sourceName);
        this.checkDataType(sourceDataType, sourceName);
        DefaultDataTypes targetDataType = this.findDefaultDataType(targetName);
        this.checkDataType(targetDataType, targetName);
        Map<DefaultDataTypes, Transform> innerMap = transforms.get((Object)sourceDataType);
        if (innerMap == null) {
            innerMap = new LinkedHashMap<DefaultDataTypes, Transform>();
            transforms.put(sourceDataType, innerMap);
        }
        innerMap.put(targetDataType, transform);
    }

    public <T> T transformValue(Object value, DefaultDataTypes defaultDataType) throws Exception {
        if (value == null) {
            return (T)value;
        }
        return this.transformValue(value, value.getClass(), defaultDataType);
    }

    public <T> T transformValue(Object value, Class<?> sourceType, DefaultDataTypes targetDataType) throws Exception {
        if (value == null || sourceType == targetDataType.getTypeClass() || DefaultDataTypes.OBJECT == targetDataType) {
            return (T)value;
        }
        Transform transform = null;
        DefaultDataTypes sourceDataType = this.findDefaultDataType(sourceType);
        if (sourceDataType != null) {
            transform = this.getTransformFromMaps(sourceDataType, targetDataType);
        }
        if (transform == null) {
            Object[] params = new Object[]{sourceType, targetDataType, value};
            throw new TeiidClientException(Messages.gs(Messages.TEIID.TEIID10076, params));
        }
        Object result = transform.transform(value);
        return (T)result;
    }

    public <T> T transformValue(Object value, Class<T> targetClass) throws Exception {
        if (value == null) {
            return (T)value;
        }
        return this.transformValue(value, value.getClass(), this.getDataType(targetClass));
    }

    public boolean isDecimalAsDouble() {
        return PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.decimalAsDouble", false);
    }

    public boolean isLengthDataType(String dataTypeName) {
        return dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.CHAR.name()) || dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.CLOB.name()) || dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.BLOB.name()) || dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.OBJECT.name()) || dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.STRING.name()) || dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.VARBINARY.name()) || dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.BIGINTEGER.name());
    }

    public boolean isPrecisionDataType(String dataTypeName) {
        return dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.BIGDECIMAL.name()) || dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.DECIMAL.name());
    }

    public boolean isScaleDataType(String dataTypeName) {
        return dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.BIGDECIMAL.name()) || dataTypeName.equalsIgnoreCase(IDataTypeManagerService.DataTypeName.DECIMAL.name());
    }

    public Object convertToRuntimeType(Object value, boolean allConversions) {
        if (value == null) {
            return null;
        }
        Class<?> c = value.getClass();
        if (this.findDefaultDataType(c) != null) {
            return value;
        }
        if (allConversions) {
            if (c == char[].class) {
                return new ClobType(ClobImpl.createClob((char[])value));
            }
            if (c == byte[].class) {
                return new BinaryType((byte[])value);
            }
            if (Date.class.isAssignableFrom(c)) {
                return new Timestamp(((Date)value).getTime());
            }
            if (Object[].class.isAssignableFrom(c)) {
                return new ArrayImpl(this.teiidVersion, (Object[])value);
            }
        }
        if (Clob.class.isAssignableFrom(c)) {
            return new ClobType((Clob)value);
        }
        if (Blob.class.isAssignableFrom(c)) {
            return new BlobType((Blob)value);
        }
        if (SQLXML.class.isAssignableFrom(c)) {
            return new XMLType((SQLXML)value);
        }
        if (c == ArrayImpl.class) {
            return DefaultDataTypes.OBJECT.getTypeArrayClass();
        }
        if (c.isArray()) {
            return this.getDataTypeClass(this.getDataTypeName(c));
        }
        return value;
    }

    public static enum DefaultDataTypes {
        STRING("string", IDataTypeManagerService.DataTypeName.STRING, String.class, 256, IDataTypeManagerService.DataTypeAliases.VARCHAR),
        BOOLEAN("boolean", IDataTypeManagerService.DataTypeName.BOOLEAN, Boolean.class, new IDataTypeManagerService.DataTypeAliases[0]),
        BYTE("byte", IDataTypeManagerService.DataTypeName.BYTE, Byte.class, 3, "0123456789-", IDataTypeManagerService.DataTypeAliases.TINYINT),
        SHORT("short", IDataTypeManagerService.DataTypeName.SHORT, Short.class, 5, "0123456789-", IDataTypeManagerService.DataTypeAliases.SMALLINT),
        CHAR("char", IDataTypeManagerService.DataTypeName.CHAR, Character.class, 1, new IDataTypeManagerService.DataTypeAliases[0]),
        INTEGER("integer", IDataTypeManagerService.DataTypeName.INTEGER, Integer.class, 10, "0123456789-", new IDataTypeManagerService.DataTypeAliases[0]),
        LONG("long", IDataTypeManagerService.DataTypeName.LONG, Long.class, 19, "0123456789-", IDataTypeManagerService.DataTypeAliases.BIGINT),
        BIG_INTEGER("biginteger", IDataTypeManagerService.DataTypeName.BIGINTEGER, BigInteger.class, 30, "0123456789-", new IDataTypeManagerService.DataTypeAliases[0]),
        FLOAT("float", IDataTypeManagerService.DataTypeName.FLOAT, Float.class, 30, "0123456789-+.eE", IDataTypeManagerService.DataTypeAliases.REAL),
        DOUBLE("double", IDataTypeManagerService.DataTypeName.DOUBLE, Double.class, 30, "0123456789-+.eE", new IDataTypeManagerService.DataTypeAliases[0]),
        BIG_DECIMAL("bigdecimal", IDataTypeManagerService.DataTypeName.BIGDECIMAL, BigDecimal.class, 30, "0123456789-.eE", IDataTypeManagerService.DataTypeAliases.DECIMAL),
        DATE("date", IDataTypeManagerService.DataTypeName.DATE, java.sql.Date.class, new IDataTypeManagerService.DataTypeAliases[0]),
        TIME("time", IDataTypeManagerService.DataTypeName.TIME, Time.class, new IDataTypeManagerService.DataTypeAliases[0]),
        TIMESTAMP("timestamp", IDataTypeManagerService.DataTypeName.TIMESTAMP, Timestamp.class, new IDataTypeManagerService.DataTypeAliases[0]),
        OBJECT("object", IDataTypeManagerService.DataTypeName.OBJECT, Object.class, new IDataTypeManagerService.DataTypeAliases[0]),
        NULL("null", IDataTypeManagerService.DataTypeName.NULL, NullType.class, new IDataTypeManagerService.DataTypeAliases[0]),
        BLOB("blob", IDataTypeManagerService.DataTypeName.BLOB, BlobType.class, new IDataTypeManagerService.DataTypeAliases[0]),
        CLOB("clob", IDataTypeManagerService.DataTypeName.CLOB, ClobType.class, new IDataTypeManagerService.DataTypeAliases[0]),
        XML("xml", IDataTypeManagerService.DataTypeName.XML, XMLType.class, new IDataTypeManagerService.DataTypeAliases[0]),
        VARBINARY("varbinary", IDataTypeManagerService.DataTypeName.VARBINARY, BinaryType.class, new IDataTypeManagerService.DataTypeAliases[0]);

        private static Map<ITeiidServerVersion, List<DefaultDataTypes>> valueCache;
        private String id;
        private IDataTypeManagerService.DataTypeName dataTypeName;
        private Class<?> klazz;
        private int limit = -1;
        private String validChars = null;
        private Class<?> arrayKlazz;
        private Set<IDataTypeManagerService.DataTypeAliases> aliases = Collections.emptySet();

        static {
            valueCache = new HashMap<ITeiidServerVersion, List<DefaultDataTypes>>();
        }

        private DefaultDataTypes(String id, IDataTypeManagerService.DataTypeName dataTypeName, Class<?> klazz, IDataTypeManagerService.DataTypeAliases ... aliases) {
            this.id = id;
            this.dataTypeName = dataTypeName;
            this.klazz = klazz;
            if (aliases != null) {
                this.aliases = new HashSet<IDataTypeManagerService.DataTypeAliases>();
                IDataTypeManagerService.DataTypeAliases[] dataTypeAliasesArray = aliases;
                int n2 = aliases.length;
                int n3 = 0;
                while (n3 < n2) {
                    IDataTypeManagerService.DataTypeAliases alias = dataTypeAliasesArray[n3];
                    this.aliases.add(alias);
                    ++n3;
                }
            }
            this.arrayKlazz = Array.newInstance(klazz, 0).getClass();
        }

        private DefaultDataTypes(String id, IDataTypeManagerService.DataTypeName dataTypeName, Class<?> klazz, int limit, IDataTypeManagerService.DataTypeAliases ... aliases) {
            this(id, dataTypeName, klazz, aliases);
            this.limit = limit;
        }

        private DefaultDataTypes(String id, IDataTypeManagerService.DataTypeName dataTypeName, Class<?> klazz, int limit, String validChars, IDataTypeManagerService.DataTypeAliases ... aliases) {
            this(id, dataTypeName, klazz, limit, aliases);
            this.validChars = validChars;
        }

        public String getId() {
            return this.id;
        }

        public IDataTypeManagerService.DataTypeName getDataTypeName() {
            return this.dataTypeName;
        }

        public Class<?> getTypeClass() {
            return this.klazz;
        }

        public Class<?> getTypeArrayClass() {
            return this.arrayKlazz;
        }

        public int getLimit() {
            return this.limit;
        }

        public String getValidChars() {
            return this.validChars;
        }

        public boolean hasAlias(IDataTypeManagerService.DataTypeAliases alias) {
            return this.aliases.contains(alias);
        }

        public boolean hasAlias(String aliasId) {
            for (IDataTypeManagerService.DataTypeAliases alias : this.aliases) {
                if (!alias.getId().equalsIgnoreCase(aliasId)) continue;
                return true;
            }
            return false;
        }

        public static boolean isLOB(Class<?> type) {
            return BLOB.equals(type) || CLOB.equals(type) || XML.equals(type);
        }

        public static boolean isLOB(String type) {
            return BLOB.equals(type) || CLOB.equals(type) || XML.equals(type);
        }

        public static List<DefaultDataTypes> getValues(ITeiidServerVersion teiidVersion) {
            List<DefaultDataTypes> appDataTypes = valueCache.get(teiidVersion);
            if (appDataTypes == null) {
                appDataTypes = new ArrayList<DefaultDataTypes>();
                DefaultDataTypes[] defaultDataTypesArray = DefaultDataTypes.values();
                int n = defaultDataTypesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DefaultDataTypes dataType = defaultDataTypesArray[n2];
                    if (AnnotationUtils.isApplicable((Enum)dataType, (ITeiidServerVersion)teiidVersion)) {
                        appDataTypes.add(dataType);
                    }
                    ++n2;
                }
                valueCache.put(teiidVersion, appDataTypes);
            }
            return appDataTypes;
        }

        public static DefaultDataTypes valueOf(String string) {
            return Enum.valueOf(DefaultDataTypes.class, string);
        }
    }
}

