/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.client.batch;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.teiid.client.BatchSerializer;
import org.teiid.client.ResizingArrayList;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManagerService;
import org.teiid.core.types.XMLType;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.runtime.client.Messages;

public class Batch2Serializer
extends BatchSerializer {
    static final byte CURRENT_VERSION = 2;
    private final ColumnSerializer defaultSerializer = new ColumnSerializer();
    private final Map<String, ColumnSerializer[]> serializers = new HashMap<String, ColumnSerializer[]>(128);
    private ColumnSerializer arrayColumnSerializer = new ColumnSerializer(this){

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            try {
                super.writeObject(out, ((java.sql.Array)obj).getArray());
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return new ArrayImpl(this.getTeiidVersion(), (Object[])in.readObject());
        }
    };
    private ColumnSerializer arrayColumnSerialier2 = new ArrayColumnSerializer2(new ObjectColumnSerializer(DataTypeManagerService.DefaultDataTypes.VARBINARY.ordinal(), 2));
    private int MAX_UTF = 21845;
    static int DATE_NORMALIZER = 0;
    public static final long MIN_DATE_32;
    public static final long MAX_DATE_32;
    public static final long MIN_TIME_32;
    public static final long MAX_TIME_32;

    static {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("GMT"));
        c.set(1900, 0, 1, 0, 0, 0);
        c.set(14, 0);
        MIN_DATE_32 = c.getTimeInMillis();
        MAX_DATE_32 = MIN_DATE_32 + 257698037700000L;
        DATE_NORMALIZER = -((int)(MIN_DATE_32 / 60000L));
        MAX_TIME_32 = 2147483647000L;
        MIN_TIME_32 = -2147483648000L;
    }

    public Batch2Serializer(ITeiidServerVersion teiidVersion) {
        super(teiidVersion);
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BIG_DECIMAL.getId(), new ColumnSerializer[]{new BigDecimalColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BIG_INTEGER.getId(), new ColumnSerializer[]{new BigIntegerColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BOOLEAN.getId(), new ColumnSerializer[]{new BooleanColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BYTE.getId(), new ColumnSerializer[]{new ByteColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.CHAR.getId(), new ColumnSerializer[]{new CharColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.DATE.getId(), new ColumnSerializer[]{new DateColumnSerializer(), new DateColumnSerializer1(), new DateColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.DOUBLE.getId(), new ColumnSerializer[]{new DoubleColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.FLOAT.getId(), new ColumnSerializer[]{new FloatColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.INTEGER.getId(), new ColumnSerializer[]{new IntColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.LONG.getId(), new ColumnSerializer[]{new LongColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.SHORT.getId(), new ColumnSerializer[]{new ShortColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.TIME.getId(), new ColumnSerializer[]{new TimeColumnSerializer(), new TimeColumnSerializer1(), new TimeColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.TIMESTAMP.getId(), new ColumnSerializer[]{new TimestampColumnSerializer()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.STRING.getId(), new ColumnSerializer[]{this.defaultSerializer, new StringColumnSerializer1()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.CLOB.getId(), new ColumnSerializer[]{this.defaultSerializer, new ClobColumnSerializer1()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.BLOB.getId(), new ColumnSerializer[]{this.defaultSerializer, new BlobColumnSerializer1()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.XML.getId(), new ColumnSerializer[]{this.defaultSerializer, new XmlColumnSerializer1()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.NULL.getId(), new ColumnSerializer[]{this.defaultSerializer, new NullColumnSerializer1()});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.OBJECT.getId(), new ColumnSerializer[]{this.defaultSerializer, new ObjectColumnSerializer(DataTypeManagerService.DefaultDataTypes.VARBINARY.ordinal(), 1)});
        this.serializers.put(DataTypeManagerService.DefaultDataTypes.VARBINARY.getId(), new ColumnSerializer[]{new BinaryColumnSerializer(), new BinaryColumnSerializer1()});
    }

    static void writeIsNullData(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
        int numBytes = batch.size() / 8;
        int row = 0;
        int currentByte = 0;
        int byteNum = 0;
        while (byteNum < numBytes) {
            int n = currentByte = batch.get(row).get(col) == null ? 128 : 0;
            if (batch.get(row + 1).get(col) == null) {
                currentByte |= 0x40;
            }
            if (batch.get(row + 2).get(col) == null) {
                currentByte |= 0x20;
            }
            if (batch.get(row + 3).get(col) == null) {
                currentByte |= 0x10;
            }
            if (batch.get(row + 4).get(col) == null) {
                currentByte |= 8;
            }
            if (batch.get(row + 5).get(col) == null) {
                currentByte |= 4;
            }
            if (batch.get(row + 6).get(col) == null) {
                currentByte |= 2;
            }
            if (batch.get(row + 7).get(col) == null) {
                currentByte |= 1;
            }
            out.write(currentByte);
            ++byteNum;
            row += 8;
        }
        if (batch.size() % 8 > 0) {
            currentByte = 0;
            int mask = 128;
            while (row < batch.size()) {
                if (batch.get(row).get(col) == null) {
                    currentByte |= mask;
                }
                ++row;
                mask >>= 1;
            }
            out.write(currentByte);
        }
    }

    static void writeIsNullData(ObjectOutput out, int offset, Object[] batch) throws IOException {
        int currentByte = 0;
        int mask = 128;
        while (offset < batch.length) {
            if (batch[offset] == null) {
                currentByte |= mask;
            }
            ++offset;
            mask >>= 1;
        }
        out.write(currentByte);
    }

    static void readIsNullData(ObjectInput in, byte[] isNullBytes) throws IOException {
        int i = 0;
        while (i < isNullBytes.length) {
            isNullBytes[i] = in.readByte();
            ++i;
        }
    }

    static final boolean isNullObject(byte[] isNull, int row) {
        return (isNull[row / 8] & 1 << 7 - row % 8) != 0;
    }

    private boolean isNullObject(int row, byte b) {
        return (b & 1 << 7 - row % 8) != 0;
    }

    private ColumnSerializer getSerializer(String type, byte version) {
        ColumnSerializer[] sers = this.serializers.get(type);
        if (sers == null) {
            if (DataTypeManagerService.isArrayType(type)) {
                if (version < 2) {
                    return this.arrayColumnSerializer;
                }
                return this.arrayColumnSerialier2;
            }
            return this.defaultSerializer;
        }
        return sers[Math.min(version, sers.length - 1)];
    }

    @Override
    public void writeBatch(ObjectOutput out, String[] types, List<? extends List<?>> batch) throws IOException {
        this.writeBatch(out, types, batch, (byte)2);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeBatch(ObjectOutput out, String[] types, List<? extends List<?>> batch, byte version) throws IOException {
        if (batch == null) {
            out.writeInt(-1);
        } else {
            if (version > 0 && batch.size() > 0) {
                out.writeInt(-batch.size() - 1);
                out.writeByte(version);
            } else {
                out.writeInt(batch.size());
            }
            if (batch.size() > 0) {
                columns = types.length;
                out.writeInt(columns);
                i = 0;
                while (i < columns) {
                    block10: {
                        serializer = this.getSerializer(types[i], version);
                        try {
                            serializer.writeColumn(out, i, batch);
                            break block10;
                        }
                        catch (ClassCastException e) {
                            obj = null;
                            objectClass = null;
                            row = 0;
                            ** while (row < batch.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            obj = batch.get(row).get(i);
                            if (obj != null) {
                                objectClass = obj.getClass().getName();
                                break;
                            }
                            ++row;
                            continue;
                        }
lbl29:
                        // 2 sources

                        throw new RuntimeException(Messages.gs(Messages.TEIID.TEIID20001, new Object[]{types[i], new Integer(i), objectClass}), e);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public List<List<Object>> readBatch(ObjectInput in, String[] types) throws IOException, ClassNotFoundException {
        int rows = in.readInt();
        if (rows == 0) {
            return new ArrayList<List<Object>>(0);
        }
        if (rows == -1) {
            return null;
        }
        byte version = 0;
        if (rows < 0) {
            rows = -(rows + 1);
            version = in.readByte();
        }
        int columns = in.readInt();
        ResizingArrayList<List<Object>> batch = new ResizingArrayList<List<Object>>(rows);
        int numBytes = rows / 8;
        int extraRows = rows % 8;
        int currentRow = 0;
        while (currentRow < rows) {
            batch.add(currentRow, Arrays.asList(new Object[columns]));
            ++currentRow;
        }
        byte[] isNullBuffer = new byte[extraRows > 0 ? numBytes + 1 : numBytes];
        int col = 0;
        while (col < columns) {
            this.getSerializer(types[col], version).readColumn(in, col, batch, isNullBuffer);
            ++col;
        }
        return batch;
    }

    private class ArrayColumnSerializer2
    extends ColumnSerializer {
        ObjectColumnSerializer ser;

        public ArrayColumnSerializer2(ObjectColumnSerializer ser) {
            super(null, null);
            this.ser = ser;
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            Object[] values = null;
            try {
                values = (Object[])((java.sql.Array)obj).getArray();
            }
            catch (SQLException sQLException) {
                out.writeInt(-1);
                return;
            }
            out.writeInt(values.length);
            DataTypeManagerService.DefaultDataTypes dataType = Batch2Serializer.this.getDataTypeManager().getDataType(values.getClass().getComponentType());
            int code = dataType.ordinal();
            out.writeByte((byte)code);
            int i = 0;
            while (i < values.length) {
                Batch2Serializer.writeIsNullData(out, i, values);
                int end = Math.min(values.length, i + 8);
                while (i < end) {
                    if (values[i] != null) {
                        this.ser.writeObject(out, values[i], code);
                    }
                    ++i;
                }
            }
            out.writeBoolean(obj instanceof ArrayImpl && ((ArrayImpl)obj).isZeroBased());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            if (length == -1) {
                return new ArrayImpl(Batch2Serializer.this.getTeiidVersion(), null);
            }
            byte code = in.readByte();
            DataTypeManagerService.DefaultDataTypes dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch2Serializer.this.getTeiidVersion(), code);
            Object[] vals = (Object[])Array.newInstance(dataType.getTypeClass(), length);
            int i = 0;
            while (i < length) {
                byte b = in.readByte();
                int end = Math.min(length, i + 8);
                while (i < end) {
                    if (!Batch2Serializer.this.isNullObject(i, b)) {
                        vals[i] = this.ser.readObject(in, code);
                    }
                    ++i;
                }
            }
            ArrayImpl result = new ArrayImpl(Batch2Serializer.this.getTeiidVersion(), vals);
            result.setZeroBased(in.readBoolean());
            return result;
        }
    }

    private class BigDecimalColumnSerializer
    extends ColumnSerializer {
        private BigDecimalColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            BigDecimal val = (BigDecimal)obj;
            out.writeInt(val.scale());
            BigInteger unscaled = val.unscaledValue();
            byte[] bytes = unscaled.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            int scale = in.readInt();
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigDecimal(new BigInteger(bytes), scale);
        }
    }

    private class BigIntegerColumnSerializer
    extends ColumnSerializer {
        private BigIntegerColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            BigInteger val = (BigInteger)obj;
            byte[] bytes = val.toByteArray();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BigInteger(bytes);
        }
    }

    private class BinaryColumnSerializer
    extends ColumnSerializer {
        private BinaryColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            super.writeObject(out, ((BinaryType)obj).getBytesDirect());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            byte[] bytes = (byte[])super.readObject(in);
            return new BinaryType(bytes);
        }
    }

    private class BinaryColumnSerializer1
    extends ColumnSerializer {
        private BinaryColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            byte[] bytes = ((BinaryType)obj).getBytes();
            out.writeInt(bytes.length);
            out.write(bytes);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            return new BinaryType(bytes);
        }
    }

    private class BlobColumnSerializer1
    extends ColumnSerializer {
        private BlobColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            BlobType bt = new BlobType();
            bt.readExternal(in);
            return bt;
        }
    }

    private class BooleanColumnSerializer
    extends ColumnSerializer {
        private BooleanColumnSerializer() {
            super(null, null);
        }

        @Override
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
            int currentByte = 0;
            int mask = 128;
            int row = 0;
            while (row < batch.size()) {
                Object obj = batch.get(row).get(col);
                if (obj == null) {
                    currentByte |= mask;
                }
                if ((mask >>= 1) == 0) {
                    out.write(currentByte);
                    currentByte = 0;
                    mask = 128;
                }
                if (obj != null) {
                    if (((Boolean)obj).booleanValue()) {
                        currentByte |= mask;
                    }
                    if ((mask >>= 1) == 0) {
                        out.write(currentByte);
                        currentByte = 0;
                        mask = 128;
                    }
                }
                ++row;
            }
            if (mask != 128) {
                out.write(currentByte);
            }
        }

        @Override
        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
            int currentByte = 0;
            int mask = 0;
            int row = 0;
            while (row < batch.size()) {
                if (mask == 0) {
                    currentByte = in.read();
                    mask = 128;
                }
                boolean isNullVal = (currentByte & mask) != 0;
                mask >>= 1;
                if (!isNullVal) {
                    if (mask == 0) {
                        currentByte = in.read();
                        mask = 128;
                    }
                    batch.get(row).set(col, (currentByte & mask) == 0 ? Boolean.FALSE : Boolean.TRUE);
                    mask >>= 1;
                }
                ++row;
            }
        }
    }

    private class ByteColumnSerializer
    extends ColumnSerializer {
        private ByteColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeByte(((Byte)obj).byteValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readByte();
        }
    }

    private class CharColumnSerializer
    extends ColumnSerializer {
        private CharColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeChar(((Character)obj).charValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return Character.valueOf(in.readChar());
        }
    }

    private class ClobColumnSerializer1
    extends ColumnSerializer {
        private ClobColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((Externalizable)obj).writeExternal(out);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            ClobType ct = new ClobType();
            ct.readExternal(in);
            return ct;
        }
    }

    private class ColumnSerializer {
        private ColumnSerializer() {
        }

        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
            Batch2Serializer.writeIsNullData(out, col, batch);
            Object obj = null;
            int i = 0;
            while (i < batch.size()) {
                obj = batch.get(i).get(col);
                if (obj != null) {
                    this.writeObject(out, obj);
                }
                ++i;
            }
        }

        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
            Batch2Serializer.readIsNullData(in, isNull);
            int i = 0;
            while (i < batch.size()) {
                if (!Batch2Serializer.isNullObject(isNull, i)) {
                    batch.get(i).set(col, this.readObject(in));
                }
                ++i;
            }
        }

        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeObject(obj);
        }

        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            return in.readObject();
        }

        /* synthetic */ ColumnSerializer(ColumnSerializer columnSerializer, ColumnSerializer columnSerializer2) {
            this();
        }
    }

    private class DateColumnSerializer
    extends ColumnSerializer {
        private DateColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong(((Date)obj).getTime());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Date(in.readLong());
        }
    }

    private class DateColumnSerializer1
    extends ColumnSerializer {
        private DateColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            long time = ((Date)obj).getTime();
            if (time < MIN_DATE_32 || time > MAX_DATE_32) {
                throw new IOException(Messages.gs(Messages.TEIID.TEIID20029, obj.getClass().getName()));
            }
            out.writeInt((int)(time / 60000L) + DATE_NORMALIZER);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Date((((long)in.readInt() & 0xFFFFFFFFL) - (long)DATE_NORMALIZER) * 60000L);
        }
    }

    private class DoubleColumnSerializer
    extends ColumnSerializer {
        private DoubleColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeDouble((Double)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Double(in.readDouble());
        }
    }

    private class FloatColumnSerializer
    extends ColumnSerializer {
        private FloatColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeFloat(((Float)obj).floatValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Float(in.readFloat());
        }
    }

    private class IntColumnSerializer
    extends ColumnSerializer {
        private IntColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeInt((Integer)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readInt();
        }
    }

    private class LongColumnSerializer
    extends ColumnSerializer {
        private LongColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong((Long)obj);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readLong();
        }
    }

    private class NullColumnSerializer1
    extends ColumnSerializer {
        private NullColumnSerializer1() {
            super(null, null);
        }

        @Override
        public void writeColumn(ObjectOutput out, int col, List<? extends List<?>> batch) throws IOException {
        }

        @Override
        public void readColumn(ObjectInput in, int col, List<List<Object>> batch, byte[] isNull) throws IOException, ClassNotFoundException {
        }
    }

    private final class ObjectColumnSerializer
    extends ColumnSerializer {
        int highestKnownCode;
        byte version;

        public ObjectColumnSerializer(int highestKnownCode, byte version) {
            super(null, null);
            this.highestKnownCode = highestKnownCode;
            this.version = version;
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            DataTypeManagerService.DefaultDataTypes dataType = Batch2Serializer.this.getDataTypeManager().getDataType(obj.getClass());
            int code = dataType.ordinal();
            out.writeByte((byte)code);
            this.writeObject(out, obj, code);
        }

        protected void writeObject(ObjectOutput out, Object obj, int code) throws IOException {
            if (code == DataTypeManagerService.DefaultDataTypes.BOOLEAN.ordinal()) {
                if (Boolean.TRUE.equals(obj)) {
                    out.write(1);
                } else {
                    out.write(0);
                }
            } else if (code <= this.highestKnownCode && code != DataTypeManagerService.DefaultDataTypes.OBJECT.ordinal()) {
                DataTypeManagerService.DefaultDataTypes dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch2Serializer.this.getTeiidVersion(), code);
                ColumnSerializer s = Batch2Serializer.this.getSerializer(dataType.getId(), this.version);
                s.writeObject(out, obj);
            } else {
                super.writeObject(out, obj);
            }
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            byte code = in.readByte();
            return this.readObject(in, code);
        }

        private Object readObject(ObjectInput in, int code) throws IOException, ClassNotFoundException {
            if (code == DataTypeManagerService.DefaultDataTypes.BOOLEAN.ordinal()) {
                if (in.readByte() == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (code != DataTypeManagerService.DefaultDataTypes.OBJECT.ordinal()) {
                DataTypeManagerService.DefaultDataTypes dataType = DataTypeManagerService.DefaultDataTypes.valueOf(Batch2Serializer.this.getTeiidVersion(), code);
                ColumnSerializer s = Batch2Serializer.this.getSerializer(dataType.getId(), this.version);
                return s.readObject(in);
            }
            return super.readObject(in);
        }
    }

    private class ShortColumnSerializer
    extends ColumnSerializer {
        private ShortColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeShort(((Short)obj).shortValue());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return in.readShort();
        }
    }

    private class StringColumnSerializer1
    extends ColumnSerializer {
        private StringColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            String str = (String)obj;
            if (str.length() <= Batch2Serializer.this.MAX_UTF) {
                out.writeByte(116);
                out.writeUTF(str);
            } else {
                out.writeByte(124);
                out.writeObject(obj);
            }
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            if (in.readByte() == 116) {
                return in.readUTF();
            }
            return super.readObject(in);
        }
    }

    private class TimeColumnSerializer
    extends ColumnSerializer {
        private TimeColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            out.writeLong(((Time)obj).getTime());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Time(in.readLong());
        }
    }

    private class TimeColumnSerializer1
    extends ColumnSerializer {
        private TimeColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            long time = ((Time)obj).getTime();
            if (time < MIN_TIME_32 || time > MAX_TIME_32) {
                throw new IOException(Messages.gs(Messages.TEIID.TEIID20029, obj.getClass().getName()));
            }
            out.writeInt((int)(time / 1000L));
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            return new Time(((long)in.readInt() & 0xFFFFFFFFL) * 1000L);
        }
    }

    private class TimestampColumnSerializer
    extends ColumnSerializer {
        private TimestampColumnSerializer() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            Timestamp ts = (Timestamp)obj;
            out.writeLong(ts.getTime());
            out.writeInt(ts.getNanos());
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException {
            Timestamp ts = new Timestamp(in.readLong());
            ts.setNanos(in.readInt());
            return ts;
        }
    }

    private class XmlColumnSerializer1
    extends ColumnSerializer {
        private XmlColumnSerializer1() {
            super(null, null);
        }

        @Override
        protected void writeObject(ObjectOutput out, Object obj) throws IOException {
            ((XMLType)obj).writeExternal(out, (byte)2);
        }

        @Override
        protected Object readObject(ObjectInput in) throws IOException, ClassNotFoundException {
            XMLType xt = new XMLType();
            xt.readExternal(in, (byte)2);
            return xt;
        }
    }
}

