/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.dialogs;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.kie.eclipse.navigator.Activator;
import org.kie.eclipse.navigator.view.actions.dialogs.AbstractKieRequestDialog;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestChangeListener;
import org.kie.eclipse.navigator.view.actions.dialogs.IKieRequestValidator;
import org.kie.eclipse.navigator.view.actions.dialogs.KieRequestDialogPasswordField;
import org.kie.eclipse.navigator.view.actions.dialogs.KieRequestDialogSelectionField;
import org.kie.eclipse.navigator.view.actions.dialogs.KieRequestDialogTextField;
import org.kie.eclipse.server.IKieOrganizationHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;

public class CreateRepositoryRequestDialog
extends AbstractKieRequestDialog {
    IKieOrganizationHandler organization;
    KieRequestDialogTextField name;
    KieRequestDialogTextField description;
    KieRequestDialogTextField userName;
    KieRequestDialogPasswordField password;
    KieRequestDialogSelectionField requestType;
    KieRequestDialogTextField gitURL;

    public CreateRepositoryRequestDialog(Shell shell, final IKieOrganizationHandler organization) {
        super(shell, "Repository", new IKieRequestValidator(){

            @Override
            public String isValid(JsonObject object) {
                String gitURL;
                JsonValue jv = object.get("name");
                String name = jv == null ? null : jv.asString();
                jv = object.get("gitURL");
                String string = gitURL = jv == null ? null : jv.asString();
                if (name != null && !name.isEmpty()) {
                    try {
                        for (IKieRepositoryHandler rep : organization.getRepositories()) {
                            if (!rep.getName().equals(name)) continue;
                            return "Repository '" + name + "' already exists in this Organizational Unit";
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    return "Name is required";
                }
                if (gitURL == null || gitURL.isEmpty()) {
                    jv = object.get("requestType");
                    if (jv != null && "clone".equals(jv.asString())) {
                        return "Git URL of origin is required";
                    }
                } else {
                    try {
                        new URI(gitURL);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        return "Git URL is invalid";
                    }
                }
                return null;
            }
        });
        this.setTitleImage(Activator.getImage("icons/wizban/repository.png"));
        this.organization = organization;
    }

    @Override
    protected void createFields(Composite composite) {
        this.setMessage("Enter the Repository details");
        this.name = new KieRequestDialogTextField(composite, "Name:", "", this.properties, "name");
        this.name.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                CreateRepositoryRequestDialog.this.validate();
            }
        });
        this.description = new KieRequestDialogTextField(composite, "Description:", "", this.properties, "description");
        this.userName = new KieRequestDialogTextField(composite, "Username:", "", this.properties, "userName");
        this.password = new KieRequestDialogPasswordField(composite, "Password:", "", this.properties, "password");
        this.requestType = new KieRequestDialogSelectionField(composite, "Request Type:", new String[]{"Create New Repository", "Clone an existing Repository"}, new String[]{"new", "clone"}, 16, this.properties, "requestType");
        this.properties.set("requestType", "new");
        this.gitURL = new KieRequestDialogTextField(composite, "URL of a Repository to clone:", "", this.properties, "gitURL");
        this.gitURL.getControl().setEnabled(false);
        this.gitURL.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                CreateRepositoryRequestDialog.this.validate();
            }
        });
        this.requestType.setChangeListener(new IKieRequestChangeListener(){

            @Override
            public void objectChanged(JsonObject object) {
                JsonValue jv = object.get("requestType");
                if (jv != null) {
                    CreateRepositoryRequestDialog.this.gitURL.getControl().setEnabled("clone".equals(jv.asString()));
                }
                CreateRepositoryRequestDialog.this.validate();
            }
        });
    }

    @Override
    public JsonObject getResult() {
        this.properties.set("organizationalUnitName", this.organization.getName());
        return super.getResult();
    }
}

