/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification.checkers;

import java.util.List;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.invocation.InvocationMarker;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.InvocationsFinder;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.checkers.AtLeastDiscrepancy;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

public class AtLeastXNumberOfInvocationsInOrderChecker {
    private final Reporter reporter = new Reporter();
    private final InvocationsFinder finder = new InvocationsFinder();
    private final InvocationMarker invocationMarker = new InvocationMarker();
    private final InOrderContext orderingContext;

    public AtLeastXNumberOfInvocationsInOrderChecker(InOrderContext orderingContext) {
        this.orderingContext = orderingContext;
    }

    public void check(List<Invocation> invocations, InvocationMatcher wanted, int wantedCount) {
        List<Invocation> chunk = this.finder.findAllMatchingUnverifiedChunks(invocations, wanted, this.orderingContext);
        int actualCount = chunk.size();
        if (wantedCount > actualCount) {
            Location lastLocation = this.finder.getLastLocation(chunk);
            this.reporter.tooLittleActualInvocationsInOrder(new AtLeastDiscrepancy(wantedCount, actualCount), wanted, lastLocation);
        }
        this.invocationMarker.markVerifiedInOrder(chunk, wanted, this.orderingContext);
    }
}

