/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.invocation.StubInfoImpl;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.stubbing.StubbedInvocationMatcher;
import org.mockito.internal.stubbing.answers.AnswersValidator;
import org.mockito.internal.verification.RegisteredInvocations;
import org.mockito.invocation.Invocation;
import org.mockito.stubbing.Answer;

public class InvocationContainerImpl
implements InvocationContainer,
Serializable {
    private static final long serialVersionUID = -5334301962749537176L;
    private final LinkedList<StubbedInvocationMatcher> stubbed = new LinkedList();
    private final MockingProgress mockingProgress;
    private final List<Answer> answersForStubbing = new ArrayList<Answer>();
    private final RegisteredInvocations registeredInvocations = new RegisteredInvocations();
    private InvocationMatcher invocationForStubbing;

    public InvocationContainerImpl(MockingProgress mockingProgress) {
        this.mockingProgress = mockingProgress;
    }

    public void setInvocationForPotentialStubbing(InvocationMatcher invocation) {
        this.registeredInvocations.add(invocation.getInvocation());
        this.invocationForStubbing = invocation;
    }

    public void resetInvocationForPotentialStubbing(InvocationMatcher invocationMatcher) {
        this.invocationForStubbing = invocationMatcher;
    }

    public void addAnswer(Answer answer) {
        this.registeredInvocations.removeLast();
        this.addAnswer(answer, false);
    }

    public void addConsecutiveAnswer(Answer answer) {
        this.addAnswer(answer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnswer(Answer answer, boolean isConsecutive) {
        Invocation invocation = this.invocationForStubbing.getInvocation();
        this.mockingProgress.stubbingCompleted(invocation);
        AnswersValidator answersValidator = new AnswersValidator();
        answersValidator.validate(answer, invocation);
        LinkedList<StubbedInvocationMatcher> linkedList = this.stubbed;
        synchronized (linkedList) {
            if (isConsecutive) {
                this.stubbed.getFirst().addAnswer(answer);
            } else {
                this.stubbed.addFirst(new StubbedInvocationMatcher(this.invocationForStubbing, answer));
            }
        }
    }

    Object answerTo(Invocation invocation) throws Throwable {
        return this.findAnswerFor(invocation).answer(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StubbedInvocationMatcher findAnswerFor(Invocation invocation) {
        LinkedList<StubbedInvocationMatcher> linkedList = this.stubbed;
        synchronized (linkedList) {
            for (StubbedInvocationMatcher s : this.stubbed) {
                if (!s.matches(invocation)) continue;
                s.markStubUsed(invocation);
                invocation.markStubbed(new StubInfoImpl(s));
                return s;
            }
        }
        return null;
    }

    public void addAnswerForVoidMethod(Answer answer) {
        this.answersForStubbing.add(answer);
    }

    public void setAnswersForStubbing(List<Answer> answers) {
        this.answersForStubbing.addAll(answers);
    }

    public boolean hasAnswersForStubbing() {
        return !this.answersForStubbing.isEmpty();
    }

    public boolean hasInvocationForPotentialStubbing() {
        return !this.registeredInvocations.isEmpty();
    }

    public void setMethodForStubbing(InvocationMatcher invocation) {
        this.invocationForStubbing = invocation;
        assert (this.hasAnswersForStubbing());
        int i = 0;
        while (i < this.answersForStubbing.size()) {
            this.addAnswer(this.answersForStubbing.get(i), i != 0);
            ++i;
        }
        this.answersForStubbing.clear();
    }

    public String toString() {
        return "invocationForStubbing: " + this.invocationForStubbing;
    }

    @Override
    public List<Invocation> getInvocations() {
        return this.registeredInvocations.getAll();
    }

    @Override
    public List<StubbedInvocationMatcher> getStubbedInvocations() {
        return this.stubbed;
    }

    public Object invokedMock() {
        return this.invocationForStubbing.getInvocation().getMock();
    }

    public InvocationMatcher getInvocationForStubbing() {
        return this.invocationForStubbing;
    }
}

