/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.fusesource.ide.branding.wizards.WizardMessages;
import org.fusesource.ide.camel.model.CamelModelHelper;
import org.fusesource.ide.camel.model.Endpoint;
import org.fusesource.ide.camel.model.EndpointSummary;
import org.fusesource.ide.camel.model.RouteContainer;
import org.fusesource.ide.camel.model.io.XmlContainerMarshaller;

public class NewCamelTestWizardPageTwo
extends WizardPage {
    private static final String PAGE_NAME = "NewCamelTestWizardPage2";
    private static final String STORE_CREATE_FINAL_METHOD_STUBS = "NewCamelTestWizardPage2.CREATE_FINAL_METHOD_STUBS";
    private static final String STORE_USE_TASKMARKER = "NewCamelTestWizardPage2.USE_TASKMARKER";
    private Object[] fCheckedObjects;
    private Button fCreateFinalMethodStubsButton;
    private boolean fCreateFinalStubs;
    private boolean fCreateTasks;
    private Button fCreateTasksButton;
    private Button fDeselectAllButton;
    private ContainerCheckedTreeViewer fInputEndpointsTree;
    private Button fSelectAllButton;
    private Label fSelectedEndpointsLabel;
    private IFile xmlFileUnderTest;

    public NewCamelTestWizardPageTwo() {
        super(PAGE_NAME);
        this.setTitle(WizardMessages.NewCamelTestWizardPageTwo_title);
        this.setDescription(WizardMessages.NewCamelTestWizardPageTwo_description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createEndpointsTreeControls(container);
        this.setControl((Control)container);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.fusesource.ide.camel.editor.newCamelTestcase2");
    }

    private void createEndpointsTreeControls(Composite container) {
        Label label = new Label(container, 16448);
        label.setFont(container.getFont());
        label.setText(WizardMessages.NewCamelTestWizardPageTwo_methods_tree_label);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fInputEndpointsTree = new ContainerCheckedTreeViewer(container, 2048);
        gd = new GridData(1808);
        gd.heightHint = 180;
        this.fInputEndpointsTree.getTree().setLayoutData((Object)gd);
        this.fInputEndpointsTree.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
        this.fInputEndpointsTree.setAutoExpandLevel(2);
        this.fInputEndpointsTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                NewCamelTestWizardPageTwo.this.doCheckedStateChanged();
            }
        });
        Composite buttonContainer = new Composite(container, 0);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginWidth = 0;
        buttonLayout.marginHeight = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fSelectAllButton = new Button(buttonContainer, 8);
        this.fSelectAllButton.setText(WizardMessages.NewCamelTestWizardPageTwo_selectAll);
        gd = new GridData(770);
        this.fSelectAllButton.setLayoutData((Object)gd);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCamelTestWizardPageTwo.this.selectAllEndpoints();
                NewCamelTestWizardPageTwo.this.doCheckedStateChanged();
            }
        });
        LayoutUtil.setButtonDimensionHint((Button)this.fSelectAllButton);
        this.fDeselectAllButton = new Button(buttonContainer, 8);
        this.fDeselectAllButton.setText(WizardMessages.NewCamelTestWizardPageTwo_deselectAll);
        gd = new GridData(770);
        this.fDeselectAllButton.setLayoutData((Object)gd);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewCamelTestWizardPageTwo.this.fInputEndpointsTree.setCheckedElements(new Object[0]);
                NewCamelTestWizardPageTwo.this.doCheckedStateChanged();
            }
        });
        LayoutUtil.setButtonDimensionHint((Button)this.fDeselectAllButton);
        this.fSelectedEndpointsLabel = new Label(container, 16384);
        this.fSelectedEndpointsLabel.setFont(container.getFont());
        this.doCheckedStateChanged();
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fSelectedEndpointsLabel.setLayoutData((Object)gd);
        Label emptyLabel = new Label(container, 16384);
        gd = new GridData();
        gd.horizontalSpan = 1;
        emptyLabel.setLayoutData((Object)gd);
        this.onXmlFileUnderTestChanged();
    }

    private void doCheckedStateChanged() {
        Object[] checked = this.fInputEndpointsTree.getCheckedElements();
        this.fCheckedObjects = checked;
        int checkedEndpointCount = 0;
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof EndpointTreeNode) {
                ++checkedEndpointCount;
            }
            ++n2;
        }
        String label = "";
        label = checkedEndpointCount == 1 ? Messages.format((String)WizardMessages.NewCamelTestWizardPageTwo_selected_endpoints_label_one, (Object)new Integer(checkedEndpointCount)) : Messages.format((String)WizardMessages.NewCamelTestWizardPageTwo_selected_endpoints_label_many, (Object)new Integer(checkedEndpointCount));
        this.fSelectedEndpointsLabel.setText(label);
    }

    public EndpointMaps getCheckedEndpointMaps() {
        List<EndpointTreeNode> endpoints = this.getCheckedEndpoints();
        LinkedHashMap<String, String> inputEndpoints = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> outputEndpoints = new LinkedHashMap<String, String>();
        int inputCounter = 0;
        int outputCounter = 0;
        for (EndpointTreeNode node : endpoints) {
            String key;
            String value = node.getUri();
            if (node.isInput()) {
                key = "input";
                if (CamelModelHelper.isTimerEndpointURI((String)value)) continue;
                if (inputCounter++ > 0) {
                    key = String.valueOf(key) + inputCounter;
                }
                inputEndpoints.put(key, value);
                continue;
            }
            key = "output";
            if (outputCounter++ > 0) {
                key = String.valueOf(key) + outputCounter;
            }
            outputEndpoints.put(key, value);
        }
        return new EndpointMaps(inputEndpoints, outputEndpoints);
    }

    public List<EndpointTreeNode> getCheckedEndpoints() {
        ArrayList<EndpointTreeNode> list = new ArrayList<EndpointTreeNode>();
        if (this.fCheckedObjects != null) {
            Object[] objectArray = this.fCheckedObjects;
            int n = this.fCheckedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EndpointTreeNode) {
                    list.add((EndpointTreeNode)((Object)object));
                }
                ++n2;
            }
        }
        return list;
    }

    public boolean getCreateFinalMethodStubsButtonSelection() {
        return this.fCreateFinalStubs;
    }

    public boolean isCreateTasks() {
        return this.fCreateTasks;
    }

    protected TreeNode loadEndpointSummary() {
        XmlContainerMarshaller marshaller = new XmlContainerMarshaller();
        RouteContainer routeContainer = marshaller.loadRoutes(this.xmlFileUnderTest);
        EndpointSummary summary = new EndpointSummary(routeContainer);
        TreeNode root = new TreeNode((Object)"Endpoints");
        TreeNode inputs = new TreeNode((Object)"Inputs");
        TreeNode outputs = new TreeNode((Object)"Outputs");
        inputs.setParent(root);
        outputs.setParent(root);
        root.setChildren(new TreeNode[]{inputs, outputs});
        this.setChildren(inputs, summary.getInputEndpoints(), true);
        this.setChildren(outputs, summary.getOutputEndpoints(), false);
        return root;
    }

    protected void onXmlFileUnderTestChanged() {
        if (this.xmlFileUnderTest == null || this.fInputEndpointsTree == null) {
            return;
        }
        TreeNode root = this.loadEndpointSummary();
        this.fInputEndpointsTree.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.fInputEndpointsTree.setInput((Object)new TreeNode[]{root});
        this.fInputEndpointsTree.setLabelProvider((IBaseLabelProvider)new EndpointsLabelProvider());
        this.selectAllEndpoints();
        this.fInputEndpointsTree.expandAll();
        this.doCheckedStateChanged();
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fCreateTasks = settings.getBoolean(STORE_USE_TASKMARKER);
            if (this.fCreateTasksButton != null) {
                this.fCreateTasksButton.setSelection(this.fCreateTasks);
            }
            this.fCreateFinalStubs = settings.getBoolean(STORE_CREATE_FINAL_METHOD_STUBS);
            if (this.fCreateFinalMethodStubsButton != null) {
                this.fCreateFinalMethodStubsButton.setSelection(this.fCreateFinalStubs);
            }
        }
    }

    protected void selectAllEndpoints() {
        this.fInputEndpointsTree.setCheckedElements((Object[])this.fInputEndpointsTree.getInput());
    }

    private void setChildren(TreeNode node, Map<String, Endpoint> endpointMap, boolean input) {
        Set<String> uris = endpointMap.keySet();
        TreeNode[] children = new TreeNode[uris.size()];
        int idx = 0;
        for (String uri : uris) {
            EndpointTreeNode child = new EndpointTreeNode(uri, input);
            child.setParent(node);
            children[idx++] = child;
        }
        node.setChildren(children);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fInputEndpointsTree.getControl().setFocus();
        }
    }

    public void setXmlFileUnderTest(IFile xmlFileUnderTest) {
        this.xmlFileUnderTest = xmlFileUnderTest;
        this.onXmlFileUnderTestChanged();
    }

    public static class EndpointMaps {
        private String inputEndpoint;
        private final Map<String, String> inputEndpoints;
        private final Map<String, String> outputEndpoints;

        public EndpointMaps(Map<String, String> inputEndpoints, Map<String, String> outputEndpoints) {
            this.inputEndpoints = inputEndpoints;
            this.outputEndpoints = outputEndpoints;
            for (String name : inputEndpoints.keySet()) {
                if (this.inputEndpoint != null) continue;
                this.inputEndpoint = this.getInputEndpointVariableName(name);
                break;
            }
        }

        public String getInputEndpoint() {
            return this.inputEndpoint;
        }

        public Map<String, String> getInputEndpoints() {
            return this.inputEndpoints;
        }

        public String getInputEndpointVariableName(String name) {
            return String.valueOf(name) + "Endpoint";
        }

        public Map<String, String> getOutputEndpoints() {
            return this.outputEndpoints;
        }
    }

    protected static class EndpointTreeNode
    extends TreeNode {
        private final boolean input;

        public EndpointTreeNode(Object value, boolean input) {
            super(value);
            this.input = input;
        }

        public String getUri() {
            return this.getValue().toString();
        }

        public boolean isInput() {
            return this.input;
        }
    }

    protected static class EndpointsLabelProvider
    extends LabelProvider
    implements ITreePathLabelProvider {
        protected EndpointsLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, TreePath elementPath) {
            Object last = elementPath.getLastSegment();
            String text = null;
            if (last instanceof TreeNode) {
                TreeNode node = (TreeNode)last;
                text = node.getValue().toString();
            } else {
                text = last.toString();
            }
            label.setText(text);
        }
    }
}

