/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.manifest.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.dynamic.DynamicModel;

public class XmlVdbAdapters {

    private static abstract class AbstractPreferenceAdapter<V, B>
    extends XmlAdapter<V, B> {
        private AbstractPreferenceAdapter() {
        }

        protected boolean isSuppressEnabled() {
            IEclipsePreferences preferences = VdbPlugin.singleton().getPreferences();
            return preferences.getBoolean("suppressXmlDefaultAttributes", true);
        }
    }

    private static abstract class BooleanAttributeAdapter
    extends AbstractPreferenceAdapter<Boolean, Boolean> {
        private boolean inverse;

        private BooleanAttributeAdapter() {
        }

        protected void inverse() {
            this.inverse = true;
        }

        public Boolean unmarshal(Boolean value) throws Exception {
            return value;
        }

        public Boolean marshal(Boolean value) throws Exception {
            if (!this.isSuppressEnabled()) {
                return value;
            }
            if (value.booleanValue() && !this.inverse || !value.booleanValue() && this.inverse) {
                return null;
            }
            return value;
        }
    }

    public static class ConstraintAttributeAdapter
    extends BooleanAttributeAdapter {
    }

    public static class ModelTypeAttributeAdapter
    extends AbstractPreferenceAdapter<String, String> {
        public String unmarshal(String value) throws Exception {
            return value;
        }

        public String marshal(String value) throws Exception {
            if (!this.isSuppressEnabled()) {
                return value;
            }
            if (DynamicModel.Type.PHYSICAL.toString().equals(value)) {
                return null;
            }
            return value;
        }
    }

    public static class VisibleAttributeAdapter
    extends BooleanAttributeAdapter {
    }
}

