/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.manifest;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.teiid.designer.roles.Permission;
import org.teiid.designer.vdb.manifest.ConditionElement;
import org.teiid.designer.vdb.manifest.MaskElement;
import org.teiid.designer.vdb.manifest.Visitor;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
public class PermissionElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="resource-name", required=true)
    private String resource_name;
    @XmlElement(name="allow-create")
    private Boolean create;
    @XmlElement(name="allow-read")
    private Boolean read;
    @XmlElement(name="allow-update")
    private Boolean update;
    @XmlElement(name="allow-delete")
    private Boolean delete;
    @XmlElement(name="allow-execute")
    private Boolean execute;
    @XmlElement(name="allow-alter")
    private Boolean alter;
    @XmlElement(name="condition", type=ConditionElement.class)
    private ConditionElement condition;
    @XmlElement(name="mask", type=MaskElement.class)
    private MaskElement mask;
    @XmlElement(name="allow-language", required=false)
    private Boolean allowLanguage = Boolean.FALSE;

    public PermissionElement() {
    }

    public PermissionElement(Permission permission) {
        this.resource_name = permission.getTargetName();
        if (!permission.isAllowLanguage()) {
            this.create = permission.isCreateAllowed();
            this.read = permission.isReadAllowed();
            this.update = permission.isUpdateAllowed();
            this.delete = permission.isDeleteAllowed();
            this.execute = permission.isExecuteAllowed();
            this.alter = permission.isAlterAllowed();
            if (permission.getCondition() != null && permission.getCondition().length() > 0) {
                this.condition = new ConditionElement(permission.getCondition(), permission.isConstraint());
            }
            if (permission.getMask() != null && permission.getMask().length() > 0) {
                this.mask = new MaskElement(permission.getMask(), permission.getOrder());
            }
            this.allowLanguage = null;
        } else {
            this.allowLanguage = Boolean.TRUE;
            this.create = null;
            this.read = null;
            this.update = null;
            this.delete = null;
            this.execute = null;
            this.alter = null;
            this.condition = null;
            this.mask = null;
        }
    }

    public String getResourceName() {
        return this.resource_name;
    }

    public Boolean isCreate() {
        return this.create;
    }

    public Boolean isRead() {
        return this.read;
    }

    public Boolean isUpdate() {
        return this.update;
    }

    public Boolean isDelete() {
        return this.delete;
    }

    public Boolean isExecute() {
        return this.execute;
    }

    public Boolean isAlter() {
        return this.alter;
    }

    public ConditionElement getCondition() {
        return this.condition;
    }

    public MaskElement getMask() {
        return this.mask;
    }

    public Boolean isAllowLanguage() {
        return this.allowLanguage;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

