/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.manifest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbIndexedEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbSource;
import org.teiid.designer.vdb.dynamic.DynamicModel;
import org.teiid.designer.vdb.dynamic.Metadata;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.MetadataElement;
import org.teiid.designer.vdb.manifest.ProblemElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.SourceElement;
import org.teiid.designer.vdb.manifest.Visitor;
import org.teiid.designer.vdb.manifest.adapters.XmlVdbAdapters;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="")
public class ModelElement
extends EntryElement {
    public static final String MODEL_UUID = "modelUuid";
    public static final String MODEL_CLASS = "modelClass";
    public static final String BUILT_IN = "builtIn";
    public static final String IMPORTS = "imports";
    public static final String IMPORT_VDB_REFERENCE = "import-vdb-reference";
    public static final String SUPPORTS_MULTI_SOURCE = "supports-multi-source-bindings";
    public static final String MULTI_SOURCE_ADD_COLUMN = "multisource.addColumn";
    public static final String MULTI_SOURCE_COLUMN_ALIAS = "multisource.columnName";
    private static final long serialVersionUID = 1L;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="type", required=false)
    @XmlJavaTypeAdapter(value=XmlVdbAdapters.ModelTypeAttributeAdapter.class)
    private String type = "PHYSICAL";
    @XmlAttribute(name="visible", required=false)
    @XmlJavaTypeAdapter(value=XmlVdbAdapters.VisibleAttributeAdapter.class)
    private Boolean visible = true;
    @XmlElement(name="source", type=SourceElement.class)
    private List<SourceElement> sources;
    @XmlElement(name="metadata", type=MetadataElement.class)
    private List<MetadataElement> metadata;
    @XmlElement(name="validation-error", type=ProblemElement.class)
    private List<ProblemElement> problems;

    public ModelElement() {
    }

    ModelElement(VdbModelEntry entry) throws Exception {
        super(entry);
        String modelClass;
        String lastSeg = entry.getPath().lastSegment();
        int ndx = lastSeg.lastIndexOf(46);
        this.name = ndx < 0 ? lastSeg : lastSeg.substring(0, ndx);
        this.type = entry.getType();
        this.visible = entry.isVisible();
        for (VdbSource source : entry.getSourceInfo().getSources()) {
            this.getSources().add(new SourceElement(source));
        }
        for (VdbIndexedEntry.Problem problem : entry.getProblems()) {
            this.getProblems().add(new ProblemElement(problem));
        }
        List<PropertyElement> props = this.getProperties();
        String modelUuid = entry.getModelUuid();
        if (modelUuid != null) {
            props.add(new PropertyElement(MODEL_UUID, entry.getModelUuid()));
        }
        if ((modelClass = entry.getModelClass()) != null) {
            props.add(new PropertyElement(MODEL_CLASS, entry.getModelClass()));
        }
        props.add(new PropertyElement(BUILT_IN, Boolean.toString(entry.isBuiltIn())));
        if (entry.getSourceInfo().isMultiSource()) {
            String string;
            props.add(new PropertyElement(SUPPORTS_MULTI_SOURCE, Boolean.toString(true)));
            if (entry.getSourceInfo().isAddColumn()) {
                props.add(new PropertyElement(MULTI_SOURCE_ADD_COLUMN, Boolean.toString(true)));
            }
            if ((string = entry.getSourceInfo().getColumnAlias()) != null && string.length() > 0) {
                props.add(new PropertyElement(MULTI_SOURCE_COLUMN_ALIAS, string));
            }
        }
        for (VdbEntry vdbEntry : entry.getImports()) {
            props.add(new PropertyElement(IMPORTS, vdbEntry.getName().toString()));
        }
        for (String string : entry.getImportVdbNames()) {
            props.add(new PropertyElement(IMPORT_VDB_REFERENCE, string));
        }
        if (entry.getSchemaText() != null) {
            this.getMetadata().add(new MetadataElement(entry.getSchemaText(), entry.getType()));
        }
    }

    ModelElement(DynamicModel model) throws Exception {
        String alias;
        this.name = model.getName();
        this.type = model.getModelType().toString();
        this.visible = model.isVisible();
        this.path = null;
        if (model.getDescription() != null && !model.getDescription().isEmpty()) {
            this.description = model.getDescription();
        }
        VdbSource[] vdbSourceArray = model.getSources();
        int n = vdbSourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            VdbSource source = vdbSourceArray[n2];
            this.getSources().add(new SourceElement(source));
            ++n2;
        }
        if (model.isMultiSource()) {
            this.getProperties().add(new PropertyElement(SUPPORTS_MULTI_SOURCE, Boolean.toString(model.isMultiSource())));
        }
        if (model.doAddColumn()) {
            this.getProperties().add(new PropertyElement(MULTI_SOURCE_ADD_COLUMN, Boolean.toString(model.doAddColumn())));
        }
        if ((alias = model.getColumnAlias()) != null && alias.length() > 0) {
            this.getProperties().add(new PropertyElement(MULTI_SOURCE_COLUMN_ALIAS, alias));
        }
        for (Map.Entry<Object, Object> entry : model.getProperties().entrySet()) {
            this.getProperties().add(new PropertyElement(entry.getKey().toString(), entry.getValue().toString()));
        }
        Metadata metadata = model.getMetadata();
        if (metadata != null && metadata.getSchemaText() != null) {
            MetadataElement metadataElement = new MetadataElement(metadata.getSchemaText(), metadata.getType().name());
            this.getMetadata().add(metadataElement);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<ProblemElement> getProblems() {
        if (this.problems == null) {
            this.problems = new ArrayList<ProblemElement>();
        }
        return this.problems;
    }

    public List<SourceElement> getSources() {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceElement>();
        }
        return this.sources;
    }

    public List<MetadataElement> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new ArrayList<MetadataElement>();
        }
        return this.metadata;
    }

    public String getType() {
        if ("TYPE".equalsIgnoreCase(this.type.toUpperCase())) {
            return "OTHER";
        }
        return this.type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append("PropertyElement : ");
        text.append("\n\t name  = ").append(this.getName());
        text.append("\n\t type = ").append(this.getType());
        text.append("\n\t visibility = ").append(this.isVisible());
        return text.toString();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

