/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic;

import org.teiid.designer.vdb.VdbUnit;

public class Metadata
extends VdbUnit {
    private Type type = Type.DDL;
    private String schemaText = "";

    public Metadata() {
    }

    public Metadata(String schemaText, Type type) {
        this();
        this.schemaText = schemaText;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    private Type getTypeForString(String type) {
        if (type.toUpperCase().equals(Type.DDL.toString())) {
            return Type.DDL;
        }
        if (type.toUpperCase().equals(Type.DDL_FILE.toString())) {
            return Type.DDL_FILE;
        }
        if (type.toUpperCase().equals(Type.NATIVE.toString())) {
            return Type.NATIVE;
        }
        if (type.toUpperCase().equals(Type.INDEX.toString())) {
            return Type.INDEX;
        }
        return Type.DDL;
    }

    public void setType(Type type) {
        if (this.type != type) {
            this.type = type;
            this.setChanged(true);
        }
    }

    public void setType(String type) {
        Type theType = this.getTypeForString(type);
        this.setType(theType);
    }

    public String getSchemaText() {
        return this.schemaText;
    }

    public void setSchemaText(String newSchemaText) {
        this.setChanged(this.schemaText, newSchemaText);
        this.schemaText = newSchemaText;
    }

    public String toString() {
        return "Metadata [type=" + (Object)((Object)this.type) + ", schemaText=" + this.schemaText + "]";
    }

    @Override
    public Metadata clone() {
        Metadata clone = new Metadata(this.getSchemaText(), this.getType());
        this.cloneVdbObject(clone);
        return clone;
    }

    public static enum Type {
        DDL,
        DDL_FILE,
        NATIVE,
        INDEX;

        public static final Type DEFAULT_VALUE;

        static {
            DEFAULT_VALUE = DDL;
        }

        public String getType() {
            String name = this.name().replace("_", "-");
            return name;
        }

        public String toString() {
            return this.getType();
        }
    }
}

