/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic;

import java.util.Comparator;
import org.teiid.designer.vdb.dynamic.DynamicModel;
import org.teiid.designer.vdb.dynamic.Metadata;

public class DynamicModelComparator
implements Comparator<DynamicModel> {
    @Override
    public int compare(DynamicModel dynModel1, DynamicModel dynModel2) {
        DynamicModel.Type model1Type = dynModel1.getModelType();
        DynamicModel.Type model2Type = dynModel2.getModelType();
        if (DynamicModel.Type.PHYSICAL.equals((Object)model1Type) && !DynamicModel.Type.PHYSICAL.equals((Object)model2Type)) {
            return -1;
        }
        if (!DynamicModel.Type.PHYSICAL.equals((Object)model1Type) && DynamicModel.Type.PHYSICAL.equals((Object)model2Type)) {
            return 1;
        }
        String model1Name = dynModel1.getName();
        String model2Name = dynModel2.getName();
        Metadata mdata1 = dynModel1.getMetadata();
        Metadata mdata2 = dynModel2.getMetadata();
        if (mdata1 == null && mdata2 != null) {
            return -1;
        }
        if (mdata1 == null && mdata2 == null) {
            return 0;
        }
        if (mdata1 != null && mdata2 == null) {
            return 1;
        }
        String schema1Text = mdata1.getSchemaText();
        String schema2Text = mdata2.getSchemaText();
        if (schema1Text == null && schema2Text != null) {
            return -1;
        }
        if (schema1Text == null && schema2Text == null) {
            return 0;
        }
        if (schema1Text != null && schema2Text == null) {
            return 1;
        }
        if (schema1Text.contains(model2Name)) {
            return 1;
        }
        if (schema2Text.contains(model1Name)) {
            return -1;
        }
        return 0;
    }
}

