/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic;

import java.util.HashMap;
import java.util.Map;
import org.teiid.designer.vdb.VdbSource;
import org.teiid.designer.vdb.VdbUnit;
import org.teiid.designer.vdb.dynamic.Metadata;

public class DynamicModel
extends VdbUnit {
    private Type modelType = Type.DEFAULT_VALUE;
    private boolean isVisible = true;
    private Map<String, VdbSource> modelSources = new HashMap<String, VdbSource>();
    private boolean allowMultiSource;
    private boolean addColumn;
    private String columnAlias = "";
    private Metadata metadata;

    public DynamicModel() {
    }

    public DynamicModel(String name) {
        this();
        this.setName(name);
    }

    public void addSource(VdbSource source) {
        this.modelSources.put(source.getName(), source);
        source.setVdb(this.getVdb());
    }

    public Type getModelType() {
        return this.modelType;
    }

    private Type getTypeForString(String type) {
        if (type.toUpperCase().equals(Type.PHYSICAL.toString())) {
            return Type.PHYSICAL;
        }
        if (type.toUpperCase().equals(Type.VIRTUAL.toString())) {
            return Type.VIRTUAL;
        }
        return Type.PHYSICAL;
    }

    public VdbSource[] getSources() {
        return this.modelSources.values().toArray(new VdbSource[this.modelSources.size()]);
    }

    public void removeSource(String sourceName) {
        VdbSource removed = this.modelSources.remove(sourceName);
        this.setChanged(removed != null);
    }

    public void setModelType(Type newModelType) {
        this.modelType = newModelType;
    }

    public void setModelType(String newModelType) {
        this.setModelType(this.getTypeForString(newModelType));
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public boolean allowMultiSource() {
        return this.allowMultiSource;
    }

    public void setAllowMultiSource(boolean allowMultiSource) {
        this.allowMultiSource = allowMultiSource;
    }

    public boolean isMultiSource() {
        return this.getSources().length > 1;
    }

    public void setAddColumn(boolean value) {
        this.addColumn = value;
    }

    public boolean doAddColumn() {
        return this.addColumn;
    }

    public String getColumnAlias() {
        return this.columnAlias;
    }

    public void setColumnAlias(String columnAlias) {
        this.columnAlias = columnAlias;
    }

    @Override
    public DynamicModel clone() {
        DynamicModel clone = new DynamicModel();
        this.cloneVdbObject(clone);
        clone.setModelType(this.getModelType());
        clone.setVisible(this.isVisible());
        clone.setAllowMultiSource(this.allowMultiSource());
        clone.setAddColumn(this.doAddColumn());
        clone.setColumnAlias(this.getColumnAlias());
        if (this.getMetadata() != null) {
            clone.setMetadata(this.getMetadata().clone());
        }
        for (VdbSource source : this.modelSources.values()) {
            clone.addSource(source.clone());
        }
        return clone;
    }

    public static enum Type {
        PHYSICAL,
        VIRTUAL;

        public static final Type DEFAULT_VALUE;

        static {
            DEFAULT_VALUE = PHYSICAL;
        }

        public String getType() {
            String name = this.name();
            return name;
        }

        public String toString() {
            return this.getType();
        }

        public static Type fromString(String typeId) {
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (type.getType().equalsIgnoreCase(typeId)) {
                    return type;
                }
                ++n2;
            }
            return null;
        }
    }
}

