/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.ChecksumUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.OperationUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.roles.DataRole;
import org.teiid.designer.runtime.version.spi.ITeiidServerVersion;
import org.teiid.designer.runtime.version.spi.TeiidServerVersion;
import org.teiid.designer.vdb.AllowedLanguages;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbConstants;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbModelEntry;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.file.ValidationVersionCallback;
import org.teiid.designer.vdb.file.VdbFileProcessor;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.MetadataElement;
import org.teiid.designer.vdb.manifest.ModelElement;
import org.teiid.designer.vdb.manifest.ProblemElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.Severity;
import org.teiid.designer.vdb.manifest.SourceElement;
import org.teiid.designer.vdb.manifest.VdbElement;
import org.xml.sax.SAXException;

public class VdbUtil
implements VdbConstants {
    public static final String PHYSICAL = "PHYSICAL";
    public static final String VIRTUAL = "VIRTUAL";
    public static final String FUNCTION = "FUNCTION";
    public static final String OTHER = "OTHER";
    public static final String DEPRECATED_TYPE = "TYPE";
    public static final String XML_EXTENSION = "XML";

    public static Collection<IFile> getVdbModels(Vdb theVdb) {
        ArrayList<IFile> iFiles = new ArrayList<IFile>();
        for (VdbEntry vdbEntry : theVdb.getModelEntries()) {
            IResource resource = ModelerCore.getWorkspace().getRoot().findMember(vdbEntry.getPath());
            if (resource == null || !resource.exists()) continue;
            iFiles.add((IFile)resource);
        }
        return iFiles;
    }

    public static boolean isPreviewVdb(IFile file) throws Exception {
        CoreArgCheck.isNotNull((Object)file, (String)"file is null");
        if (file.exists()) {
            if (file.getLocation().toFile().length() == 0L) {
                if (!"vdb".equals(file.getFileExtension())) {
                    return false;
                }
                return file.getName().startsWith("PREVIEW_");
            }
            VdbElement manifest = VdbUtil.getVdbManifest(file);
            if (manifest != null) {
                for (PropertyElement property : manifest.getProperties()) {
                    String name = property.getName();
                    if (!"preview".equals(name)) continue;
                    return Boolean.parseBoolean(property.getValue());
                }
            }
        }
        return false;
    }

    public static boolean isDynamicVdb(IFile file) {
        CoreArgCheck.isNotNull((Object)file, (String)"file is null");
        boolean result = false;
        if (file.exists() && file.getLocation().toFile().length() > 0L) {
            if (!XML_EXTENSION.equalsIgnoreCase(file.getFileExtension())) {
                return false;
            }
            VdbElement manifest = null;
            try {
                manifest = VdbUtil.getVdbManifest(file.getLocation().toFile());
            }
            catch (Exception exception) {
                result = false;
            }
            if (manifest != null) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isDdlVdb(IFile file) {
        CoreArgCheck.isNotNull((Object)file, (String)"file is null");
        boolean result = false;
        if (file.exists() && file.getLocation().toFile().length() > 0L) {
            if (!"vdb".equalsIgnoreCase(file.getFileExtension())) {
                return false;
            }
            VdbElement manifest = null;
            try {
                manifest = VdbUtil.getVdbManifest(file);
            }
            catch (Exception ex) {
                VdbPlugin.UTIL.log((Throwable)ex);
            }
            if (manifest != null && manifest != null) {
                for (ModelElement model : manifest.getModels()) {
                    List<MetadataElement> allMetadata = model.getMetadata();
                    if (allMetadata != null) {
                        for (MetadataElement metadata : allMetadata) {
                            if (!metadata.getType().equalsIgnoreCase("DDL-FILE")) continue;
                            result = true;
                            break;
                        }
                    }
                    if (result) break;
                }
            }
        }
        return result;
    }

    public static boolean hasModelClass(IFile file, String modelClass, String type) throws Exception {
        VdbElement manifest;
        if (file.exists() && "vdb".equals(file.getFileExtension()) && (manifest = VdbUtil.getVdbManifest(file)) != null) {
            for (ModelElement model : manifest.getModels()) {
                String typeValue = model.getType();
                if (!type.equalsIgnoreCase(typeValue)) continue;
                for (PropertyElement property : model.getProperties()) {
                    String modelClassValue;
                    String name = property.getName();
                    if (!"modelClass".equals(name) || !modelClass.equalsIgnoreCase(modelClassValue = property.getValue())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static VdbElement getVdbManifest(final IFile file) throws Exception {
        final VdbElement[] manifest = new VdbElement[1];
        if (!file.exists()) {
            return null;
        }
        if (ModelUtil.isVdbArchiveFile((IResource)file)) {
            try {
                OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
                    ZipFile archive = null;
                    InputStream entryStream = null;

                    public void doIfFails() {
                    }

                    public void finallyDo() throws Exception {
                        if (this.entryStream != null) {
                            this.entryStream.close();
                        }
                        if (this.archive != null) {
                            this.archive.close();
                        }
                    }

                    public void tryToDo() throws Exception {
                        this.archive = new ZipFile(file.getLocation().toString());
                        boolean foundManifest = false;
                        Enumeration<? extends ZipEntry> iter = this.archive.entries();
                        while (iter.hasMoreElements()) {
                            ZipEntry zipEntry = iter.nextElement();
                            this.entryStream = this.archive.getInputStream(zipEntry);
                            if (zipEntry.getName().equals("META-INF/vdb.xml")) {
                                foundManifest = true;
                                Unmarshaller unmarshaller = VdbUtil.getJaxbContext().createUnmarshaller();
                                unmarshaller.setSchema(VdbUtil.getManifestSchema());
                                manifest[0] = (VdbElement)unmarshaller.unmarshal(this.entryStream);
                            }
                            if (foundManifest) break;
                        }
                    }
                });
            }
            catch (Exception ex) {
                VdbPlugin.UTIL.log((Throwable)ex);
                return null;
            }
            return manifest[0];
        }
        if (file.getFileExtension() != null && file.getFileExtension().equalsIgnoreCase(XML_EXTENSION)) {
            try {
                OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
                    InputStream fileStream = null;

                    public void doIfFails() {
                    }

                    public void finallyDo() throws Exception {
                        if (this.fileStream != null) {
                            this.fileStream.close();
                        }
                    }

                    public void tryToDo() throws Exception {
                        this.fileStream = new FileInputStream(file.getLocation().toFile());
                        Unmarshaller unmarshaller = VdbUtil.getJaxbContext().createUnmarshaller();
                        unmarshaller.setSchema(VdbUtil.getManifestSchema());
                        manifest[0] = (VdbElement)unmarshaller.unmarshal(this.fileStream);
                    }
                });
            }
            catch (Exception ex) {
                VdbPlugin.UTIL.log((Throwable)ex);
                return null;
            }
            return manifest[0];
        }
        return null;
    }

    public static VdbElement getVdbManifest(final File dynamicVdbFile) throws Exception {
        final VdbElement[] manifest = new VdbElement[1];
        try {
            OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
                InputStream fileStream = null;

                public void doIfFails() {
                }

                public void finallyDo() throws Exception {
                    if (this.fileStream != null) {
                        this.fileStream.close();
                    }
                }

                public void tryToDo() throws Exception {
                    Unmarshaller unmarshaller = VdbUtil.getJaxbContext().createUnmarshaller();
                    unmarshaller.setSchema(VdbUtil.getManifestSchema());
                    FileInputStream fileStream = new FileInputStream(dynamicVdbFile);
                    manifest[0] = (VdbElement)unmarshaller.unmarshal((InputStream)fileStream);
                }
            });
        }
        catch (Exception ex) {
            if (!(ex.getCause() instanceof UnmarshalException)) {
                VdbPlugin.UTIL.log(4, (Throwable)ex, "Error finding VDB manifest for file: " + dynamicVdbFile.getName());
            }
            return null;
        }
        return manifest[0];
    }

    public static VdbElement getVdbManifest(final String xmlString) throws Exception {
        final VdbElement[] manifest = new VdbElement[1];
        try {
            OperationUtil.perform((OperationUtil.Unreliable)new OperationUtil.Unreliable(){
                InputStream fileStream = null;

                public void doIfFails() {
                }

                public void finallyDo() throws Exception {
                    if (this.fileStream != null) {
                        this.fileStream.close();
                    }
                }

                public void tryToDo() throws Exception {
                    Unmarshaller unmarshaller = VdbUtil.getJaxbContext().createUnmarshaller();
                    unmarshaller.setSchema(VdbUtil.getManifestSchema());
                    ByteArrayInputStream fileStream = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
                    manifest[0] = (VdbElement)unmarshaller.unmarshal((InputStream)fileStream);
                }
            });
        }
        catch (Exception ex) {
            VdbPlugin.UTIL.log((Throwable)ex);
            return null;
        }
        return manifest[0];
    }

    public static int getVdbVersion(IFile file) throws Exception {
        VdbElement manifest;
        if (file.exists() && (manifest = VdbUtil.getVdbManifest(file)) != null) {
            return manifest.getVersion();
        }
        return 0;
    }

    public static boolean isVdbTeiidVersion8orGreater(IFile file) {
        if (file == null || !file.exists()) {
            return false;
        }
        ValidationVersionCallback callback = new ValidationVersionCallback(file);
        VdbFileProcessor processor = new VdbFileProcessor(callback);
        processor.process();
        ITeiidServerVersion validationVersion = callback.getValidationVersion();
        if (callback.hasException() || validationVersion == null) {
            return false;
        }
        return validationVersion.isGreaterThanOrEqualTo(TeiidServerVersion.Version.TEIID_8_0.get());
    }

    public static String getUuid(ModelElement modelElement) {
        for (PropertyElement property : modelElement.getProperties()) {
            String name = property.getName();
            if (!"modelUuid".equals(name)) continue;
            return property.getValue();
        }
        return null;
    }

    public static String buildCommaDelimitedString(AllowedLanguages values) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int numVal = values.size();
        for (String val : values) {
            sb.append(val);
            if (++i >= numVal) continue;
            sb.append(",").append(" ");
        }
        return sb.toString();
    }

    static JAXBContext getJaxbContext() throws JAXBException {
        return JAXBContext.newInstance((Class[])new Class[]{VdbElement.class});
    }

    public static URL getVdbXsd() {
        return VdbElement.class.getResource("/vdb-deployer.xsd");
    }

    public static InputStream getVdbXsdStream() {
        return VdbElement.class.getResourceAsStream("/vdb-deployer.xsd");
    }

    public static Schema getManifestSchema() throws SAXException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(VdbUtil.getVdbXsd());
    }

    public static ModelType getModelType(String vdbModelType, String modelPath) {
        if (vdbModelType == OTHER && modelPath.toUpperCase().endsWith(".XSD")) {
            return ModelType.TYPE_LITERAL;
        }
        return ModelType.get((String)vdbModelType);
    }

    public static boolean modelInVdb(IFile theVdb, IFile theModelFile) throws Exception {
        VdbElement manifest;
        if (theVdb.exists() && (manifest = VdbUtil.getVdbManifest(theVdb)) != null) {
            for (ModelElement model : manifest.getModels()) {
                String modelName = String.valueOf(model.getName()) + ".xmi";
                if (!modelName.equalsIgnoreCase(theModelFile.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static void validateVdbVersion(IFile theVdbFile, Collection<IStatus> statuses) {
        TeiidServerVersion maxMmVersion;
        ITeiidServerVersion defaultTeiidVersion = ModelerCore.getTeiidServerVersion();
        ITeiidServerVersion maxDesignerVersion = TeiidServerVersion.Version.TEIID_DEFAULT.get();
        ValidationVersionCallback callback = new ValidationVersionCallback(theVdbFile);
        VdbFileProcessor processor = new VdbFileProcessor(callback);
        processor.process();
        ITeiidServerVersion validationVersion = callback.getValidationVersion();
        if (validationVersion == null) {
            statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_noValidationVersionInVdb", new Object[0])));
            return;
        }
        if (!validationVersion.compareTo(defaultTeiidVersion) && (validationVersion.isGreaterThan(defaultTeiidVersion) || validationVersion.isLessThan(defaultTeiidVersion))) {
            statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_differentValidationVersions", new Object[]{validationVersion, defaultTeiidVersion})));
        }
        if (validationVersion.isGreaterThan((ITeiidServerVersion)(maxMmVersion = new TeiidServerVersion(maxDesignerVersion.getMajor(), maxDesignerVersion.getMinor(), "x")))) {
            statuses.add((IStatus)new Status(4, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationError_validationVersionUnsupported", new Object[0])));
        }
    }

    public static MultiStatus validateVdbModelsInWorkspace(IFile theVdbFile) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        IProject theProject = theVdbFile.getProject();
        MultiStatus finalStatus = new MultiStatus(VdbConstants.PLUGIN_ID, 0, VdbPlugin.UTIL.getString("vdbValidationOK", new Object[0]), null);
        if (theVdbFile.exists()) {
            VdbUtil.validateVdbVersion(theVdbFile, statuses);
            XmiVdb theVdb = null;
            VdbElement manifest = null;
            try {
                theVdb = new XmiVdb(theVdbFile);
                manifest = VdbUtil.getVdbManifest(theVdbFile);
            }
            catch (Exception ex) {
                statuses.add((IStatus)new Status(4, VdbConstants.PLUGIN_ID, ex.getLocalizedMessage(), (Throwable)ex));
            }
            if (theVdb != null && manifest != null) {
                String modelName;
                String securityDomain = theVdb.getSecurityDomain();
                if (securityDomain != null) {
                    String gssPattern = theVdb.getGssPattern();
                    String passwordPattern = theVdb.getPasswordPattern();
                    String authenticationType = theVdb.getAuthenticationType();
                    if (authenticationType != null && (gssPattern != null || passwordPattern != null)) {
                        statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_singleAuthenticationType_0_willBeIgnored", (Object)authenticationType)));
                    }
                }
                block2: for (ModelElement model : manifest.getModels()) {
                    modelName = model.getName();
                    for (ProblemElement problem : model.getProblems()) {
                        if (problem.getSeverity() != Severity.ERROR) continue;
                        statuses.add((IStatus)new Status(4, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationError_modelContainsErrors", (Object)modelName)));
                        break;
                    }
                    IFile resource = null;
                    String modelUuid = VdbUtil.getUuid(model);
                    if (modelUuid == null) {
                        Collection resources = WorkspaceResourceFinderUtil.findIResourceInProjectByName((String)modelName, (IProject)theProject);
                        if (resources.size() == 1) {
                            resource = (IResource)resources.iterator().next();
                        }
                        if (resource != null) {
                            statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_modelUuidMissing", (Object)modelName)));
                        }
                    } else {
                        Collection resources;
                        resource = WorkspaceResourceFinderUtil.findIResourceByUUID((String)modelUuid);
                        if (resource == null && (resources = WorkspaceResourceFinderUtil.findIResourceInProjectByName((String)modelName, (IProject)theProject)).size() == 1) {
                            resource = (IResource)resources.iterator().next();
                        }
                    }
                    boolean nameChanged = false;
                    if (resource == null) {
                        statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_noModelInWorkspace", (Object)modelName)));
                    } else {
                        String resourceName = FileUtils.getNameWithoutExtension((IResource)resource);
                        if (!modelName.equals(resourceName)) {
                            nameChanged = true;
                        }
                        String path = model.getPath();
                        Path iPath = new Path(path);
                        IResource expectedResourceAtPath = ModelerCore.getWorkspace().getRoot().findMember((IPath)iPath);
                        if (expectedResourceAtPath == null || nameChanged) {
                            statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_modelExistsWithDifferentLocationOrName", new Object[]{modelName, resource.getFullPath()})));
                        } else if (!VdbUtil.isSynchronized(theVdb, (IFile)expectedResourceAtPath)) {
                            statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_modelNotSynchronized", (Object)modelName)));
                        }
                    }
                    if (model.getSources() != null && model.getSources().size() > 1) {
                        boolean multiSourceIsFalse = true;
                        for (PropertyElement prop : model.getProperties()) {
                            if (!prop.getName().equals("supports-multi-source-bindings") || !Boolean.parseBoolean(prop.getValue())) continue;
                            multiSourceIsFalse = false;
                            break;
                        }
                        if (multiSourceIsFalse) {
                            statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_singleSourceModelHasMultipleSources", (Object)modelName)));
                        }
                    }
                    if (model.getSources() == null) continue;
                    for (SourceElement elem : model.getSources()) {
                        if (!StringUtilities.isEmpty((String)elem.getTranslatorName())) continue;
                        statuses.add((IStatus)new Status(4, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_sourceMissingTranslatorType", new Object[]{modelName, theVdb.getName()})));
                        break;
                    }
                    for (SourceElement elem : model.getSources()) {
                        if (!StringUtilities.isEmpty((String)elem.getJndiName())) continue;
                        statuses.add((IStatus)new Status(2, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationWarning_sourceMissingJndiName", new Object[]{modelName, theVdb.getName()})));
                        continue block2;
                    }
                }
                HashMap<String, String> fileFileNames = new HashMap<String, String>();
                HashSet<String> modelNamesWithMultiple = new HashSet<String>();
                for (ModelElement model : manifest.getModels()) {
                    String modelName2 = model.getName();
                    if (fileFileNames.get(modelName2.toUpperCase()) != null) {
                        modelNamesWithMultiple.add(modelName2);
                        continue;
                    }
                    fileFileNames.put(modelName2.toUpperCase(), modelName2);
                }
                Iterator<ModelElement> iterator = modelNamesWithMultiple.iterator();
                if (iterator.hasNext()) {
                    modelName = (String)((Object)iterator.next());
                    statuses.add((IStatus)new Status(4, VdbConstants.PLUGIN_ID, VdbPlugin.UTIL.getString("vdbValidationError_duplicateModelNames", new Object[]{modelName, theVdb.getName()})));
                }
            }
        } else {
            statuses.add((IStatus)new Status(4, VdbConstants.PLUGIN_ID, "ERROR : VDB " + theVdbFile.getName() + " does not exist"));
        }
        if (!statuses.isEmpty()) {
            IStatus[] result = new IStatus[statuses.size()];
            statuses.toArray(result);
            finalStatus = new MultiStatus(VdbConstants.PLUGIN_ID, 0, result, "ERROR : VDB " + theVdbFile.getName() + " has problems", null);
        }
        return finalStatus;
    }

    public static boolean modelAlreadyExistsInVdb(String modelName, IPath pathIncludingModel, Vdb vdb) {
        HashMap<String, String> existingNames = new HashMap<String, String>();
        HashSet<String> existingPaths = new HashSet<String>();
        for (VdbEntry vdbEntry : vdb.getModelEntries()) {
            String existingName = vdbEntry.getPath().removeFileExtension().lastSegment();
            IPath path = vdbEntry.getPath();
            existingNames.put(existingName.toUpperCase(), existingName);
            existingPaths.add(path.toString().toUpperCase());
        }
        return existingNames.get(modelName.toUpperCase()) != null && !existingPaths.contains(pathIncludingModel.toString().toUpperCase());
    }

    public static boolean canAddModelToVdb(IFile model, Vdb theVdb) throws Exception {
        Resource[] refs;
        String string;
        ModelResource mr = ModelUtil.getModel((Object)model);
        HashMap<String, String> existingNames = new HashMap<String, String>();
        HashSet<String> existingPaths = new HashSet<String>();
        if (theVdb != null) {
            for (VdbEntry vdbEntry : theVdb.getModelEntries()) {
                String existingName = vdbEntry.getPath().removeFileExtension().lastSegment();
                IPath path = vdbEntry.getPath();
                existingNames.put(existingName.toUpperCase(), existingName);
                existingPaths.add(path.toString().toUpperCase());
            }
        }
        if (existingNames.get((string = FileUtils.getNameWithoutExtension((IResource)model)).toUpperCase()) != null && !existingPaths.contains(model.getFullPath().toString().toUpperCase())) {
            return false;
        }
        existingNames.put(string.toUpperCase(), string);
        ResourceFinder finder = null;
        finder = ModelerCore.getModelContainer().getResourceFinder();
        Resource[] resourceArray = refs = finder.findReferencesFrom(mr.getEmfResource(), true, false);
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            Resource res = resourceArray[n2];
            if (!ModelUtil.isXsdFile((Resource)res)) {
                ModelResource modelRes = ModelUtil.getModel((Object)res);
                String refModelName = modelRes.getCorrespondingResource().getFullPath().removeFileExtension().lastSegment();
                IPath refModelPath = modelRes.getCorrespondingResource().getFullPath();
                if (existingNames.get(refModelName.toUpperCase()) != null && !existingPaths.contains(refModelPath.toString().toUpperCase())) {
                    return false;
                }
                existingNames.put(refModelName.toUpperCase(), refModelName);
            }
            ++n2;
        }
        return true;
    }

    public static boolean isSynchronized(Vdb theVdb, IFile theModelFile) {
        long fileCheckSum = 0L;
        boolean foundCheckSum = false;
        try {
            fileCheckSum = VdbUtil.getCheckSum(theModelFile);
            foundCheckSum = true;
        }
        catch (Exception exception) {
            foundCheckSum = false;
        }
        if (foundCheckSum) {
            for (VdbEntry vdbEntry : theVdb.getModelEntries()) {
                if (!vdbEntry.getPath().lastSegment().equalsIgnoreCase(theModelFile.getName())) continue;
                return vdbEntry.getChecksum() == fileCheckSum;
            }
        }
        return false;
    }

    public static long getCheckSum(IFile f) throws Exception {
        long l;
        block7: {
            CoreArgCheck.isNotNull((Object)f);
            InputStream is = null;
            try {
                is = f.getContents();
                l = ChecksumUtil.computeChecksum((InputStream)is).getValue();
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return l;
    }

    public static Collection<IFile> getModelsWithWrongPaths(IFile theVdb) throws Exception {
        ArrayList<IFile> misMatchedResources = new ArrayList<IFile>();
        if (theVdb.exists()) {
            IProject theProject = theVdb.getProject();
            VdbElement manifest = VdbUtil.getVdbManifest(theVdb);
            if (manifest != null) {
                for (ModelElement model : manifest.getModels()) {
                    String modelName = String.valueOf(model.getName()) + ".xmi";
                    Collection resources = WorkspaceResourceFinderUtil.findIResourceInProjectByName((String)modelName, (IProject)theProject);
                    if (resources.size() != 1) continue;
                    String path = model.getPath();
                    IResource matchingResource = (IResource)resources.iterator().next();
                    Path iPath = new Path(path);
                    IResource resource = ModelerCore.getWorkspace().getRoot().findMember((IPath)iPath);
                    if (resource != null) continue;
                    misMatchedResources.add((IFile)matchingResource);
                }
            }
        }
        return misMatchedResources;
    }

    public static Collection<String> getModelImports(ModelElement modelElement) {
        ArrayList<String> imports = new ArrayList<String>();
        for (PropertyElement element : modelElement.getProperties()) {
            if (!element.getName().equalsIgnoreCase("imports")) continue;
            imports.add(element.getValue());
        }
        return imports;
    }

    private static VdbModelEntry getVdbModelEntry(ModelElement element, Vdb actualVDB) {
        for (VdbEntry vdbEntry : actualVDB.getModelEntries()) {
            if (!vdbEntry.getPath().removeFileExtension().lastSegment().equalsIgnoreCase(element.getName())) continue;
            return (VdbModelEntry)vdbEntry;
        }
        return null;
    }

    private static IPath getProjectRelativeModelPath(String modelPathInVdb, IProject targetProject) {
        Path vdbModelPath = new Path(modelPathInVdb);
        Path targetPath = new Path("");
        int iSegs = vdbModelPath.segmentCount();
        if (iSegs > 1) {
            int i = 1;
            while (i < iSegs) {
                targetPath = targetPath.append(vdbModelPath.segment(i));
                ++i;
            }
        }
        return targetPath;
    }

    private static boolean extractFileFromVdbToSameProject(IFile zipFile, String zipEntryFullPath, IPath projectRelativeTargetFolder) throws Exception {
        ZipInputStream zin = null;
        boolean result = false;
        try {
            String zipFilePath = ModelUtil.getLocation((IResource)zipFile).toOSString();
            String projectFilePath = ModelUtil.getLocation((IResource)ModelerCore.getWorkspace().getRoot()) + zipFile.getProject().getFullPath().toOSString();
            FileInputStream fin = new FileInputStream(zipFilePath);
            BufferedInputStream bin = new BufferedInputStream(fin);
            zin = new ZipInputStream(bin);
            ZipEntry ze = null;
            while ((ze = zin.getNextEntry()) != null) {
                int len;
                String entryName = String.valueOf('/') + ze.getName();
                if (!entryName.equals(zipEntryFullPath)) continue;
                String finalModelPath = String.valueOf(projectFilePath) + '/' + projectRelativeTargetFolder;
                File entryFile = new File(finalModelPath);
                if (!entryFile.getParentFile().exists()) {
                    entryFile.getParentFile().mkdir();
                }
                FileOutputStream outstream = new FileOutputStream(finalModelPath);
                byte[] buffer = new byte[8192];
                while ((len = zin.read(buffer)) != -1) {
                    outstream.write(buffer, 0, len);
                }
                outstream.close();
                zin.closeEntry();
                result = true;
                break;
            }
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        zipFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        return result;
    }

    public static boolean synchronizeWorkspace(IFile theVdb) throws Exception {
        IPath targetPath;
        IFile resource;
        boolean result = false;
        if (!theVdb.exists()) {
            return result;
        }
        IProject theProject = theVdb.getProject();
        VdbElement manifest = VdbUtil.getVdbManifest(theVdb);
        if (manifest == null) {
            return result;
        }
        for (ModelElement model : manifest.getModels()) {
            String modelUuid = VdbUtil.getUuid(model);
            resource = null;
            if (modelUuid != null) {
                resource = WorkspaceResourceFinderUtil.findIResourceByUUID((String)modelUuid);
            } else {
                Collection resources = WorkspaceResourceFinderUtil.findIResourceInProjectByName((String)(String.valueOf(model.getName()) + ".xmi"), (IProject)theProject);
                if (resources.size() == 1) {
                    resource = (IResource)resources.iterator().next();
                }
            }
            if (resource != null) continue;
            targetPath = VdbUtil.getProjectRelativeModelPath(model.getPath(), theVdb.getProject());
            VdbUtil.extractFileFromVdbToSameProject(theVdb, model.getPath(), targetPath);
            result = true;
        }
        for (EntryElement nextRes : manifest.getEntries()) {
            Path path = new Path(nextRes.getPath());
            resource = WorkspaceResourceFinderUtil.findIResourceByPath((IPath)path);
            if (resource != null) continue;
            targetPath = VdbUtil.getProjectRelativeModelPath(nextRes.getPath(), theVdb.getProject());
            VdbUtil.extractFileFromVdbToSameProject(theVdb, nextRes.getPath(), targetPath);
            result = true;
        }
        return result;
    }

    public static void synchronizeVdb(IFile theVdb, boolean extractMissingModels, boolean updateValidationVersion) throws Exception {
        IResource matchingResource;
        if (!theVdb.exists()) {
            return;
        }
        IProject theProject = theVdb.getProject();
        VdbElement manifest = VdbUtil.getVdbManifest(theVdb);
        if (manifest == null) {
            return;
        }
        if (extractMissingModels) {
            VdbUtil.synchronizeWorkspace(theVdb);
        }
        XmiVdb actualVDB = new XmiVdb(theVdb, true);
        HashSet<ModelElement> modelsToReplace = new HashSet<ModelElement>();
        ArrayList<IFile> matchingResources = new ArrayList<IFile>();
        HashSet<ModelElement> modelsNotInWorkspace = new HashSet<ModelElement>();
        HashMap<String, IFile> oldModelPathToResourceMap = new HashMap<String, IFile>();
        HashSet<String> dependentViewModelPaths = new HashSet<String>();
        for (ModelElement model : manifest.getModels()) {
            Collection<String> modelImports = VdbUtil.getModelImports(model);
            block1: for (String importedModelPath : modelImports) {
                for (ModelElement model_2 : manifest.getModels()) {
                    if (!model_2.getPath().equals(importedModelPath)) continue;
                    dependentViewModelPaths.add(model.getPath());
                    continue block1;
                }
            }
        }
        block3: for (ModelElement model : manifest.getModels()) {
            String modelName = model.getName();
            String modelUuid = VdbUtil.getUuid(model);
            IFile resource = null;
            boolean addTheUuid = modelUuid == null;
            boolean nameWasChanged = false;
            if (!addTheUuid) {
                resource = WorkspaceResourceFinderUtil.findIResourceByUUID((String)modelUuid);
                if (resource != null) {
                    nameWasChanged = !resource.getFullPath().removeFileExtension().lastSegment().equalsIgnoreCase(modelName);
                }
            } else {
                Path modelPath = new Path(model.getPath());
                Collection resources = WorkspaceResourceFinderUtil.findIResourceInProjectByName((String)(String.valueOf(model.getName()) + CoreStringUtil.Constants.DOT + modelPath.getFileExtension()), (IProject)theProject);
                if (resources.size() == 1) {
                    resource = (IResource)resources.iterator().next();
                }
            }
            if (resource != null) {
                String path = model.getPath();
                Path iPath = new Path(path);
                IResource expectedResourceAtPath = ModelerCore.getWorkspace().getRoot().findMember((IPath)iPath);
                boolean fixThePath = expectedResourceAtPath == null;
                oldModelPathToResourceMap.put(model.getPath(), resource);
                if (!fixThePath && !nameWasChanged && !addTheUuid) continue;
                for (VdbEntry vdbEntry : actualVDB.getModelEntries()) {
                    if (!vdbEntry.getPath().removeFileExtension().lastSegment().equalsIgnoreCase(modelName)) continue;
                    modelsToReplace.add(model);
                    matchingResources.add(resource);
                    continue block3;
                }
                continue;
            }
            modelsNotInWorkspace.add(model);
        }
        if (!modelsNotInWorkspace.isEmpty()) {
            for (ModelElement missingModel : modelsNotInWorkspace) {
                if (!dependentViewModelPaths.contains(missingModel.getPath())) continue;
                return;
            }
        }
        ArrayList<String> modelPathsToReplace = new ArrayList<String>();
        for (ModelElement element : modelsToReplace) {
            VdbModelEntry modelEntry = VdbUtil.getVdbModelEntry(element, actualVDB);
            if (modelEntry == null) continue;
            modelPathsToReplace.add(element.getPath());
            actualVDB.removeEntry(modelEntry);
        }
        for (String thePath : modelPathsToReplace) {
            matchingResource = (IResource)oldModelPathToResourceMap.get(thePath);
            if (matchingResource == null) continue;
            actualVDB.addEntry(matchingResource.getFullPath());
        }
        for (String thePath : dependentViewModelPaths) {
            matchingResource = (IResource)oldModelPathToResourceMap.get(thePath);
            if (matchingResource == null) continue;
            actualVDB.addEntry(matchingResource.getFullPath());
        }
        actualVDB.synchronize();
        if (updateValidationVersion) {
            actualVDB.setValidationDateTime(new Date());
            actualVDB.setValidationVersion(ModelerCore.getTeiidServerVersion().toString());
        }
        actualVDB.save();
        theVdb.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Set<String> getDataRoleNames(Vdb theVdb, String targetName) {
        HashSet<String> names = new HashSet<String>();
        Collection<DataRole> entries = theVdb.getDataRoles();
        for (DataRole role : entries) {
            names.add(role.getName());
        }
        if (targetName != null && !targetName.isEmpty()) {
            names.remove(targetName);
        }
        return names;
    }
}

