/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.vdb.VdbConstants;

public class VdbPlugin
extends Plugin
implements VdbConstants {
    private static final String I18N_NAME = String.valueOf(PLUGIN_ID) + ".i18n";
    public static final PluginUtil UTIL = new PluginUtilImpl(PLUGIN_ID, I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    private static VdbPlugin singleton;

    public static VdbPlugin singleton() {
        return singleton;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        singleton = this;
        ((PluginUtilImpl)UTIL).initializePlatformLogger((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        singleton = null;
        super.stop(context);
    }

    public IEclipsePreferences getPreferences() {
        return this.getPreferences(PLUGIN_ID);
    }

    public IEclipsePreferences getPreferences(String pluginId) {
        return InstanceScope.INSTANCE.getNode(pluginId);
    }

    public boolean conversionInProgress() {
        return this.getPreferences().getBoolean("conversion-in-progress", Boolean.FALSE.booleanValue());
    }

    public void setConversionInProgress(boolean value) throws Exception {
        try {
            IWorkspace workspace = ModelerCore.getWorkspace();
            if (workspace == null) {
                return;
            }
            IWorkspaceDescription description = workspace.getDescription();
            if (description == null) {
                return;
            }
            description.setAutoBuilding(!value);
            workspace.setDescription(description);
        }
        finally {
            this.getPreferences().putBoolean("conversion-in-progress", value);
        }
    }
}

