/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.ResourceFinder;
import org.teiid.designer.core.index.Index;
import org.teiid.designer.core.index.IndexUtil;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.XmiVdb;
import org.teiid.designer.vdb.manifest.EntryElement;
import org.teiid.designer.vdb.manifest.ProblemElement;
import org.teiid.designer.vdb.manifest.PropertyElement;
import org.teiid.designer.vdb.manifest.Severity;

public abstract class VdbIndexedEntry
extends VdbEntry {
    protected static final String INDEX_FOLDER = "runtime-inf/";
    private final String indexName;
    private final Set<Problem> problems = new HashSet<Problem>();

    public VdbIndexedEntry(XmiVdb vdb, EntryElement element) throws Exception {
        super((Vdb)vdb, element);
        String indexName = null;
        for (PropertyElement property : element.getProperties()) {
            String name = property.getName();
            if (!"indexName".equals(name)) continue;
            indexName = property.getValue();
        }
        this.indexName = indexName;
    }

    public VdbIndexedEntry(XmiVdb vdb, IPath name) throws Exception {
        super((Vdb)vdb, name);
        this.indexName = IndexUtil.getRuntimeIndexFileName((IResource)this.findFileInWorkspace());
    }

    @Override
    public XmiVdb getVdb() {
        return (XmiVdb)super.getVdb();
    }

    @Override
    public void setVdb(Vdb vdb) {
        if (vdb instanceof XmiVdb) {
            super.setVdb(vdb);
            return;
        }
        throw new UnsupportedOperationException();
    }

    protected void clean() {
        this.problems.clear();
        this.getIndexFile().delete();
    }

    protected ResourceFinder getFinder() throws Exception {
        return ModelerCore.getModelContainer().getResourceFinder();
    }

    protected Resource findModel() throws Exception {
        IResource resource = ModelerCore.getWorkspace().getRoot().findMember(this.getPath());
        if (resource == null) {
            return null;
        }
        Resource emfResource = this.getFinder().findByURI(URI.createFileURI((String)resource.getLocation().toString()), false);
        if (emfResource == null) {
            emfResource = ModelerCore.getModelContainer().getResource(URI.createFileURI((String)resource.getLocation().toString()), true);
        }
        return emfResource;
    }

    protected File getIndexFile() {
        return new File(this.getVdb().getStagingFolder(), INDEX_FOLDER + this.indexName);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public final Set<Problem> getProblems() {
        return Collections.unmodifiableSet(this.problems);
    }

    protected void addProblem(Problem problem) {
        this.problems.add(problem);
    }

    protected void synchronizeIndex() throws Exception {
        IFile workspaceFile = this.findFileInWorkspace();
        if (workspaceFile == null) {
            return;
        }
        this.problems.clear();
        this.getIndexFile().delete();
        Path indexPath = new Path(String.valueOf(IndexUtil.INDEX_PATH) + this.indexName);
        File indexFile = indexPath.toFile();
        long indexDate = -1L;
        if (indexFile.exists()) {
            indexDate = indexFile.lastModified();
        }
        if (workspaceFile.getLocalTimeStamp() > indexDate) {
            this.getVdb().getBuilder().buildResources((IProgressMonitor)new NullProgressMonitor(), Collections.singleton(workspaceFile), ModelerCore.getModelContainer(), false);
        }
        Index index = IndexUtil.getIndexFile((String)this.indexName, (String)(String.valueOf(IndexUtil.INDEX_PATH) + this.indexName), (String)this.getPath().lastSegment());
        FileUtils.copy((File)index.getIndexFile(), (File)this.getIndexFile().getParentFile(), (boolean)true);
        this.problems.clear();
        IMarker[] markers = workspaceFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        if (markers != null) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                int severity;
                IMarker marker = iMarkerArray[n2];
                Object attr = marker.getAttribute("severity");
                if (attr != null && ((severity = ((Integer)attr).intValue()) == 2 || severity == 1)) {
                    this.problems.add(new Problem(marker));
                }
                ++n2;
            }
        }
    }

    @Override
    public void save(ZipOutputStream out) throws Exception {
        IFile vdbFile;
        super.save(out);
        this.save(out, new ZipEntry(INDEX_FOLDER + this.getIndexName()), this.getIndexFile());
        if (!this.getVdb().isPreview() && (vdbFile = this.getVdb().getSourceFile()).exists()) {
            for (Problem problem : this.getProblems()) {
                IMarker marker = vdbFile.createMarker("org.eclipse.core.resources.problemmarker");
                marker.setAttribute("severity", problem.getSeverity());
                marker.setAttribute("message", (Object)problem.getMessage());
                marker.setAttribute("location", (Object)(String.valueOf(this.getPath().toString()) + '/' + problem.getLocation()));
            }
        }
    }

    public class Problem {
        private final int severity;
        private final String message;
        private final String location;

        Problem(IMarker marker) {
            this.severity = marker.getAttribute("severity", 1);
            this.message = marker.getAttribute("message", null);
            this.location = marker.getAttribute("location", null);
        }

        Problem(ProblemElement problem) {
            this.severity = problem.getSeverity() == Severity.ERROR ? 2 : 1;
            this.message = problem.getMessage();
            this.location = problem.getLocation();
        }

        public String getLocation() {
            return this.location;
        }

        public String getMessage() {
            return this.message;
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

