/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.VdbHelper;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.VdbEntry;
import org.teiid.designer.vdb.VdbPlugin;
import org.teiid.designer.vdb.manifest.EntryElement;

@ThreadSafe
public final class VdbFileEntry
extends VdbEntry {
    private IPath sourceFilePath;
    private FileEntryType fileType;

    public VdbFileEntry(Vdb vdb, IPath sourcePath, FileEntryType entryType) throws Exception {
        super(vdb, sourcePath);
        this.sourceFilePath = sourcePath;
        this.fileType = entryType;
        this.resetPath();
    }

    public VdbFileEntry(Vdb vdb, EntryElement element) throws Exception {
        super(vdb, Path.fromPortableString((String)element.getPath()));
        this.sourceFilePath = Path.fromPortableString((String)element.getPath());
        this.fileType = element.getPath().startsWith("/" + VdbHelper.VdbFolders.UDF.getReadFolder()) ? FileEntryType.UDFJar : FileEntryType.UserFile;
        this.resetPath();
    }

    private void resetPath() throws Exception {
        if (this.sourceFilePath == null) {
            return;
        }
        String fileName = this.sourceFilePath.lastSegment();
        Path newPath = this.fileType == FileEntryType.UDFJar ? new Path("/" + VdbHelper.VdbFolders.UDF.getWriteFolder() + "/" + fileName) : new Path("/" + VdbHelper.VdbFolders.OTHER_FILES.getWriteFolder() + "/" + fileName);
        this.setPath((IPath)newPath);
        this.setSynchronization(VdbEntry.Synchronization.NotSynchronized);
        this.synchronize();
    }

    public IPath getSourceFilePath() {
        return this.sourceFilePath;
    }

    @Override
    protected VdbEntry.Synchronization synchronizeEntry() throws Exception {
        if (this.sourceFilePath == null) {
            return VdbEntry.Synchronization.NotApplicable;
        }
        return super.synchronizeEntry();
    }

    @Override
    public IFile findFileInWorkspace() {
        IResource resource = ModelerCore.getWorkspace().getRoot().findMember(this.getSourceFilePath());
        if (resource == null && this.getVdb() != null && this.getVdb().getSourceFile() != null && this.getVdb().getSourceFile().getProject() != null) {
            Collection files;
            IProject vdbProject = this.getVdb().getSourceFile().getProject();
            resource = vdbProject.findMember(this.getPath());
            if (resource == null) {
                resource = vdbProject.findMember(this.getSourceFilePath());
            }
            if (resource == null && !(files = WorkspaceResourceFinderUtil.findIResourceInProjectByName((String)this.getPathName(), (IProject)vdbProject)).isEmpty()) {
                resource = (IResource)files.iterator().next();
            }
        }
        if (!(resource instanceof IFile)) {
            this.setSynchronization(VdbEntry.Synchronization.NotApplicable);
            return null;
        }
        this.sourceFilePath = resource.getFullPath();
        return (IFile)resource;
    }

    @Override
    public void save(ZipOutputStream out) throws Exception {
        String zipName = this.getPath().toOSString();
        if ((zipName = zipName.replace("\\", "/")).startsWith("/")) {
            zipName = zipName.substring(1, zipName.length());
        }
        ZipEntry zipEntry = new ZipEntry(zipName);
        zipEntry.setComment(this.getDescription());
        File theFile = this.findSourceFile();
        this.save(out, zipEntry, theFile);
    }

    public FileEntryType getFileType() {
        return this.fileType;
    }

    private File findSourceFile() throws Exception {
        File sourceFile;
        IProject vdbProject = this.getVdb().getSourceFile().getProject();
        if (vdbProject != null) {
            IFile projectFile = vdbProject.getFile(this.getPath());
            if (projectFile.exists()) {
                return projectFile.getLocation().toFile();
            }
            IPath sourceFilePath = this.getSourceFilePath();
            if (this.getSourceFilePath().isAbsolute()) {
                sourceFilePath = this.getSourceFilePath().makeRelativeTo(vdbProject.getFullPath());
            }
            if ((projectFile = vdbProject.getFile(sourceFilePath)).exists()) {
                return projectFile.getLocation().toFile();
            }
        }
        if ((sourceFile = this.sourceFilePath.toFile()).exists()) {
            return sourceFile;
        }
        sourceFile = new File(this.getVdb().getStagingFolder(), this.getPath().toOSString());
        if (sourceFile.exists()) {
            return sourceFile;
        }
        throw new FileNotFoundException("Cannot save vdb file entry '" + this.sourceFilePath + "' to vdb file");
    }

    @Override
    public VdbFileEntry clone() {
        try {
            VdbFileEntry clone = new VdbFileEntry(this.getVdb(), this.sourceFilePath, this.fileType);
            this.cloneVdbObject(clone);
            return clone;
        }
        catch (Exception ex) {
            VdbPlugin.UTIL.log((Throwable)ex);
            return null;
        }
    }

    public static enum FileEntryType {
        UserFile,
        UDFJar;

    }
}

