/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xml.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.xml.ui.ModelerXmlUiConstants;

public class XmlViewModelSelectionValidator
implements ISelectionStatusValidator,
ModelerXmlUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(XmlViewModelSelectionValidator.class);
    private StatusInfo stStatus;
    private static final String WRONG_CLASS_ERROR_MSG = XmlViewModelSelectionValidator.getString("wrongClassErrorMessage.text");
    private static final String CONTAINER_READONLY_ERROR_MSG = XmlViewModelSelectionValidator.getString("containerReadOnlyErrorMessage.text");
    private static final String CONTAINER_MODEL_READONLY_ERROR_MSG = XmlViewModelSelectionValidator.getString("containerModelReadOnlyErrorMessage.text");
    private static final String NOTHING_SELECTED = XmlViewModelSelectionValidator.getString("wrongClassErrorMessage.text");

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public IStatus validate(Object[] selection) {
        if (selection == null || selection.length == 0) {
            return new StatusInfo("org.teiid.designer.xml.ui", 4, NOTHING_SELECTED);
        }
        boolean bAllAreValid = true;
        int i = 0;
        while (i < selection.length) {
            if (!this.isValidModelResource(selection[i]) && !this.isContainer(selection[i])) {
                bAllAreValid = false;
                this.stStatus = new StatusInfo("org.teiid.designer.xml.ui", 4, WRONG_CLASS_ERROR_MSG);
                break;
            }
            ++i;
        }
        if (bAllAreValid) {
            i = 0;
            while (i < selection.length) {
                if (!this.containerIsModifiable(selection[i])) {
                    Object theSelection = selection[i];
                    String msg = CONTAINER_READONLY_ERROR_MSG;
                    if (theSelection instanceof ModelResource) {
                        msg = CONTAINER_MODEL_READONLY_ERROR_MSG;
                    } else if (theSelection instanceof IFile) {
                        msg = CONTAINER_MODEL_READONLY_ERROR_MSG;
                    }
                    bAllAreValid = false;
                    this.stStatus = new StatusInfo("org.teiid.designer.xml.ui", 4, msg);
                    break;
                }
                ++i;
            }
        }
        if (bAllAreValid) {
            this.stStatus = new StatusInfo("org.teiid.designer.xml.ui", 0, "");
        }
        return this.stStatus;
    }

    private boolean isValidModelResource(Object oSelection) {
        boolean bResult = false;
        if (oSelection instanceof IResource) {
            try {
                MetamodelDescriptor descriptor;
                ModelResource mr;
                IResource resource = (IResource)oSelection;
                if (ModelUtilities.isModelFile((IResource)resource) && (mr = ModelUtil.getModelResource((IFile)((IFile)resource), (boolean)true)) != null && ModelUtilities.isVirtual((ModelResource)mr) && (descriptor = mr.getPrimaryMetamodelDescriptor()) != null && descriptor.getNamespaceURI().equals("http://www.metamatrix.com/metamodels/XmlDocument")) {
                    bResult = true;
                }
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        }
        return bResult;
    }

    private boolean isContainer(Object oSelection) {
        return oSelection instanceof IContainer;
    }

    private boolean containerIsModifiable(Object oSelection) {
        boolean bResult = false;
        ModelResource mr = null;
        if (this.isValidModelResource(oSelection)) {
            try {
                mr = ModelUtil.getModelResource((IFile)((IFile)oSelection), (boolean)true);
            }
            catch (ModelWorkspaceException mwe) {
                ModelerCore.Util.log(4, (Throwable)mwe, mwe.getMessage());
            }
        } else if (this.isContainer(oSelection)) {
            return !ModelUtil.isIResourceReadOnly((IResource)((IContainer)oSelection));
        }
        bResult = !ModelUtilities.isReadOnly((ModelResource)mr);
        return bResult;
    }
}

