/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.part;

import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.swt.graphics.Color;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramNodeSelectionEditPolicy;
import org.teiid.designer.mapping.ui.figure.SummaryExtentFigure;
import org.teiid.designer.mapping.ui.model.SummaryExtentNode;
import org.teiid.designer.mapping.ui.part.MappingExtentEditPart;
import org.teiid.designer.metamodels.transformation.StagingTable;

public class SummaryExtentEditPart
extends MappingExtentEditPart {
    private static int nExtents = 0;
    private DragTracker myDragTracker = null;

    public SummaryExtentEditPart() {
    }

    public SummaryExtentEditPart(String diagramTypeId) {
        this.setDiagramTypeId(diagramTypeId);
        this.init();
        ++nExtents;
    }

    @Override
    public void init() {
        if (this.getAnchorManager() == null) {
            this.setAnchorManager(this.getEditPartFactory().getAnchorManager((DiagramEditPart)this));
        }
    }

    @Override
    protected IFigure createFigure() {
        boolean isRequired;
        Point location = new Point(100, 100);
        SummaryExtentFigure extentFigure = (SummaryExtentFigure)this.getFigureFactory().createFigure(this.getModel());
        extentFigure.setLocation(location);
        List toolTips = ((SummaryExtentNode)this.getModel()).getToolTipStrings();
        if (toolTips != null && !toolTips.isEmpty()) {
            extentFigure.setToolTip(extentFigure.createToolTip(toolTips));
        }
        if (isRequired = ((SummaryExtentNode)this.getModel()).getExtent().isMappingRequired()) {
            extentFigure.setOutlineColor(ColorConstants.red);
            extentFigure.setOutlineWidth(3);
        }
        return extentFigure;
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new DiagramNodeSelectionEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", null);
    }

    @Override
    protected List getModelChildren() {
        List children = ((DiagramModelNode)this.getModel()).getChildren();
        return children;
    }

    @Override
    protected void refreshVisuals() {
        Point loc = ((DiagramModelNode)this.getModel()).getPosition();
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        this.getFigure().repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("size")) {
            ((SummaryExtentFigure)this.getFigure()).updateForSize(((DiagramModelNode)this.getModel()).getSize());
            this.createOrUpdateAnchorsLocations(true);
            this.refreshVisuals();
        } else if (prop.equals("connection")) {
            this.refresh();
            this.createOrUpdateAnchorsLocations(true);
        } else if (prop.equals("location")) {
            this.createOrUpdateAnchorsLocations(true);
            this.refreshVisuals();
        }
    }

    @Override
    public void resizeChildren() {
        this.getDiagramFigure().updateForSize(((DiagramModelNode)this.getModel()).getSize());
    }

    @Override
    public void hiliteBackground(Color hiliteColor) {
        if (this.hasConnections()) {
            this.getDiagramFigure().hiliteBackground(hiliteColor);
        } else {
            SummaryExtentNode nextNode = (SummaryExtentNode)this.getModel();
            if (!(nextNode.getModelObject() instanceof StagingTable)) {
                this.getDiagramFigure().hiliteBackground(null);
            } else {
                this.getDiagramFigure().hiliteBackground(hiliteColor);
            }
        }
    }

    private boolean hasConnections() {
        SummaryExtentNode nextNode = (SummaryExtentNode)this.getModel();
        return nextNode.getSourceConnections() != null && !nextNode.getSourceConnections().isEmpty() || nextNode.getTargetConnections() != null && !nextNode.getTargetConnections().isEmpty();
    }

    @Override
    public List getDependencies() {
        DiagramModelNode modelNode = (DiagramModelNode)this.getModel();
        if (modelNode != null) {
            return modelNode.getDependencies();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void layout(boolean layoutChildren) {
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().layoutFigure();
        }
        this.updateModelSize();
    }

    @Override
    public DragTracker getDragTracker(Request req) {
        if (this.myDragTracker == null) {
            this.myDragTracker = new SelectEditPartTracker((EditPart)this);
        }
        return this.myDragTracker;
    }

    @Override
    public boolean shouldReveal() {
        return false;
    }

    @Override
    public void updateModelSize() {
        ((SummaryExtentNode)this.getModel()).updateModelForExtent();
    }

    @Override
    public void activate() {
        super.activate();
        if (((SummaryExtentNode)this.getModel()).getExtent().getMappingReference() instanceof StagingTable) {
            ((SummaryExtentNode)this.getModel()).updateModelForExtent();
        }
    }
}

