/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigure;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;
import org.teiid.designer.ui.common.graphics.GlobalUiFontManager;

public class MappingExtentFigure
extends AbstractDiagramFigure {
    protected Polygon extentOutline;
    private Label nameLabel;
    private Color defaultBkgdColor = null;
    private PointList transformPoints = new PointList();

    public MappingExtentFigure(String name, ColorPalette colorPalette) {
        super(colorPalette);
        this.init(name);
        this.createComponent();
    }

    public MappingExtentFigure(ColorPalette colorPalette) {
        super(colorPalette);
        this.createComponent();
    }

    public void setName(String sName) {
        this.init(sName);
    }

    protected void init(String name) {
        this.defaultBkgdColor = this.getColor(0);
        this.extentOutline = new Polygon();
        this.transformPoints.addPoint(0, 0);
        this.transformPoints.addPoint(10, 0);
        this.transformPoints.addPoint(20, 20);
        this.transformPoints.addPoint(10, 40);
        this.transformPoints.addPoint(0, 40);
        this.transformPoints.addPoint(0, 0);
        this.extentOutline.setPoints(this.transformPoints);
        this.add((IFigure)this.extentOutline);
        this.extentOutline.setLineWidth(2);
        this.extentOutline.setForegroundColor(ColorConstants.darkBlue);
        this.extentOutline.setBackgroundColor(this.getColor(0));
        this.extentOutline.setFill(true);
        if (name != null) {
            this.nameLabel = new Label(name);
            this.nameLabel.setFont(GlobalUiFontManager.getFont((FontData)new FontData("Arial", 16, 3)));
            this.add((IFigure)this.nameLabel);
            this.nameLabel.setForegroundColor(ColorConstants.black);
            this.nameLabel.setBackgroundColor(this.getLocalBackgroundColor());
            this.setLabelSize(this.nameLabel);
        }
    }

    protected void createComponent() {
        this.setInitialSize();
        this.layoutThisFigure(this.getSize());
    }

    protected void setLabelSize(Label label) {
        Font theFont = label.getFont();
        int labelWidth = FigureUtilities.getTextExtents((String)label.getText(), (Font)theFont).width;
        if (label.getIcon() != null) {
            labelWidth += label.getIcon().getBounds().width;
        }
        int labelHeight = FigureUtilities.getTextExtents((String)label.getText(), (Font)theFont).height;
        label.setSize(labelWidth, labelHeight);
    }

    protected void setInitialSize() {
        int maxWidth = 21;
        int maxHeight = 12;
        this.setSize(new Dimension(maxWidth, maxHeight));
    }

    protected void layoutThisFigure(Dimension newSize) {
        this.setSize(newSize);
        int centerX = newSize.width / 2;
        int centerY = newSize.height / 2;
        if (this.nameLabel != null) {
            this.nameLabel.setLocation(new Point(centerX - this.nameLabel.getBounds().width / 2, centerY - this.nameLabel.getBounds().height / 2));
        }
    }

    public void updateForSize(Dimension size) {
        int thisHeight = size.height;
        int thisWidth = size.width;
        int twoThirds = (int)(2.0 * (double)thisWidth / 3.0);
        this.replacePoint(0, 0, 0);
        this.replacePoint(1, twoThirds, 0);
        this.replacePoint(2, thisWidth, thisHeight / 2);
        this.replacePoint(3, twoThirds, thisHeight);
        this.replacePoint(4, 0, thisHeight);
        this.replacePoint(5, 0, 0);
        this.extentOutline.setPoints(this.transformPoints);
        this.layoutThisFigure(size);
        this.repaint();
    }

    public void layoutComponent() {
        this.layoutThisFigure(this.getSize());
    }

    public void updateSize() {
    }

    protected void replacePoint(int index, int newX, int newY) {
        this.transformPoints.setPoint(new Point(newX, newY), index);
    }

    public void hiliteBackground(Color hiliteColor) {
        if (hiliteColor == null) {
            this.extentOutline.setBackgroundColor(this.defaultBkgdColor);
        } else {
            this.extentOutline.setBackgroundColor(hiliteColor);
        }
    }

    public void showSelected(boolean selected) {
        if (selected) {
            this.extentOutline.setBackgroundColor(this.getColor(3));
        } else {
            this.extentOutline.setBackgroundColor(this.getColor(0));
        }
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    public void setDefaultBkgdColor(Color someColor) {
        this.defaultBkgdColor = someColor;
    }

    public void setOutlineColor(Color someColor) {
        this.extentOutline.setForegroundColor(someColor);
    }

    public void setOutlineWidth(int newWidth) {
        this.extentOutline.setLineWidth(newWidth);
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        super.paint(graphics);
        this.paintOutline(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    protected void paintOutline(Graphics graphics) {
        int orgX = this.getBounds().x;
        int orgY = this.getBounds().y;
        PointList pts = this.extentOutline.getPoints();
        graphics.setLineWidth(1);
        graphics.setForegroundColor(ColorConstants.buttonDarkest);
        graphics.drawLine(orgX + pts.getPoint((int)0).x, orgY + pts.getPoint((int)0).y + 1, orgX + pts.getPoint((int)1).x, orgY + pts.getPoint((int)1).y + 1);
        graphics.drawLine(orgX + pts.getPoint((int)1).x, orgY + pts.getPoint((int)1).y, orgX + pts.getPoint((int)2).x - 1, orgY + pts.getPoint((int)2).y);
        graphics.setForegroundColor(ColorConstants.buttonDarkest);
        graphics.drawLine(orgX + pts.getPoint((int)2).x - 1, orgY + pts.getPoint((int)2).y, orgX + pts.getPoint((int)3).x, orgY + pts.getPoint((int)3).y - 2);
        graphics.drawLine(orgX + pts.getPoint((int)3).x, orgY + pts.getPoint((int)3).y - 2, orgX + pts.getPoint((int)4).x, orgY + pts.getPoint((int)4).y - 2);
    }
}

