/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.mapping.factory.TreeMappingAdapter;
import org.teiid.designer.mapping.ui.editor.DocumentTreeController;
import org.teiid.designer.metamodels.transformation.MappingClass;
import org.teiid.designer.metamodels.transformation.StagingTable;
import org.teiid.designer.metamodels.xml.util.XmlDocumentUtil;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.MarkerUtilities;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class XmlDocumentModelObjectLabelProvider
extends ModelExplorerLabelProvider {
    private static final String SUFFIX_EXCLUDED = Util.getString("XmlDocumentModelObjectLabelProvider.suffixExcluded", new Object[0]);
    private static final Color TEMP_COLOR = GlobalUiColorManager.getColor((RGB)new RGB(247, 247, 247));
    private static final Color PHYSICAL_COLOR = GlobalUiColorManager.getColor((RGB)new RGB(0, 220, 225));
    private static final Color VIRTUAL_COLOR = GlobalUiColorManager.getColor((RGB)new RGB(255, 204, 102));
    static Color gray = null;
    private ILabelProvider delegate = ModelUtilities.getAdapterFactoryLabelProvider();
    private TreeMappingAdapter tmaMappingAdapter;
    private DocumentTreeController docTreeController;

    public XmlDocumentModelObjectLabelProvider() {
    }

    public XmlDocumentModelObjectLabelProvider(DocumentTreeController docTreeController) {
        this.docTreeController = docTreeController;
    }

    public Image getImage(Object theElement) {
        Image result;
        block9: {
            result = null;
            if (theElement instanceof XSDSimpleTypeDefinition) {
                try {
                    if (ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype((EObject)((XSDSimpleTypeDefinition)theElement))) {
                        result = UiPlugin.getDefault().getImage("icons/full/obj16/BuiltinDatatype.gif");
                        break block9;
                    }
                    result = this.delegate.getImage(theElement);
                }
                catch (Exception exception) {
                    result = this.delegate.getImage(theElement);
                }
            } else if (theElement instanceof EObject) {
                EObject eObj = (EObject)theElement;
                Image temp = this.delegate.getImage(theElement);
                boolean virtual = ModelObjectUtilities.isVirtual((EObject)eObj);
                String prefix = virtual ? "virtual." : "physical.";
                String imageId = String.valueOf(prefix) + temp.hashCode();
                UiPlugin plugin = UiPlugin.getDefault();
                if (plugin.isImageRegistered(imageId)) {
                    result = plugin.getImage(imageId);
                } else {
                    result = UiUtil.createImage((Image)temp, (Color)TEMP_COLOR, (Color)(virtual ? VIRTUAL_COLOR : PHYSICAL_COLOR));
                    plugin.registerPluginImage(imageId, result);
                }
            } else {
                result = this.delegate.getImage(theElement);
            }
        }
        return result;
    }

    public Image getImage(EObject theElement, boolean isVirtual) {
        Image result;
        block7: {
            result = null;
            if (theElement instanceof XSDSimpleTypeDefinition) {
                try {
                    if (ModelerCore.getWorkspaceDatatypeManager().isBuiltInDatatype(theElement)) {
                        result = UiPlugin.getDefault().getImage("icons/full/obj16/BuiltinDatatype.gif");
                        break block7;
                    }
                    result = this.delegate.getImage((Object)theElement);
                }
                catch (Exception exception) {
                    result = this.delegate.getImage((Object)theElement);
                }
            } else {
                Image temp = this.delegate.getImage((Object)theElement);
                String prefix = isVirtual ? "virtual." : "physical.";
                String imageId = String.valueOf(prefix) + temp.hashCode();
                UiPlugin plugin = UiPlugin.getDefault();
                if (plugin.isImageRegistered(imageId)) {
                    result = plugin.getImage(imageId);
                } else {
                    result = UiUtil.createImage((Image)temp, (Color)TEMP_COLOR, (Color)(isVirtual ? VIRTUAL_COLOR : PHYSICAL_COLOR));
                    plugin.registerPluginImage(imageId, result);
                }
            }
        }
        return result;
    }

    public String getText(Object theElement) {
        String sText;
        String sFinalText = sText = StringUtilities.replaceWhitespace((String)this.delegate.getText(theElement), (boolean)true);
        if (theElement instanceof EObject) {
            StagingTable st;
            this.tmaMappingAdapter = this.docTreeController.getMappingAdapterFilter().getMappingAdapter();
            MappingClass mc = this.tmaMappingAdapter.getMappingClass((EObject)theElement);
            if (mc != null && mc.getName() != null && mc.getName().trim() != "") {
                String sMappingClassName = mc.getName();
                sFinalText = String.valueOf(sText) + " [MC: " + sMappingClassName + "]";
            }
            if ((st = this.tmaMappingAdapter.getStagingTableForRootTreeNode((EObject)theElement)) != null && st.getName() != null && st.getName().trim() != "") {
                String sStagingTableName = st.getName();
                sFinalText = String.valueOf(sText) + " [ST: " + sStagingTableName + "]";
            }
        }
        return sFinalText;
    }

    public void decorate(Object element, IDecoration decoration) {
        IMarker[] markers;
        ImageDescriptor decorationIcon;
        Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        IResource resrc = this.getResource(element);
        if (resrc == null || !resrc.exists() || resrc instanceof IProject && !((IProject)resrc).isOpen()) {
            return;
        }
        IMarker[] mrkrs = null;
        boolean errorOccurred = false;
        try {
            mrkrs = resrc.findMarkers("org.eclipse.core.resources.problemmarker", false, 2);
        }
        catch (CoreException ex) {
            Util.log((Throwable)ex);
            errorOccurred = true;
        }
        if (!errorOccurred && (decorationIcon = this.getDecorationIcon((EObject)element, resrc, markers = mrkrs)) != null) {
            decoration.addOverlay(decorationIcon);
        }
        if (gray == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    gray = UiUtil.getSystemColor((int)15);
                }
            });
        }
        if (XmlDocumentUtil.isExcluded((Object)element, (boolean)true)) {
            decoration.setForegroundColor(gray);
            if (XmlDocumentUtil.isExcluded((Object)element, (boolean)false)) {
                decoration.addSuffix(SUFFIX_EXCLUDED);
            }
        }
    }

    private ImageDescriptor getDecorationIcon(EObject element, IResource resrc, IMarker[] markers) {
        ImageDescriptor icon = null;
        int ndx = markers.length;
        while (--ndx >= 0) {
            Object attr;
            boolean usable;
            IMarker marker = markers[ndx];
            EObject targetEObject = ModelWorkspaceManager.getModelWorkspaceManager().getMarkerManager().getMarkedEObject(resrc, marker);
            boolean bl = usable = element == targetEObject || ModelObjectUtilities.isDescendant((EObject)element, (EObject)targetEObject);
            if (!usable || (attr = MarkerUtilities.getMarkerAttribute((IMarker)marker, (String)"severity")) == null) continue;
            int severity = (Integer)attr;
            if (severity == 2) {
                icon = UiPlugin.getDefault().getErrorDecoratorImage();
                break;
            }
            if (icon != null || severity != 1) continue;
            icon = UiPlugin.getDefault().getWarningDecoratorImage();
        }
        return icon;
    }

    private IResource getResource(Object element) {
        if (element instanceof EObject) {
            IResource ir = null;
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)element));
            if (modelResource != null) {
                ir = modelResource.getResource();
            }
            return ir;
        }
        return null;
    }

    public Image getImage(EObject eObj, Object url) {
        Image result = null;
        Image temp = ModelObjectUtilities.getImageFromObject((Object)url);
        if (temp != null) {
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObj);
            boolean virtual = ModelUtilities.isVirtual((ModelResource)modelResource);
            String prefix = virtual ? "virtual." : "physical.";
            String imageId = String.valueOf(prefix) + temp.hashCode();
            UiPlugin plugin = UiPlugin.getDefault();
            if (plugin.isImageRegistered(imageId)) {
                result = plugin.getImage(imageId);
            } else {
                result = UiUtil.createImage((Image)temp, (Color)TEMP_COLOR, (Color)(virtual ? VIRTUAL_COLOR : PHYSICAL_COLOR));
                plugin.registerPluginImage(imageId, result);
            }
        }
        return result;
    }

    public void setTreeMappingAdapter(TreeMappingAdapter tmaMappingAdapter) {
        this.tmaMappingAdapter = tmaMappingAdapter;
    }
}

