/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.HashCodeUtil;

public class MappingExtent {
    protected boolean completelyMapped = true;
    protected EObject documentNodeRef;
    protected double height = 0.0;
    protected EObject mappingRef;
    protected boolean mappingRequired = false;
    protected int unmappedOptional = 0;
    protected int unmappedRequired = 0;
    protected double offset = 0.0;
    protected String pathToDocumentRoot;
    protected String xsdQualifiedName;
    protected String xsdTargetNamespace;

    public MappingExtent(EObject theMappingReference) {
        this.mappingRef = theMappingReference;
    }

    public MappingExtent(double theOffset, double theHeight, EObject theMappingReference, EObject theDocumentNodeReference) {
        this(theMappingReference);
        this.documentNodeRef = theDocumentNodeReference;
        this.setOffset(theOffset);
        this.increaseHeight(theHeight);
    }

    public boolean equals(Object theObject) {
        MappingExtent extent;
        boolean result = false;
        if (theObject instanceof MappingExtent && this.offset == (extent = (MappingExtent)theObject).getOffset() && this.height == extent.getHeight()) {
            if (this.mappingRef == null) {
                result = extent.getMappingReference() == null;
            } else {
                EObject ref = extent.getMappingReference();
                if (ref != null) {
                    result = this.mappingRef.equals(ref);
                }
            }
            if (result) {
                boolean bl = result = this.isMappingRequired() == extent.isMappingRequired();
                if (result) {
                    boolean bl2 = result = this.isCompletelyMapped() == extent.isCompletelyMapped();
                    if (result) {
                        if (this.documentNodeRef == null) {
                            result = extent.getDocumentNodeReference() == null;
                        } else {
                            EObject docRef = extent.getDocumentNodeReference();
                            if (docRef != null) {
                                result = this.documentNodeRef.equals(docRef);
                            }
                        }
                    }
                }
            }
        }
        return result;
    }

    public EObject getDocumentNodeReference() {
        return this.documentNodeRef;
    }

    public double getHeight() {
        return this.height;
    }

    public EObject getMappingReference() {
        return this.mappingRef;
    }

    public double getOffset() {
        return this.offset;
    }

    public int getUnmappedOptionalNodeCount() {
        return this.unmappedOptional;
    }

    public int getUnmappedRequiredNodeCount() {
        return this.unmappedRequired;
    }

    public int hashCode() {
        int result = HashCodeUtil.hashCode((int)((int)this.offset), (boolean)this.isCompletelyMapped());
        result = HashCodeUtil.hashCode((int)result, (double)this.height);
        result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.mappingRef});
        return HashCodeUtil.hashCode((int)result, (boolean)this.isMappingRequired());
    }

    public void increaseHeight(double theIncrease) {
        if (theIncrease < 0.0) {
            throw new IllegalArgumentException("Height increase <" + theIncrease + "> is less than zero.");
        }
        this.height += theIncrease;
    }

    public void incrementUnmappedOptionNodeCount() {
        ++this.unmappedOptional;
    }

    public void incrementUnmappedRequiredNodeCount() {
        ++this.unmappedRequired;
    }

    public boolean isCompletelyMapped() {
        return this.completelyMapped;
    }

    public boolean isMappingRequired() {
        return this.mappingRequired;
    }

    public String paramString() {
        return new StringBuffer().append("offset=").append(this.offset).append(", height=").append(this.height).append(", completely mapped=").append(this.isCompletelyMapped()).append(", mapping required=").append(this.isMappingRequired()).append(", unmapped optional=").append(this.getUnmappedOptionalNodeCount()).append(", unmapped required=").append(this.getUnmappedRequiredNodeCount()).append(", mapping reference=").append(this.mappingRef).append(", document node reference=").append(this.documentNodeRef).toString();
    }

    public void setOffset(double theOffset) {
        this.offset = theOffset;
    }

    public void setCompletelyMapped(boolean theMappedFlag) {
        this.completelyMapped = theMappedFlag;
    }

    public void setMappingRequired(boolean theRequiredFlag) {
        this.mappingRequired = theRequiredFlag;
    }

    public void setUnmappedOptionalNodeCount(int theCount) {
        this.unmappedOptional = theCount < 0 ? 0 : theCount;
    }

    public void setUnmappedRequiredNodeCount(int theCount) {
        this.unmappedRequired = theCount < 0 ? 0 : theCount;
    }

    public String toString() {
        return this.paramString();
    }

    public String getPathToDocumentRoot() {
        return this.pathToDocumentRoot;
    }

    public void setPathToDocumentRoot(String string) {
        this.pathToDocumentRoot = string;
    }

    public String getXsdQualifiedName() {
        return this.xsdQualifiedName;
    }

    public void setXsdQualifiedName(String string) {
        this.xsdQualifiedName = string;
    }

    public String getXsdTargetNamespace() {
        return this.xsdTargetNamespace;
    }

    public void setXsdTargetNamespace(String string) {
        this.xsdTargetNamespace = string;
    }
}

