/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.teiid.designer.mapping.ui.editor.BindingAdapter;
import org.teiid.designer.mapping.ui.editor.IBindingListViewer;
import org.teiid.designer.metamodels.transformation.InputParameter;

public class BindingList {
    private final int COUNT = 10;
    private List bindings = new ArrayList(10);
    private Set changeListeners = new HashSet();

    public BindingAdapter get(int index) {
        if (index >= 0 && index < this.bindings.size()) {
            return (BindingAdapter)this.bindings.get(index);
        }
        return null;
    }

    public List getAll() {
        return this.bindings;
    }

    public boolean contains(InputParameter inputParm) {
        boolean hasMatch = false;
        for (BindingAdapter binding : this.bindings) {
            Object item = binding.getItem();
            if (item == null || !item.equals(inputParm)) continue;
            hasMatch = true;
            break;
        }
        return hasMatch;
    }

    public BindingAdapter getBindingFor(InputParameter inputParm) {
        BindingAdapter result = null;
        for (BindingAdapter binding : this.bindings) {
            Object item = binding.getItem();
            if (item == null || !item.equals(inputParm)) continue;
            result = binding;
            break;
        }
        return result;
    }

    public int size() {
        return this.bindings.size();
    }

    public void add(BindingAdapter binding) {
        this.bindings.add(this.bindings.size(), binding);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IBindingListViewer)iterator.next()).addBinding(binding);
        }
    }

    public void addAll(List bindings) {
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            this.add((BindingAdapter)iter.next());
        }
    }

    public void insert(BindingAdapter binding, int index) {
        this.bindings.add(index, binding);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IBindingListViewer)iterator.next()).insertBinding(binding, index);
        }
    }

    public void remove(BindingAdapter binding) {
        this.bindings.remove(binding);
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IBindingListViewer)iterator.next()).removeBinding(binding);
        }
    }

    public void removeAll(List bindings) {
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            this.remove((BindingAdapter)iter.next());
        }
    }

    public void bindingChanged(BindingAdapter binding) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IBindingListViewer)iterator.next()).updateBinding(binding);
        }
    }

    public void refresh(boolean updateLabels) {
        Iterator iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            ((IBindingListViewer)iterator.next()).refresh(updateLabels);
        }
    }

    public int indexOf(BindingAdapter binding) {
        return this.bindings.indexOf(binding);
    }

    public BindingAdapter getFirstUnbound() {
        BindingAdapter result = null;
        for (BindingAdapter binding : this.bindings) {
            if (binding.isBound()) continue;
            result = binding;
            break;
        }
        return result;
    }

    public BindingAdapter getFirstBound() {
        BindingAdapter result = null;
        for (BindingAdapter binding : this.bindings) {
            if (!binding.isBound()) continue;
            result = binding;
            break;
        }
        return result;
    }

    public BindingAdapter getNextUnbound(BindingAdapter binding) {
        BindingAdapter result = null;
        int index = this.indexOf(binding);
        int i = index + 1;
        while (i < this.size()) {
            BindingAdapter nextBinding = (BindingAdapter)this.bindings.get(i);
            if (!nextBinding.isBound()) {
                result = nextBinding;
                break;
            }
            ++i;
        }
        if (result == null) {
            return this.getFirstUnbound();
        }
        return result;
    }

    public BindingAdapter getNextBound(BindingAdapter binding) {
        BindingAdapter result = null;
        int index = this.indexOf(binding);
        int i = index + 1;
        while (i < this.size()) {
            BindingAdapter nextBinding = (BindingAdapter)this.bindings.get(i);
            if (nextBinding.isBound()) {
                result = nextBinding;
                break;
            }
            ++i;
        }
        if (result == null) {
            return this.getFirstBound();
        }
        return result;
    }

    public void moveUp(BindingAdapter binding) {
        int currentIndex = this.indexOf(binding);
        if (currentIndex > 0) {
            BindingAdapter removedBinding = (BindingAdapter)this.bindings.remove(currentIndex);
            this.bindings.add(--currentIndex, removedBinding);
            this.refresh(true);
        }
    }

    public void moveDown(BindingAdapter binding) {
        int index = this.indexOf(binding);
        if (index > -1 && index < this.bindings.size() - 1) {
            BindingAdapter removedBinding = (BindingAdapter)this.bindings.remove(index);
            this.bindings.add(++index, removedBinding);
            this.refresh(true);
        }
    }

    public void removeChangeListener(IBindingListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IBindingListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

