/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.choice;

import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.teiid.designer.mapping.ui.choice.CriteriaSourceViewerConfiguration;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.query.ui.sqleditor.sql.SqlPartitionScanner;

public class CriteriaTextViewer
extends SourceViewer {
    IPresentationReconciler fPresentationReconciler;
    private IDocumentPartitioner partitioner;
    private static SqlPartitionScanner scanner = null;
    private static final String[] TYPES = new String[]{"sql_code", "sql_multiline_comment"};
    IAutoEditStrategy autoIndentStrategy;
    ITextDoubleClickStrategy doubleClickStrategy;
    IContentAssistant contentAssistant;
    ITextHover textHover;
    CriteriaSourceViewerConfiguration configuration;

    public void setDocument(IDocument dc) {
        IDocument previous = this.getDocument();
        if (previous != null) {
            this.partitioner.disconnect();
        }
        super.setDocument(dc);
        if (dc != null) {
            this.partitioner.connect(dc);
            dc.setDocumentPartitioner(this.partitioner);
        }
    }

    public CriteriaTextViewer(Composite parent, IVerticalRuler ruler, int style, ColorManager colorManager, CriteriaSourceViewerConfiguration csvc) {
        super(parent, ruler, style);
        this.configuration = csvc;
        this.fPresentationReconciler = this.configuration.getPresentationReconciler(null);
        this.contentAssistant = this.configuration.getContentAssistant(null);
        if (this.contentAssistant != null) {
            this.contentAssistant.install((ITextViewer)this);
        }
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install((ITextViewer)this);
        }
        this.doubleClickStrategy = this.configuration.getDoubleClickStrategy(null, "");
        this.autoIndentStrategy = this.configuration.getAutoEditStrategies((ISourceViewer)this, "__dftl_partition_content_type")[0];
        this.prependAutoEditStrategy(this.autoIndentStrategy, "__dftl_partition_content_type");
        this.textHover = this.configuration.getTextHover((ISourceViewer)this, "__dftl_partition_content_type");
        this.setTextHover(this.textHover, "__dftl_partition_content_type");
        this.partitioner = this.createSqlPartitioner();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CriteriaTextViewer.this.contentAssistant.uninstall();
            }
        });
    }

    private FastPartitioner createSqlPartitioner() {
        return new FastPartitioner((IPartitionTokenScanner)this.getSqlPartitionScanner(), TYPES);
    }

    private SqlPartitionScanner getSqlPartitionScanner() {
        if (scanner == null) {
            scanner = new SqlPartitionScanner();
        }
        return scanner;
    }

    public void showAssistance() {
        this.contentAssistant.showPossibleCompletions();
    }

    public void handleDoubleClick() {
        this.doubleClickStrategy.doubleClicked((ITextViewer)this);
    }

    public void setDocument(IDocument document, IAnnotationModel annotationModel) {
        this.setDocument(document);
        if (annotationModel != null && document != null) {
            annotationModel.connect(document);
        }
    }
}

