/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.mapping.ui.UiConstants;
import org.teiid.designer.mapping.ui.UiPlugin;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.diagram.MappingDiagramUtil;
import org.teiid.designer.mapping.ui.editor.MappingDiagramBehavior;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;

public class TogglePopulateDiagramFromTreeSelectionAction
extends MappingAction {
    private static String POPULATE_DIAGRAM_FROM_TREE_SELECTION_TOOLTIP = UiConstants.Util.getString("TogglePopulateDiagramFromTreeSelectionAction.action.tooltip", new Object[0]);
    private static String POPULATE_DIAGRAM_FROM_TREE_SELECTION_TEXT = UiConstants.Util.getString("TogglePopulateDiagramFromTreeSelectionAction.action.text", new Object[0]);
    private boolean logicalModel = false;

    public TogglePopulateDiagramFromTreeSelectionAction() {
        super(UiPlugin.getDefault(), 2);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/filter_change.gif"));
        this.setToolTipText(POPULATE_DIAGRAM_FROM_TREE_SELECTION_TOOLTIP);
        this.setText(POPULATE_DIAGRAM_FROM_TREE_SELECTION_TEXT);
    }

    @Override
    public void setDiagramEditor(DiagramEditor editor) {
        super.setDiagramEditor(editor);
        boolean logical = ModelIdentifier.isLogicalModel((ModelResource)editor.getCurrentModelResource());
        if (this.logicalModel != logical) {
            this.logicalModel = logical;
            String key = logical ? "TogglePopulateDiagramFromTreeSelectionAction.logicalModel.action.tooltip" : POPULATE_DIAGRAM_FROM_TREE_SELECTION_TOOLTIP;
            this.setToolTipText(UiConstants.Util.getString(key, new Object[0]));
            key = logical ? "TogglePopulateDiagramFromTreeSelectionAction.logicalModel.action.text" : POPULATE_DIAGRAM_FROM_TREE_SELECTION_TEXT;
            this.setText(UiConstants.Util.getString(key, new Object[0]));
        }
        this.updateButtonState();
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.determineEnablement();
    }

    private MappingDiagramBehavior getBehavior() {
        return MappingDiagramUtil.getCurrentMappingDiagramBehavior();
    }

    @Override
    protected void doRun() {
        boolean bPopulateDiagramFromTreeSelection = this.getBehavior().getPopulateDiagramFromTreeSelectionState();
        bPopulateDiagramFromTreeSelection = !bPopulateDiagramFromTreeSelection;
        this.getBehavior().setPopulateDiagramFromTreeSelectionState(bPopulateDiagramFromTreeSelection);
        this.updateButtonState();
        this.editor.doRefreshDiagram();
    }

    private void determineEnablement() {
        boolean enable = true;
        this.setEnabled(enable);
    }

    protected void updateButtonState() {
        this.setChecked(this.getBehavior().getPopulateDiagramFromTreeSelectionState());
    }
}

