/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.mapping.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.mapping.ui.actions.MappingAction;
import org.teiid.designer.mapping.ui.actions.MappingGlobalActionsManager;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CloneAction
extends MappingAction
implements UiConstants {
    private static final String PROBLEM = "CloneAction.problem";
    private static final String UNDO_TEXT = "CloneAction.undoText";
    private static final String PLURAL_UNDO_TEXT = "CloneAction.pluralUndoText";

    public CloneAction(EObject transformationEObject) {
        super(transformationEObject);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        block16: {
            String objectString = null;
            List lstObjs = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            String description = null;
            if (lstObjs.size() == 1) {
                EObject obj = (EObject)lstObjs.get(0);
                ILabelProvider ilp = ModelUtilities.getEMFLabelProvider();
                objectString = ilp.getText((Object)obj);
                description = this.getPluginUtils().getString(UNDO_TEXT, (Object)objectString);
            } else {
                objectString = "" + lstObjs.size();
                description = this.getPluginUtils().getString(PLURAL_UNDO_TEXT, (Object)objectString);
            }
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)description, (Object)((Object)this));
            boolean succeeded = false;
            try {
                try {
                    MappingGlobalActionsManager.clone(lstObjs);
                    succeeded = true;
                }
                catch (ModelerCoreException theException) {
                    String msg = this.getPluginUtils().getString(PROBLEM, (Object)objectString);
                    this.getPluginUtils().log(4, (Throwable)theException, msg);
                    this.setEnabled(false);
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        this.setEnabled(false);
    }

    private void determineEnablement() {
        boolean enable = false;
        if (!this.isEmptySelection() && !this.isReadOnly()) {
            List<EObject> sourceEObjects = null;
            if (SelectionUtilities.isSingleSelection((ISelection)this.getSelection())) {
                sourceEObjects = new ArrayList(1);
                EObject o = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
                sourceEObjects.add(o);
            } else if (SelectionUtilities.isMultiSelection((ISelection)this.getSelection())) {
                sourceEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
            }
            enable = MappingGlobalActionsManager.canClone(sourceEObjects);
        }
        this.setEnabled(enable);
    }
}

