/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.webdav.internal.kernel.Condition;
import org.eclipse.webdav.internal.kernel.ConditionTerm;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.StateToken;
import org.eclipse.webdav.internal.kernel.WebDAVException;

public class Precondition {
    private Vector conditions = new Vector();

    public Precondition() {
    }

    public Precondition(String ifHeader) throws WebDAVException {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(ifHeader));
        tokenizer.wordChars(33, 47);
        tokenizer.wordChars(58, 64);
        tokenizer.ordinaryChar(40);
        tokenizer.ordinaryChar(41);
        tokenizer.ordinaryChar(60);
        tokenizer.ordinaryChar(62);
        tokenizer.ordinaryChar(91);
        tokenizer.ordinaryChar(93);
        tokenizer.quoteChar(34);
        int token = 0;
        try {
            token = tokenizer.nextToken();
            switch (token) {
                case 60: {
                    while (token == 60) {
                        this.addCondition(Condition.create(tokenizer));
                        token = tokenizer.ttype;
                    }
                    break;
                }
                case 40: {
                    while (token == 40) {
                        this.addCondition(Condition.create(tokenizer));
                        token = tokenizer.ttype;
                    }
                    break;
                }
            }
            if (token != -1) {
                throw new WebDAVException(400, Policy.bind("error.parseMissing", String.valueOf(token), "EOF"));
            }
            if (!this.getConditions().hasMoreElements()) {
                throw new WebDAVException(400, Policy.bind("error.parseEmptyList", ifHeader));
            }
        }
        catch (IOException iOException) {}
    }

    public void addCondition(Condition condition) throws WebDAVException {
        Enumeration conditions = this.getConditions();
        if (condition.getResourceURI() != null) {
            while (conditions.hasMoreElements()) {
                Condition existingCondition = (Condition)conditions.nextElement();
                if (existingCondition.getResourceURI() == null || !existingCondition.getResourceURI().equals(condition.getResourceURI())) continue;
                throw new WebDAVException(400, Policy.bind("error.parseMultipleSpecification", condition.getResourceURI()));
            }
        }
        this.conditions.addElement(condition);
    }

    public void addStateTokenCondition(String resourceURI, String stateToken) throws WebDAVException {
        Condition condition = new Condition(resourceURI);
        ConditionTerm term = new ConditionTerm();
        term.addConditionFactor(new StateToken(stateToken));
        condition.addConditionTerm(term);
        this.addCondition(condition);
    }

    public static Precondition create(String ifHeader) throws WebDAVException {
        return new Precondition(ifHeader);
    }

    public Enumeration getConditions() {
        return this.conditions.elements();
    }

    public boolean matches(Condition condition) {
        boolean match = false;
        Enumeration conditions = this.getConditions();
        while (!match && conditions.hasMoreElements()) {
            Condition existingCondition = (Condition)conditions.nextElement();
            match = existingCondition.matches(condition);
        }
        return match;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Enumeration conditions = this.getConditions();
        while (conditions.hasMoreElements()) {
            Condition condition = (Condition)conditions.nextElement();
            buffer.append(condition.toString());
            if (!conditions.hasMoreElements()) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

