/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.dom;

import org.eclipse.webdav.Policy;
import org.eclipse.webdav.dom.Assert;
import org.eclipse.webdav.dom.MalformedElementException;
import org.eclipse.webdav.dom.Property;
import org.w3c.dom.Element;

public class ResourceID
extends Property {
    protected static final String[] childNames = new String[]{"href"};

    public ResourceID(Element root) throws MalformedElementException {
        super(root, "resourceid");
    }

    public String getHref() throws MalformedElementException {
        String href = ResourceID.getChildText(this.root, "href", true);
        ResourceID.ensureNotNull(Policy.bind("ensure.missingHrefElmt"), href);
        return ResourceID.decodeHref(href);
    }

    public void setHref(String href) {
        Assert.isNotNull(href);
        ResourceID.setChild(this.root, "href", ResourceID.encodeHref(href), childNames, true);
    }
}

