/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.ui.common.ICredentialsCommon;

public class WSDLSchemaExtractor {
    private ResourceSet resourceSet = new ResourceSetImpl();
    private HashSet schemas;

    public WSDLSchemaExtractor() {
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.schemas = new HashSet();
    }

    public void findSchema(String wsdlUriString, ICredentialsCommon.SecurityType securityType, String userName, String password) throws IOException {
        URI uri;
        InputStream inputStream = null;
        if (wsdlUriString.startsWith("http")) {
            uri = URI.createURI((String)wsdlUriString);
            URL remoteURL = new URL(wsdlUriString);
            URLConnection urlConn = remoteURL.openConnection();
            if (securityType != null && !ICredentialsCommon.SecurityType.None.equals((Object)securityType)) {
                URLHelper.setCredentials((URLConnection)urlConn, (String)userName, (String)password);
            }
            inputStream = urlConn.getInputStream();
        } else {
            int indx = wsdlUriString.indexOf("file:");
            if (indx != -1) {
                wsdlUriString = wsdlUriString.substring(indx + 5);
            }
            File testWsdl = new File(wsdlUriString);
            uri = URI.createFileURI((String)testWsdl.getCanonicalPath().toString());
        }
        WSDLResourceFactoryImpl fac = (WSDLResourceFactoryImpl)this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().get("wsdl");
        Resource res = fac.createResource(uri);
        if (res instanceof WSDLResourceImpl) {
            Definition def;
            Types types;
            WSDLResourceImpl wsdlResource = (WSDLResourceImpl)res;
            wsdlResource.basicSetResourceSet(this.resourceSet, null);
            if (!wsdlResource.isLoaded()) {
                if (inputStream == null) {
                    wsdlResource.load(null);
                } else {
                    wsdlResource.load(inputStream, null);
                }
            }
            if ((types = (def = wsdlResource.getDefinition()).getETypes()) != null) {
                this.schemas.addAll(types.getSchemas());
            }
        }
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public XSDSchema[] getSchemas() {
        for (Resource res : this.resourceSet.getResources()) {
            if (!(res instanceof XSDResourceImpl)) continue;
            XSDResourceImpl schema = (XSDResourceImpl)res;
            this.schemas.add(schema.getSchema());
        }
        XSDSchema[] retVal = new XSDSchema[this.schemas.size()];
        this.schemas.toArray(retVal);
        return retVal;
    }
}

