/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.schema.extensions;

import java.util.Map;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.teiid.designer.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import org.teiid.designer.schema.tools.model.schema.Column;
import org.teiid.designer.schema.tools.model.schema.QName;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.ElementImpl;
import org.teiid.designer.schema.tools.model.schema.impl.TextColumn;
import org.teiid.designer.schema.tools.model.schema.impl.TypeDefinition;
import org.teiid.designer.schema.tools.processing.SchemaProcessingException;
import org.teiid.designer.schema.tools.processing.SchemaUtil;
import org.teiid.designer.schema.tools.processing.internal.ElementContentTraversalContext;
import org.teiid.designer.schema.tools.processing.internal.SchemaProcessorImpl;

public class SOAPSchemaProcessor
extends SchemaProcessorImpl {
    public SOAPSchemaProcessor(String separator) {
        super(separator);
    }

    public void processElementText(SchemaObject element) {
        XSDSimpleTypeDefinition textType = element.getTextType();
        if (textType != null) {
            TextColumn col = new TextColumn(false, textType);
            element.addAttribute((Column)col);
        }
    }

    public void processType(XSDTypeDefinition type, ElementContentTraversalContext traverseCtx2, XSDSchema schema) throws SchemaProcessingException {
        String namespacePrefix = this.getNameSpacePrefix(type.getTargetNamespace());
        TypeDefinition typeDecl = new TypeDefinition(type, namespacePrefix, schema);
        String fileName = SchemaUtil.shortenFileName((String)schema.getSchemaLocation());
        typeDecl.setFileName(fileName);
        this.addElement((SchemaObject)typeDecl);
        this.processAttributes((SchemaObject)typeDecl, this.traverseCtx);
        this.processElementText((SchemaObject)typeDecl);
        this.processElementContents((SchemaObject)typeDecl, this.traverseCtx);
    }

    public void processElement(XSDElementDeclaration elem, ElementContentTraversalContext traverseCtx, XSDSchema schema) throws SchemaProcessingException {
        String name = elem.getName();
        String namespace = elem.getTargetNamespace();
        String fileName = SchemaUtil.shortenFileName((String)schema.getSchemaLocation());
        XSDElementDeclaration refElem = this.resolveElementRef(elem, traverseCtx);
        if (name == null) {
            if (refElem != elem) {
                this.processElement(refElem, traverseCtx, schema);
                return;
            }
            ModelGeneratorWsdlPlugin.Util.log(2, ModelGeneratorWsdlPlugin.Util.getString("SOAPSchemaProcessor.processElementWarning", new Object[0]));
            return;
        }
        if (refElem != null) {
            // empty if block
        }
        XSDTypeDefinition type = this.resolveElementType(elem, traverseCtx);
        QName qname = SchemaUtil.getQName((String)namespace, (String)name);
        Map tablesForName = traverseCtx.getElementsByNameThenType((Object)qname);
        SchemaObject element = (SchemaObject)tablesForName.get(type);
        boolean isSoapType = false;
        if (element == null) {
            element = new ElementImpl(elem, this.getNameSpacePrefix(elem.getTargetNamespace()), type, schema);
            element.setFileName(fileName);
            tablesForName.put(type, element);
            this.addElement(element);
            this.processAttributes(element, traverseCtx);
            this.processElementText(element);
            this.processElementContents(element, traverseCtx);
        }
        int minOccurs = traverseCtx.calculateMinOccurs(1);
        int maxOccurs = traverseCtx.calculateMaxOccurs(1);
        if (isSoapType) {
            element.addParent(traverseCtx.getParentTable(), minOccurs, -1);
        } else {
            element.addParent(traverseCtx.getParentTable(), minOccurs, maxOccurs);
        }
    }
}

