/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.exchange.Header;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.values.CamelHeaderValue;
import org.fusesource.ide.launcher.debug.model.variables.CamelHeaderVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelHeadersVariable;

public class CamelHeadersValue
extends BaseCamelValue {
    private CamelHeadersVariable parent;
    private ArrayList<IVariable> fVariables = new ArrayList();
    private ArrayList<Header> headers;
    private CamelDebugTarget debugTarget;

    public CamelHeadersValue(CamelDebugTarget debugTarget, ArrayList<Header> headers, Class type, CamelHeadersVariable parent) {
        super(debugTarget, "" + headers.hashCode(), type);
        this.parent = parent;
        this.debugTarget = debugTarget;
        this.headers = headers;
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        try {
            this.initHeaders();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void initHeaders() throws DebugException {
        CamelHeaderVariable var = null;
        CamelHeaderValue val = null;
        for (Header h : this.headers) {
            var = new CamelHeaderVariable(this.debugTarget, h.getKey(), String.class, this.parent);
            val = new CamelHeaderValue(this.fTarget, h, var.getReferenceType());
            var.setValue(val);
            this.fVariables.add(var);
        }
    }

    public void addHeader(String key, String value) {
        try {
            try {
                this.debugTarget.getDebugger().setMessageHeaderOnBreakpoint(this.debugTarget.getSuspendedNodeId(), key, value);
                CamelHeaderVariable newVar = new CamelHeaderVariable(this.debugTarget, key, String.class, this.parent);
                CamelHeaderValue newVal = new CamelHeaderValue(this.debugTarget, new Header(key, value, String.class.getName()), String.class);
                newVar.setValue(newVal);
                newVar.markChanged();
                this.fVariables.add(newVar);
            }
            catch (DebugException ex) {
                Activator.getLogger().error((Throwable)ex);
                this.fireCreationEvent();
            }
        }
        finally {
            this.fireCreationEvent();
        }
    }

    public void deleteHeader(String key) {
        try {
            try {
                IVariable v = null;
                this.debugTarget.getDebugger().removeMessageHeaderOnBreakpoint(this.debugTarget.getSuspendedNodeId(), key);
                for (IVariable var : this.fVariables) {
                    if (!((CamelHeaderValue)var.getValue()).getHeader().getKey().equals(key)) continue;
                    v = var;
                    break;
                }
                this.fVariables.remove(v);
            }
            catch (DebugException ex) {
                Activator.getLogger().error((Throwable)ex);
                this.fireChangeEvent(512);
            }
        }
        finally {
            this.fireChangeEvent(512);
        }
    }

    @Override
    public boolean hasVariables() throws DebugException {
        return this.fVariables.size() > 0;
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    @Override
    protected String getVariableDisplayString() {
        return "MessageHeaders";
    }

    @Override
    public String getValueString() throws DebugException {
        StringBuffer sb = new StringBuffer();
        for (IVariable v : this.fVariables) {
            sb.append(v.toString());
            sb.append("\n");
        }
        return sb.toString();
    }
}

