/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.BaseElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class DefinitionsValidator
extends AbstractBpmn2ElementValidator<Definitions> {
    public DefinitionsValidator(AbstractBpmn2ElementValidator<?> other) {
        super(other);
    }

    public DefinitionsValidator(IValidationContext ctx) {
        super(ctx);
    }

    @Override
    public IStatus validate(Definitions object) {
        if (object.getTargetNamespace() == null || object.getTargetNamespace().isEmpty()) {
            this.addStatus((EObject)object, 4, Messages.DefinitionsValidator_No_TargetNamespace, new Object[0]);
        }
        for (Import elem : object.getImports()) {
            if (DefinitionsValidator.isEmpty(elem.getLocation())) {
                this.addMissingFeatureStatus((EObject)elem, "location", 4);
            }
            if (DefinitionsValidator.isEmpty(elem.getNamespace())) {
                this.addMissingFeatureStatus((EObject)elem, "namespace", 4);
            }
            if (!DefinitionsValidator.isEmpty(elem.getImportType())) continue;
            this.addMissingFeatureStatus((EObject)elem, "importType", 4);
        }
        if (this.isLiveValidation()) {
            TreeIterator iter = object.eAllContents();
            while (iter.hasNext()) {
                EObject o = (EObject)iter.next();
                if (!(o instanceof BaseElement)) continue;
                this.addStatus(new BaseElementValidator((AbstractBpmn2ElementValidator)this).validate((BaseElement)o));
            }
        }
        return this.getResult();
    }

    @Override
    public boolean doLiveValidation() {
        return true;
    }
}

