/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.AbstractConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.AutomaticConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.IConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ManhattanConnectionRouter;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.AnchorType;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.impl.AbstractAddShapeFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class DefaultConnectionRouter
extends AbstractConnectionRouter {
    protected List<ContainerShape> allShapes;
    protected Connection connection = null;
    protected Shape source;
    protected Shape target;
    protected FixPointAnchor sourceAnchor;
    protected FixPointAnchor targetAnchor;

    public DefaultConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    public static IConnectionRouter getRouter(IFeatureProvider fp, Connection connection) {
        ShapeStyle ss;
        BendpointConnectionRouter router = null;
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
        if (be != null && (ss = ShapeStyle.getShapeStyle(be)) != null) {
            if (ss.getRoutingStyle() == ShapeStyle.RoutingStyle.MANHATTAN) {
                router = new ManhattanConnectionRouter(fp);
            } else if (ss.getRoutingStyle() == ShapeStyle.RoutingStyle.MANUAL) {
                router = new BendpointConnectionRouter(fp);
            } else if (ss.getRoutingStyle() == ShapeStyle.RoutingStyle.AUTOMATIC) {
                router = new AutomaticConnectionRouter(fp);
            }
        }
        if (router == null) {
            router = new BendpointConnectionRouter(fp);
        }
        return router;
    }

    @Override
    public boolean canRoute(Connection connection) {
        AnchorContainer ac = AnchorUtil.getAnchorContainer(connection.getStart());
        if (AnchorType.getType(ac) == AnchorType.MESSAGELINK) {
            return false;
        }
        ac = AnchorUtil.getAnchorContainer(connection.getEnd());
        return AnchorType.getType(ac) != AnchorType.MESSAGELINK;
    }

    @Override
    public boolean routingNeeded(Connection connection) {
        return this.connection == null;
    }

    @Override
    protected void initialize(Connection connection) {
        if (this.connection != connection) {
            this.connection = connection;
            this.sourceAnchor = (FixPointAnchor)connection.getStart();
            this.targetAnchor = (FixPointAnchor)connection.getEnd();
            this.source = (Shape)AnchorUtil.getAnchorContainer((Anchor)this.sourceAnchor);
            this.target = (Shape)AnchorUtil.getAnchorContainer((Anchor)this.targetAnchor);
        }
    }

    @Override
    public boolean route(Connection connection) {
        return false;
    }

    @Override
    public void dispose() {
        DefaultConnectionRouter.removeRoutingInfo(this.connection);
    }

    protected boolean isSelfConnection() {
        return this.source == this.target;
    }

    /*
     * WARNING - void declaration
     */
    protected List<ContainerShape> findAllShapes() {
        if (this.allShapes != null) {
            return this.allShapes;
        }
        this.allShapes = new ArrayList<ContainerShape>();
        Diagram diagram = this.fp.getDiagramTypeProvider().getDiagram();
        ArrayList<ContainerShape> ancestors = new ArrayList<ContainerShape>();
        ArrayList<ContainerShape> shapes = new ArrayList<ContainerShape>();
        TreeIterator iter = diagram.eAllContents();
        while (iter.hasNext()) {
            void var9_17;
            void var9_14;
            ContainerShape shape;
            BPMNShape bpmnShape;
            EObject o = (EObject)iter.next();
            if (!(o instanceof ContainerShape) || o instanceof Diagram || (bpmnShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)(shape = (ContainerShape)o), BPMNShape.class)) == null || FeatureSupport.isGroupShape((PictogramElement)shape) || FeatureSupport.isLabelShape((PictogramElement)shape)) continue;
            boolean ignore = false;
            EObject eObject = this.source.eContainer();
            while (var9_14 != null) {
                if (var9_14 instanceof ContainerShape && shape == var9_14) {
                    ancestors.add((ContainerShape)var9_14);
                    ignore = true;
                    break;
                }
                EObject eObject2 = var9_14.eContainer();
            }
            if (ignore) continue;
            EObject eObject3 = this.target.eContainer();
            while (var9_17 != null) {
                if (var9_17 instanceof ContainerShape && shape == var9_17) {
                    ancestors.add((ContainerShape)var9_17);
                    ignore = true;
                    break;
                }
                EObject eObject4 = var9_17.eContainer();
            }
            if (ignore || shapes.contains(shape)) continue;
            shapes.add(shape);
        }
        for (ContainerShape shape : shapes) {
            if (ancestors.contains(shape)) continue;
            boolean ignore = false;
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)shape);
            if (be instanceof Lane) {
                void var9_21;
                EObject eObject = shape.eContainer();
                while (!(var9_21 instanceof Diagram)) {
                    if (ancestors.contains(var9_21)) {
                        ignore = true;
                        break;
                    }
                    EObject eObject5 = var9_21.eContainer();
                }
            }
            if (be instanceof Lane || be instanceof Participant) {
                for (ContainerShape containerShape : ancestors) {
                    if (!GraphicsUtil.intersects((Shape)shape, (Shape)containerShape)) continue;
                    ignore = true;
                    break;
                }
            }
            if (ignore) continue;
            this.allShapes.add(shape);
        }
        GraphicsUtil.dump("All Shapes: ", this.allShapes);
        return this.allShapes;
    }

    protected GraphicsUtil.LineSegment getCollisionEdge(Point p1, Point p2) {
        ContainerShape shape = this.getCollision(p1, p2);
        if (shape != null) {
            return GraphicsUtil.findNearestEdge((Shape)shape, p1);
        }
        return null;
    }

    protected ContainerShape getCollision(Point p1, Point p2) {
        List<ContainerShape> collisions = this.findCollisions(p1, p2);
        if (collisions.size() == 0) {
            return null;
        }
        if (collisions.size() == 1) {
            return collisions.get(0);
        }
        this.sortCollisions(collisions, p2);
        return collisions.get(0);
    }

    protected List<ContainerShape> findCollisions(Point p1, Point p2) {
        ArrayList<ContainerShape> collisions = new ArrayList<ContainerShape>();
        if (this.allShapes == null) {
            this.findAllShapes();
        }
        for (ContainerShape shape : this.allShapes) {
            if (!GraphicsUtil.intersectsLine((Shape)shape, p1, p2)) continue;
            collisions.add(shape);
        }
        return collisions;
    }

    protected void sortCollisions(List<ContainerShape> collisions, final Point p) {
        Collections.sort(collisions, new Comparator<ContainerShape>(){

            @Override
            public int compare(ContainerShape s1, ContainerShape s2) {
                GraphicsUtil.LineSegment seg1 = GraphicsUtil.findNearestEdge((Shape)s1, p);
                double d1 = seg1.getDistance(p);
                GraphicsUtil.LineSegment seg2 = GraphicsUtil.findNearestEdge((Shape)s2, p);
                double d2 = seg2.getDistance(p);
                return (int)(d2 - d1);
            }
        });
    }

    protected List<Connection> findCrossings(Connection connection, Point start, Point end) {
        ArrayList<Connection> crossings = new ArrayList<Connection>();
        EList allConnections = this.fp.getDiagramTypeProvider().getDiagram().getConnections();
        List<FixPointAnchor> connectionAnchors = AnchorUtil.getAnchors((AnchorContainer)connection);
        for (Connection c : allConnections) {
            if (Graphiti.getPeService().getProperty((PropertyContainer)c, "ROUTING_NET_CONNECTION") != null || connectionAnchors.contains(c.getStart()) || connectionAnchors.contains(c.getEnd())) continue;
            Point p1 = GraphicsUtil.createPoint(c.getStart());
            Point p3 = GraphicsUtil.createPoint(c.getEnd());
            if (c instanceof FreeFormConnection) {
                FreeFormConnection ffc = (FreeFormConnection)c;
                Point p2 = p1;
                for (Point p : ffc.getBendpoints()) {
                    if (GraphicsUtil.intersects(start, end, p1, p)) {
                        crossings.add(c);
                        break;
                    }
                    p2 = p1 = p;
                }
                if (!GraphicsUtil.intersects(start, end, p2, p3)) continue;
                crossings.add(c);
                continue;
            }
            if (!GraphicsUtil.intersects(start, end, p1, p3)) continue;
            crossings.add(c);
        }
        return crossings;
    }

    protected static double length(Point p1, Point p2) {
        return GraphicsUtil.getLength(p1, p2);
    }

    protected void drawConnectionRoutes(List<ConnectionRoute> allRoutes) {
        if (GraphicsUtil.debug) {
            DeleteRoutingConnectionFeature deleteFeature = new DeleteRoutingConnectionFeature(this.fp);
            deleteFeature.delete();
            this.fp.getDiagramTypeProvider().getDiagram();
            int i = 0;
            while (i < allRoutes.size()) {
                ConnectionRoute r = allRoutes.get(i);
                GraphicsUtil.dump(r.toString());
                ++i;
            }
        }
    }

    protected class AddRoutingConnectionFeature
    extends AbstractAddShapeFeature {
        public static final String CONNECTION = "ROUTING_NET_CONNECTION";

        public AddRoutingConnectionFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canAdd(IAddContext ac) {
            return true;
        }

        public PictogramElement add(IAddContext ac) {
            IAddConnectionContext context = (IAddConnectionContext)ac;
            Anchor sourceAnchor = context.getSourceAnchor();
            Anchor targetAnchor = context.getTargetAnchor();
            ConnectionRoute route = (ConnectionRoute)context.getNewObject();
            Diagram diagram = this.getDiagram();
            FreeFormConnection connection = peService.createFreeFormConnection(diagram);
            connection.setStart(sourceAnchor);
            connection.setEnd(targetAnchor);
            int i = 1;
            while (i < route.size() - 1) {
                connection.getBendpoints().add((Object)route.get(i));
                ++i;
            }
            peService.setPropertyValue((PropertyContainer)connection, CONNECTION, "" + route.getId());
            Polyline connectionLine = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)connection);
            connectionLine.setLineWidth(Integer.valueOf(1));
            connectionLine.setLineStyle(LineStyle.DASH);
            ColorConstant foreground = new ColorConstant(255, 120, 255);
            int w = 3;
            int l = 15;
            ConnectionDecorator decorator = peService.createConnectionDecorator((Connection)connection, false, 1.0, true);
            int[] nArray = new int[8];
            nArray[0] = -l;
            nArray[1] = w;
            nArray[4] = -l;
            nArray[5] = -w;
            nArray[6] = -l;
            nArray[7] = w;
            Polygon arrowhead = gaService.createPolygon((GraphicsAlgorithmContainer)decorator, nArray);
            arrowhead.setForeground(gaService.manageColor(diagram, (IColorConstant)foreground));
            connectionLine.setForeground(gaService.manageColor(diagram, (IColorConstant)foreground));
            FeatureSupport.setToolTip(connection.getGraphicsAlgorithm(), route.toString());
            return connection;
        }
    }

    protected class DeleteRoutingConnectionFeature
    extends DefaultDeleteFeature {
        public DeleteRoutingConnectionFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canDelete(IDeleteContext context) {
            return true;
        }

        public void delete() {
            this.delete(null);
        }

        public void delete(IDeleteContext context) {
            ArrayList deleted = new ArrayList();
            deleted.addAll(this.getDiagram().getConnections());
            for (Connection connection : deleted) {
                if (Graphiti.getPeService().getProperty((PropertyContainer)connection, "ROUTING_NET_CONNECTION") == null) continue;
                context = new DeleteContext((PictogramElement)connection);
                super.delete(context);
            }
        }
    }
}

