/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBException;
import org.apache.camel.api.management.mbean.BacklogTracerEventMessage;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.jmx.commons.messages.Exchange;
import org.fusesource.ide.jmx.commons.messages.Exchanges;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.messages.INodeStatistics;
import org.fusesource.ide.jmx.commons.messages.ITraceExchangeList;
import org.fusesource.ide.jmx.commons.messages.NodeStatistics;
import org.xml.sax.SAXException;

public class TraceExchangeList
implements ITraceExchangeList {
    private Map<String, ExchangeStepList> stepListMap = new HashMap<String, ExchangeStepList>();
    private Map<String, NodeStatistics> nodeStatMap = new HashMap<String, NodeStatistics>();
    private List<ExchangeStepList> stepLists = new ArrayList<ExchangeStepList>();
    private List<IExchange> exchangeList = new ArrayList<IExchange>();
    private Map<IExchange, Long> uuidSet = new LinkedHashMap<IExchange, Long>();
    private final AtomicInteger counter = new AtomicInteger();

    public List<IExchange> getExchangeList() {
        return this.exchangeList;
    }

    public void addBackLogTraceMessages(List<BacklogTracerEventMessage> traceMessages) throws JAXBException, SAXException {
        for (BacklogTracerEventMessage traceMessage : traceMessages) {
            String exchangeId = traceMessage.getExchangeId();
            ExchangeStepList stepList = this.stepListMap.get(exchangeId);
            if (stepList == null) {
                stepList = new ExchangeStepList(exchangeId);
                this.stepLists.add(stepList);
                this.stepListMap.put(exchangeId, stepList);
            }
            IExchange exchange = stepList.addExchange(traceMessage);
            String toNode = traceMessage.getToNode();
            if (exchange == null || toNode == null) continue;
            INodeStatistics nodeStats = this.getNodeStats(toNode);
            nodeStats.addExchange(exchange);
        }
        this.refreshExchangeList(this.stepLists);
    }

    public void addFabricTraceMessages(List<BacklogTracerEventMessage> traceMessages) throws JAXBException, SAXException {
        for (BacklogTracerEventMessage traceMessage : traceMessages) {
            String exchangeId = traceMessage.getExchangeId();
            ExchangeStepList stepList = this.stepListMap.get(exchangeId);
            if (stepList == null) {
                stepList = new ExchangeStepList(exchangeId);
                this.stepLists.add(stepList);
                this.stepListMap.put(exchangeId, stepList);
            }
            IExchange exchange = stepList.addExchange(traceMessage);
            String toNode = traceMessage.getToNode();
            if (exchange == null || toNode == null) continue;
            INodeStatistics nodeStats = this.getNodeStats(toNode);
            nodeStats.addExchange(exchange);
        }
        this.refreshExchangeList(this.stepLists);
    }

    private void refreshExchangeList(List<ExchangeStepList> stepLists) {
        ArrayList<IExchange> temp = new ArrayList<IExchange>();
        for (ExchangeStepList stepList : stepLists) {
            temp.addAll(stepList.getExchangeList());
        }
        Collections.sort(temp);
        for (IExchange ie : temp) {
            Exchange exchange;
            if (!(ie instanceof Exchange) || (exchange = (Exchange)ie).getExchangeIndex() != null) continue;
            ie.getIn().setExchangeIndex(Integer.valueOf(this.counter.incrementAndGet()));
        }
        this.exchangeList.clear();
        this.exchangeList.addAll(temp);
    }

    public INodeStatistics getNodeStats(String toNode) {
        NodeStatistics nodeStats = this.nodeStatMap.get(toNode);
        if (nodeStats == null) {
            nodeStats = new NodeStatistics();
            this.nodeStatMap.put(toNode, nodeStats);
        }
        return nodeStats;
    }

    public class ExchangeStepList {
        private final String exchangeId;
        private List<IExchange> exchangeList = new ArrayList<IExchange>();
        private Long firstExchangeTimeMs;
        private long lastTime;

        public ExchangeStepList(String exchangeId) {
            this.exchangeId = exchangeId;
        }

        public List<IExchange> getExchangeList() {
            return this.exchangeList;
        }

        public IExchange addExchange(BacklogTracerEventMessage traceMessage) throws JAXBException, SAXException {
            IExchange answer = this.createExchange(traceMessage);
            if (answer != null) {
                this.exchangeList.add(answer);
            }
            TraceExchangeList.this.uuidSet.put(answer, traceMessage.getUid());
            return answer;
        }

        public IExchange createExchange(BacklogTracerEventMessage traceMessage) throws JAXBException, SAXException {
            String xml = traceMessage.getMessageAsXml();
            Exchange exchange = null;
            if (!Strings.isBlank((String)xml)) {
                exchange = Exchanges.unmarshalNoNamespaceXmlString((String)xml);
            }
            if (exchange == null) {
                exchange = new Exchange();
            }
            IMessage in = exchange.getIn();
            in.setToNode(traceMessage.getToNode());
            in.setUuid(Long.valueOf(traceMessage.getUid()));
            Date timestamp = traceMessage.getTimestamp();
            if (timestamp != null) {
                in.setTimestamp(timestamp);
                long time = timestamp.getTime();
                long relative = 0L;
                boolean first = false;
                if (this.firstExchangeTimeMs == null) {
                    this.firstExchangeTimeMs = time;
                    first = true;
                } else {
                    relative = time - this.firstExchangeTimeMs;
                }
                long elapsed = relative - this.lastTime;
                this.lastTime = relative;
                in.setRelativeTime(Long.valueOf(relative));
                if (!first) {
                    in.setElapsedTime(Long.valueOf(elapsed));
                }
            }
            exchange.setId(traceMessage.getExchangeId());
            return exchange;
        }
    }
}

