/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import io.fabric8.camel.facade.CamelFacade;
import io.fabric8.camel.facade.mbean.CamelContextMBean;
import io.fabric8.camel.facade.mbean.CamelEndpointMBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.commons.util.URIs;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.Messages;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.EndpointNode;
import org.fusesource.ide.jmx.camel.navigator.EndpointSchemeNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class EndpointsNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final CamelContextNode camelContextNode;
    private Map<String, EndpointSchemeNode> schemeNodes = new HashMap<String, EndpointSchemeNode>();

    public EndpointsNode(CamelContextNode camelContextNode) {
        super((Node)camelContextNode);
        this.camelContextNode = camelContextNode;
    }

    public CamelContextNode getCamelContextNode() {
        return this.camelContextNode;
    }

    public CamelFacade getFacade() {
        return this.getCamelContextNode().getFacade();
    }

    public String toString() {
        return "Endpoints";
    }

    public Image getImage() {
        return CamelJMXPlugin.getDefault().getImage("endpoint_folder.png");
    }

    public void clearChildren() {
        Collection<EndpointSchemeNode> nodes = this.schemeNodes.values();
        for (EndpointSchemeNode schemeNode : nodes) {
            schemeNode.clearChildren();
        }
    }

    protected void refreshUI() {
        super.refreshUI();
        Collection<EndpointSchemeNode> values = this.schemeNodes.values();
        RefreshableUI ui = this.getRefreshableUI();
        if (ui != null) {
            for (EndpointSchemeNode schemeNode : values) {
                ui.fireRefresh((Object)schemeNode, false);
            }
        }
    }

    public void provideContextMenu(IMenuManager menu) {
        this.addCreateEndpointAction(menu, "");
    }

    protected void addCreateEndpointAction(IMenuManager menu, final String defaultEndpointName) {
        Action createEndpointAction = new Action(Messages.CreateEndpointAction, 32){

            public void run() {
                EndpointsNode.this.showCreateEndpointDialog(defaultEndpointName);
            }
        };
        createEndpointAction.setToolTipText(Messages.CreateEndpointActionToolTip);
        createEndpointAction.setImageDescriptor(CamelJMXPlugin.getDefault().getImageDescriptor("new_queue.png"));
        menu.add((IAction)createEndpointAction);
    }

    protected void showCreateEndpointDialog(String defaultEndpointName) {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.CreateEndpointDialogTitle, Messages.CreateEndpointDialogMessage, defaultEndpointName, null);
        int result = dialog.open();
        if (result == 0) {
            String endpoint = dialog.getValue();
            this.createEndpoint(endpoint);
        }
    }

    protected void createEndpoint(String uri) {
        if (!Strings.isBlank((String)uri)) {
            try {
                CamelContextMBean mbean = this.getCamelContextNode().getCamelContextMBean();
                mbean.createEndpoint(uri);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        EndpointsNode.this.refresh();
                    }
                });
            }
            catch (Exception e) {
                CamelJMXPlugin.showUserError("Failed to create Endpoint", "Failed to create endpoint: " + uri, e);
            }
        }
    }

    protected void loadChildren() {
        try {
            List endpoints = this.camelContextNode.getFacade().getEndpoints(this.camelContextNode.getManagementName());
            for (CamelEndpointMBean endpointMBean : endpoints) {
                String uri = endpointMBean.getEndpointUri();
                String scheme = URIs.getScheme((String)uri);
                EndpointSchemeNode schemeEndpoint = this.getEndpointScheme(scheme);
                EndpointNode endpoint = new EndpointNode(schemeEndpoint, endpointMBean);
                schemeEndpoint.addChild((Node)endpoint);
            }
        }
        catch (Exception e) {
            CamelJMXPlugin.getLogger().warning("Failed to load endpoints for " + (Object)((Object)this.camelContextNode) + ". " + e, (Throwable)e);
        }
    }

    protected EndpointSchemeNode getEndpointScheme(String scheme) {
        EndpointSchemeNode answer = this.schemeNodes.get(scheme);
        if (answer == null) {
            answer = new EndpointSchemeNode(this, scheme);
            this.addChild((Node)answer);
            this.schemeNodes.put(scheme, answer);
        }
        return answer;
    }
}

