/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.fusesource.ide.commons.ui.drop.DropHandler;
import org.fusesource.ide.jmx.camel.navigator.EndpointNode;

public class CamelMessageDropAssistant
extends CommonDropAdapterAssistant {
    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (target != null && target instanceof EndpointNode) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (aTarget != null && aTarget instanceof EndpointNode) {
            EndpointNode node = (EndpointNode)((Object)aTarget);
            Object data = aDropTargetEvent.data;
            if (this.isSupported(data)) {
                DropHandler dh = node.createDropHandler(aDropTargetEvent);
                dh.drop(aDropTargetEvent);
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    protected boolean isSupported(Object data) {
        if (data != null) {
            if (data instanceof TreeSelection) {
                TreeSelection sel = (TreeSelection)data;
                Object selItem = sel.getFirstElement();
                return this.isSupported(selItem);
            }
            if (data instanceof IFile) {
                return true;
            }
            System.err.println("[CamelMessageDropAssistant] Unsupported transfer type: " + data.getClass().getName());
        }
        return false;
    }
}

