/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.builder.execution.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ObjectExtension;
import org.teiid.designer.core.XsdObjectExtension;
import org.teiid.designer.metamodels.builder.execution.MetamodelBuilderConstants;
import org.teiid.designer.metamodels.builder.util.MetaClassUriHelper;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.core.extension.ExtensionFactory;
import org.teiid.designer.metamodels.core.extension.XClass;
import org.teiid.designer.metamodels.core.extension.XPackage;
import org.teiid.designer.metamodels.core.extension.impl.ExtensionFactoryImpl;

public class MetamodelBuilderUtil
implements MetamodelBuilderConstants {
    private static final HashMap DT_CACHE = new HashMap();
    private static XSDSchema GLOBAL_XSD;
    private static final String I18N_PREFIX;

    static {
        I18N_PREFIX = I18nUtil.getPropertyPrefix(MetamodelBuilderUtil.class);
    }

    private static String getString(String id) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, Object param1) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, param1);
    }

    private static String getString(String id, Object param1, Object param2) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[]{param1, param2});
    }

    public static Object findChild(String name, Object parent, String metaClassUri) {
        if (name == null || parent == null) {
            return null;
        }
        String eClassName = metaClassUri == null ? null : MetaClassUriHelper.getEClassName((String)metaClassUri);
        List children = Collections.EMPTY_LIST;
        if (parent instanceof Resource) {
            children = ((Resource)parent).getContents();
        } else if (parent instanceof EObject) {
            children = ((EObject)parent).eContents();
        }
        for (EObject next : children) {
            String nextName = MetamodelBuilderUtil.getName(next);
            if (!name.equals(nextName)) continue;
            if (metaClassUri == null) {
                return next;
            }
            if (!next.eClass().getName().equals(eClassName)) continue;
            return next;
        }
        return null;
    }

    public static String getName(EObject entity) {
        if (entity == null) {
            return null;
        }
        EStructuralFeature feature = entity.eClass().getEStructuralFeature("name");
        if (feature != null) {
            return (String)entity.eGet(feature);
        }
        return entity.eClass().getName();
    }

    public static EObject getExtension(EObject eObject, MultiStatus status) throws ModelerCoreException {
        CoreArgCheck.isNotNull((Object)eObject);
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        if (EcorePackage.eINSTANCE.equals(ePackage)) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        if (resource instanceof XSDResourceImpl) {
            XClass xclass;
            XPackage extPackage;
            XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
            XSDSchema xsdSchema = xsdResource.getSchema();
            if (xsdSchema != null && (extPackage = XsdObjectExtension.getExtensionPackage((XSDSchema)xsdSchema)) != null && (xclass = extPackage.findXClass(eClass)) != null) {
                XsdObjectExtension result = null;
                try {
                    XPackage pkg = extPackage;
                    ExtensionFactoryImpl factory = null;
                    EFactory existingFactory = pkg.getEFactoryInstance();
                    if (existingFactory == null || !(existingFactory instanceof ExtensionFactory)) {
                        factory = new ExtensionFactoryImpl();
                        factory.setEPackage((EPackage)extPackage);
                    }
                    result = new XsdObjectExtension(eObject, xclass, null);
                }
                catch (Throwable e) {
                    String msg = MetamodelBuilderUtil.getString("extensionErr");
                    MetamodelBuilderUtil.addStatus(status, 4, msg, e);
                }
                return result;
            }
        } else {
            XClass xclass;
            XPackage extPackage;
            ModelAnnotation model = MetamodelBuilderUtil.getModelAnnotation(resource);
            if (model != null && (extPackage = model.getExtensionPackage()) != null && (xclass = extPackage.findXClass(eClass)) != null) {
                ObjectExtension result = null;
                try {
                    XPackage pkg = extPackage;
                    ExtensionFactoryImpl factory = null;
                    EFactory existingFactory = pkg.getEFactoryInstance();
                    if (existingFactory == null || !(existingFactory instanceof ExtensionFactory)) {
                        factory = new ExtensionFactoryImpl();
                        factory.setEPackage((EPackage)extPackage);
                    }
                    result = new ObjectExtension(eObject, xclass);
                }
                catch (Throwable e) {
                    String msg = MetamodelBuilderUtil.getString("extensionErr");
                    MetamodelBuilderUtil.addStatus(status, 4, msg, e);
                }
                return result;
            }
        }
        return null;
    }

    public static Object findEObjectByPath(ResourceSet resources, String path, String metaClassUri, MultiStatus status) {
        Object currentParent = null;
        StringTokenizer pathTokens = new StringTokenizer(path, "\\");
        boolean failed = false;
        while (pathTokens.hasMoreTokens() && !failed) {
            if (currentParent == null) {
                currentParent = MetamodelBuilderUtil.findResource(resources, pathTokens.nextToken());
                if (currentParent != null) continue;
                failed = true;
                continue;
            }
            String name = pathTokens.nextToken();
            currentParent = pathTokens.hasMoreTokens() ? MetamodelBuilderUtil.findChild(name, currentParent, null) : MetamodelBuilderUtil.findChild(name, currentParent, metaClassUri);
            if (currentParent != null) continue;
            failed = true;
        }
        if (currentParent == null) {
            if (path.startsWith("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance#") || path.startsWith("http://www.w3.org/2001/XMLSchema#")) {
                currentParent = MetamodelBuilderUtil.getInternalObjectByUri(resources, path, status);
            } else if (path.startsWith("http://www.metamatrix.com/metamodels/") || path.startsWith("http://www.eclipse.org/emf/2002/Ecore#//")) {
                currentParent = MetamodelBuilderUtil.getEClassForUri(path, status);
            }
        }
        return currentParent;
    }

    public static Resource findResource(ResourceSet resources, String path) {
        StringTokenizer pathTokens = new StringTokenizer(path, "\\");
        String modelName = String.valueOf(pathTokens.nextToken()) + ".xmi";
        for (Resource rsrc : resources.getResources()) {
            if (!rsrc.getURI().lastSegment().equals(modelName)) continue;
            return rsrc;
        }
        return null;
    }

    public static ModelAnnotation getModelAnnotation(Resource eResource) {
        if (eResource == null) {
            return null;
        }
        ModelAnnotation annot = null;
        for (EObject root : eResource.getContents()) {
            if (!(root instanceof ModelAnnotation)) continue;
            annot = (ModelAnnotation)root;
            break;
        }
        return annot;
    }

    public static int getModelType(Resource rsr) {
        ModelAnnotation ma = MetamodelBuilderUtil.getModelAnnotation(rsr);
        if (ma != null) {
            String pmu = ma.getPrimaryMetamodelUri();
            if ("http://www.metamatrix.com/metamodels/Relational".equals(pmu)) {
                return 1;
            }
            if (ma.getModelType() == ModelType.EXTENSION_LITERAL) {
                return 2;
            }
        }
        return -1;
    }

    public static AnnotationContainer getAnnotationContainer(Resource eResource) {
        if (eResource == null) {
            return null;
        }
        for (EObject root : eResource.getContents()) {
            if (!(root instanceof AnnotationContainer)) continue;
            return (AnnotationContainer)root;
        }
        return null;
    }

    public static EPackage getEPackageForUri(String ePkgUri, MultiStatus status) {
        EPackage ePkg = EPackage.Registry.INSTANCE.getEPackage(ePkgUri);
        if (ePkg == null) {
            String msg = MetamodelBuilderUtil.getString("noPkg", ePkgUri);
            MetamodelBuilderUtil.addStatus(status, 4, msg);
            return null;
        }
        return ePkg;
    }

    public static EClassifier getEClassForUri(String metaClassUri, MultiStatus status) {
        String ePkgUri = MetaClassUriHelper.getPackageUri((String)metaClassUri);
        String eClassName = MetaClassUriHelper.getEClassName((String)metaClassUri);
        EPackage ePkg = MetamodelBuilderUtil.getEPackageForUri(ePkgUri, status);
        if (ePkg == null) {
            return null;
        }
        EClassifier eClass = ePkg.getEClassifier(eClassName);
        if (eClass == null) {
            String msg = MetamodelBuilderUtil.getString("noEntity", eClassName, ePkgUri);
            MetamodelBuilderUtil.addStatus(status, 4, msg);
            return null;
        }
        return eClass;
    }

    public static Object getInternalObjectByUri(ResourceSet resources, String uri, MultiStatus status) {
        if (uri == null || uri.indexOf("#") == -1) {
            String msg = MetamodelBuilderUtil.getString("badInternalUri", uri);
            MetamodelBuilderUtil.addStatus(status, 4, msg);
            return null;
        }
        int index = uri.indexOf("#");
        String resourceUri = uri.substring(0, index);
        String entityName = uri.substring(index + 1);
        String mmName = "MM:" + entityName;
        String xsdName = "XSD:" + entityName;
        if (resourceUri == null || entityName == null) {
            String msg = MetamodelBuilderUtil.getString("badInternalUri", uri);
            MetamodelBuilderUtil.addStatus(status, 4, msg);
            return null;
        }
        Object result = DT_CACHE.get(entityName);
        if (result != null) {
            return result;
        }
        XSDSchema schema = null;
        boolean isMM = false;
        if (resourceUri.equals("http://www.w3.org/2001/XMLSchema")) {
            schema = MetamodelBuilderUtil.getGlobalXsd();
        } else if (resourceUri.equals("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance")) {
            isMM = true;
            URI dtURI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
            XSDResourceImpl dts = (XSDResourceImpl)resources.getResource(dtURI, false);
            if (dts != null && dts.isLoaded()) {
                schema = dts.getSchema();
            }
        }
        if (schema == null) {
            String msg = MetamodelBuilderUtil.getString("noSchema", uri);
            MetamodelBuilderUtil.addStatus(status, 4, msg);
            return null;
        }
        for (XSDTypeDefinition type : schema.getTypeDefinitions()) {
            if (!entityName.equals(type.getName())) continue;
            if (isMM) {
                DT_CACHE.put(mmName, type);
            } else {
                DT_CACHE.put(xsdName, type);
            }
            return type;
        }
        return null;
    }

    public static void addStatus(MultiStatus parent, int severity, String msg) {
        MetamodelBuilderUtil.addStatus(parent, severity, msg, null);
    }

    public static void addStatus(MultiStatus parent, int severity, String msg, Throwable err) {
        Status sts = new Status(severity, "org.teiid.designer.metamodels.builder.execution", 0, msg, err);
        parent.add((IStatus)sts);
    }

    private static XSDSchema getGlobalXsd() {
        if (GLOBAL_XSD == null) {
            GLOBAL_XSD = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        }
        return GLOBAL_XSD;
    }
}

