/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jbpm.convert.bpmnto.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

class ProjectFilter
extends ViewerFilter {
    private static String BPMN_FILE_EXT = "bpmn";

    ProjectFilter() {
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        IContainer container;
        IFile file;
        boolean res = false;
        if (element instanceof IFile && BPMN_FILE_EXT.equalsIgnoreCase((file = (IFile)element).getFileExtension())) {
            res = file.getProject().isAccessible();
        }
        if (element instanceof IContainer && (container = (IContainer)element).getProject().isAccessible()) {
            res = this.hasBPMNResources(container);
        }
        return res;
    }

    private boolean hasBPMNResources(IContainer container) {
        boolean res = false;
        try {
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IFile && BPMN_FILE_EXT.equalsIgnoreCase(((IFile)resources[i]).getFileExtension())) {
                    res = true;
                    break;
                }
                if (resources[i] instanceof IContainer && this.hasBPMNResources((IContainer)resources[i])) {
                    res = true;
                    break;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return res;
    }
}

