/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.io.File;
import org.fusesource.ide.imports.sap.JCo3Archive;
import org.fusesource.ide.imports.sap.SAPImportSettings;

public class JCo3ImportSettings
extends SAPImportSettings {
    public static final String JCO_ARCHIVE = "jcoArchive";
    public static final String ARCHIVE_OS = "archiveOs";
    public static final String JCO3_ARCHIVE_FILENAME = "jco3ArchiveFilename";
    private static final String FRAGMENT_HOST_BUNDLE_VERSION_PREFIX = ";bundle-version=\"";
    private static final String FRAGMENT_HOST_BUNDLE_VERSION_SUFFIX = "\"";
    private static final String BUNDLE_JCO_JAR_ENTRY = "sapjco3.jar";
    private static final String NATIVE_DIRECTORY_NAME = "jni";
    private static final String FRAGMENT_BUNDLE_NAME_SUFFIX = " - Native Library for ";
    private static final String JAR_EXTENTION = ".jar";
    private static final String UNDERSCORE = "_";
    private static final String PATH_SEPARATOR = "/";
    private String jco3ArchiveFilename;
    private String archiveOs;
    private JCo3Archive jco3Archive;

    public String getJco3ArchiveFilename() {
        return this.jco3ArchiveFilename;
    }

    public void setJco3ArchiveFilename(String archiveFilename) {
        this.jco3ArchiveFilename = archiveFilename;
        this.firePropertyChange(JCO3_ARCHIVE_FILENAME, this.jco3ArchiveFilename, this.jco3ArchiveFilename);
    }

    public String getArchiveOs() {
        return this.archiveOs;
    }

    public void setArchiveOs(String archiveOs) {
        this.archiveOs = archiveOs;
        this.firePropertyChange(ARCHIVE_OS, this.archiveOs, this.archiveOs);
    }

    public JCo3Archive getJco3Archive() {
        return this.jco3Archive;
    }

    public void setJco3Archive(JCo3Archive jcoArchive) {
        this.jco3Archive = jcoArchive;
        this.firePropertyChange(JCO_ARCHIVE, this.jco3Archive, this.jco3Archive);
        this.setArchiveOs(jcoArchive.getType().getDescription());
        this.setArchiveVersion(jcoArchive.getVersion());
        if (this.getBundleVersion() == null || this.getBundleVersion().length() == 0) {
            this.setBundleVersion(jcoArchive.getVersion());
        }
    }

    public String getBundleSymbolicName() {
        return this.jco3Archive.getBundleName();
    }

    public String getBundleFilename() {
        return String.valueOf(this.bundleDeployLocation) + File.separator + this.jco3Archive.getBundleName() + UNDERSCORE + this.bundleVersion + JAR_EXTENTION;
    }

    public String getFragmentFilename() {
        return String.valueOf(this.bundleDeployLocation) + File.separator + this.jco3Archive.getType().getFragmentName() + UNDERSCORE + this.bundleVersion + JAR_EXTENTION;
    }

    public String getFragmentBundleName() {
        return String.valueOf(this.bundleName) + FRAGMENT_BUNDLE_NAME_SUFFIX + this.jco3Archive.getType().getDescription();
    }

    public String getFragmentSymbolicName() {
        return this.jco3Archive.getType().getFragmentName();
    }

    public String getBundleNativeDirEntry() {
        return "jni/";
    }

    public String getBundleJCoJarEntry() {
        return BUNDLE_JCO_JAR_ENTRY;
    }

    public String getBundleNativeLibraryEntry() {
        return "jni/" + this.jco3Archive.getType().getNativeArchiveName();
    }

    public String getFragmentHost() {
        return String.valueOf(this.jco3Archive.getType().getPluginName()) + FRAGMENT_HOST_BUNDLE_VERSION_PREFIX + this.bundleVersion + FRAGMENT_HOST_BUNDLE_VERSION_SUFFIX;
    }

    public String getPlatformFilter() {
        return this.jco3Archive.getType().getPlatformFilter();
    }
}

