/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Platform;
import org.fusesource.ide.imports.sap.ImportUtils;
import org.fusesource.ide.imports.sap.JCo3ImportSettings;
import org.fusesource.ide.imports.sap.Messages;
import org.fusesource.ide.imports.sap.SAPArchive;

public class JCo3Archive
extends SAPArchive {
    private static final String SAPJCO_RELEASE_DELIMITER = ".";
    private static final String MANIFEST_LINE_DELIMITER = ":";
    public static final String PLUGIN_JCO = "com.sap.conn.jco";
    public static final String FRAGMENT_WINDOWS_32 = "com.sap.conn.jco.win32.x86";
    public static final String FRAGMENT_WINDOWS_64IA = "com.sap.conn.jco.win32.ia64";
    public static final String FRAGMENT_WINDOWS_64X86 = "com.sap.conn.jco.win32.x86_64";
    public static final String FRAGMENT_LINUX_32 = "com.sap.conn.jco.linux.x86";
    public static final String FRAGMENT_LINUX_64IA = "com.sap.conn.jco.linux.ia64";
    public static final String FRAGMENT_LINUX_64X86 = "com.sap.conn.jco.linux.x86_64";
    public static final String FRAGMENT_DARWIN_32 = "com.sap.conn.jco.osx.x86";
    public static final String FRAGMENT_DARWIN_64 = "com.sap.conn.jco.osx.x86_64";
    public static final String ECLIPSE_PLATFORM_FILTER = "Eclipse-PlatformFilter";
    public static final String BUNDLE_CLASS_PATH_VALUE = "bin/,\n sapjco3.jar,\n jni/";
    public static final String EXPORT_PACKAGE_VALUE = "com.sap.conn.jco, com.sap.conn.jco.ext, com.sap.conn.jco.monitor, com.sap.conn.jco.rt, com.sap.conn.jco.rt.json,  com.sap.conn.jco.server, com.sap.conn.jco.session, com.sap.conn.jco.support, com.sap.conn.jco.util";
    public static final String SAPJCO_RELEASE = "sapjco release";
    public static final String SAPJCO_PATCH_LEVEL = "sapjco patch level";
    public static final String SAPJCO_OS = "sapjco os";
    public static final String SAPJCO3_JAR = "sapjco3.jar";
    public static final String SAPJCOMANIFEST_MF = "sapjcomanifest.mf";
    protected byte[] buf = new byte[32768];
    protected String name;
    protected JCoArchiveType type;
    protected Map<String, String> manifest = new HashMap<String, String>();
    protected long lastModified;
    private String version;
    private byte[] sapjco3jar;
    private byte[] nativelib;

    public JCo3Archive(String filename) throws IOException {
        this.name = filename;
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            try {
                int numRead;
                File file = new File(filename);
                this.lastModified = file.lastModified();
                is = new FileInputStream(file);
                os = new ByteArrayOutputStream();
                while ((numRead = is.read(this.buf, 0, this.buf.length)) != -1) {
                    os.write(this.buf, 0, numRead);
                }
                this.readArchiveFile(filename, os.toByteArray());
                this.readArchiveType();
                this.readJCo3JarFile();
                this.readNativeLibraryFile();
            }
            catch (IOException e) {
                this.type = JCoArchiveType.JCO_INVALID_ARCHIVE;
                throw e;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public JCoArchiveType getType() {
        return this.type;
    }

    public Map<String, byte[]> getContents() {
        return this.contents;
    }

    public Map<String, String> getManifest() {
        return this.manifest;
    }

    public byte[] getJCo3JarFile() {
        return this.sapjco3jar;
    }

    public byte[] getNativeLibraryFile() {
        return this.nativelib;
    }

    public String getVersion() {
        if (this.version == null) {
            StringBuffer buf = new StringBuffer();
            String sapjcoRelease = this.manifest.get(SAPJCO_RELEASE).trim();
            String sapjcoPatchLevel = this.manifest.get(SAPJCO_PATCH_LEVEL).trim();
            if (sapjcoRelease != null && sapjcoRelease.length() > 0) {
                buf.append(sapjcoRelease);
                buf.append(SAPJCO_RELEASE_DELIMITER);
                buf.append(sapjcoPatchLevel);
                this.version = buf.toString();
            }
        }
        return this.version;
    }

    public String getBundleName() {
        return this.type.getPluginName();
    }

    public byte[] getSapjco3jar() {
        return this.sapjco3jar;
    }

    public byte[] getNativelib() {
        return this.nativelib;
    }

    public boolean supportsCurrentPlatform() {
        return Platform.getOS().equals(this.getType().getEclipseOS()) && Platform.getOSArch().equals(this.getType().getEclipseArch());
    }

    public void buildJCoPlugin(JCo3ImportSettings settings) throws IOException {
        InputStream is = null;
        ZipOutputStream target = null;
        byte[] buf = new byte[32768];
        try {
            try {
                int numRead;
                int numRead2;
                String bundleFilename = settings.getBundleFilename();
                target = new JarOutputStream(new FileOutputStream(bundleFilename));
                byte[] manifest = this.createBundleManifestFile(settings);
                JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
                manifestEntry.setTime(this.lastModified);
                ((JarOutputStream)target).putNextEntry(manifestEntry);
                is = new ByteArrayInputStream(manifest);
                while ((numRead2 = is.read(buf, 0, buf.length)) != -1) {
                    target.write(buf, 0, numRead2);
                }
                target.closeEntry();
                JarEntry nativeDirEntry = new JarEntry(settings.getBundleNativeDirEntry());
                nativeDirEntry.setTime(this.lastModified);
                ((JarOutputStream)target).putNextEntry(nativeDirEntry);
                JarEntry jco3JarEntry = new JarEntry(settings.getBundleJCoJarEntry());
                jco3JarEntry.setTime(this.lastModified);
                ((JarOutputStream)target).putNextEntry(jco3JarEntry);
                is = new ByteArrayInputStream(this.sapjco3jar);
                while ((numRead = is.read(buf, 0, buf.length)) != -1) {
                    target.write(buf, 0, numRead);
                }
                target.closeEntry();
            }
            catch (Exception e) {
                throw new IOException(Messages.JCo3Archive_FailedToBuildJCo3Plugin, e);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (target != null) {
                target.close();
            }
        }
    }

    public void buildJCoNativePlugin(JCo3ImportSettings settings) throws IOException {
        InputStream is = null;
        ZipOutputStream target = null;
        byte[] buf = new byte[32768];
        try {
            try {
                int numRead;
                int numRead2;
                String bundleFilename = settings.getFragmentFilename();
                target = new JarOutputStream(new FileOutputStream(bundleFilename));
                byte[] manifest = this.createFragmentManifestFile(settings);
                JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
                manifestEntry.setTime(this.lastModified);
                ((JarOutputStream)target).putNextEntry(manifestEntry);
                is = new ByteArrayInputStream(manifest);
                while ((numRead2 = is.read(buf, 0, buf.length)) != -1) {
                    target.write(buf, 0, numRead2);
                }
                target.closeEntry();
                JarEntry nativeDirEntry = new JarEntry(settings.getBundleNativeDirEntry());
                nativeDirEntry.setTime(this.lastModified);
                ((JarOutputStream)target).putNextEntry(nativeDirEntry);
                JarEntry jco3NativeLibEntry = new JarEntry(settings.getBundleNativeLibraryEntry());
                jco3NativeLibEntry.setTime(this.lastModified);
                ((JarOutputStream)target).putNextEntry(jco3NativeLibEntry);
                is = new ByteArrayInputStream(this.nativelib);
                while ((numRead = is.read(buf, 0, buf.length)) != -1) {
                    target.write(buf, 0, numRead);
                }
                target.closeEntry();
            }
            catch (Exception e) {
                throw new IOException(Messages.JCo3Archive_FailedToBuildJCo3PluginFragment, e);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (target != null) {
                target.close();
            }
        }
    }

    private void readArchiveType() throws IOException {
        byte[] file = (byte[])this.contents.get(SAPJCOMANIFEST_MF);
        if (file == null) {
            this.type = JCoArchiveType.JCO_INVALID_ARCHIVE;
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_FileMissingFromArchive, SAPJCOMANIFEST_MF));
        }
        try {
            this.manifest = this.parseManifest(file);
        }
        catch (IOException iOException) {
            this.type = JCoArchiveType.JCO_INVALID_ARCHIVE;
            throw new IOException(Messages.JCo3Archive_UnableToParseArchiveManifestFile);
        }
        String sapjcoos = this.manifest.get(SAPJCO_OS);
        if (sapjcoos == null) {
            this.type = JCoArchiveType.JCO_INVALID_ARCHIVE;
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_HeaderisMissingFromManifestFile, SAPJCO_OS));
        }
        this.type = JCoArchiveType.getType(sapjcoos);
        if (this.type == JCoArchiveType.JCO_INVALID_ARCHIVE) {
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_OSPlatformIsNotSupported, sapjcoos));
        }
    }

    private void readJCo3JarFile() throws IOException {
        byte[] sapjco3jar = (byte[])this.contents.get(SAPJCO3_JAR);
        if (sapjco3jar == null) {
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_FileMissingFromArchive, SAPJCO3_JAR));
        }
        this.sapjco3jar = sapjco3jar;
    }

    private void readNativeLibraryFile() throws IOException {
        byte[] nativelib = (byte[])this.contents.get(this.type.getNativeArchiveName());
        if (nativelib == null) {
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_FileMissingFromArchive, this.type.getNativeArchiveName()));
        }
        this.nativelib = nativelib;
    }

    private Map<String, String> parseManifest(byte[] file) throws IOException {
        String line;
        this.manifest.clear();
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(file)));
        while ((line = br.readLine()) != null) {
            String[] elements = line.split(MANIFEST_LINE_DELIMITER);
            if (elements.length < 2) continue;
            this.manifest.put(elements[0], elements[1]);
        }
        return this.manifest;
    }

    private byte[] createBundleManifestFile(JCo3ImportSettings settings) throws IOException {
        StringBuilder manifest = new StringBuilder();
        this.writeAttribute(manifest, Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        this.writeAttribute(manifest, "Bundle-ManifestVersion", "2");
        this.writeAttribute(manifest, "Bundle-Name", settings.getBundleName());
        this.writeAttribute(manifest, "Bundle-SymbolicName", settings.getBundleSymbolicName());
        this.writeAttribute(manifest, "Bundle-Version", settings.getBundleVersion());
        this.writeAttribute(manifest, "Bundle-ClassPath", BUNDLE_CLASS_PATH_VALUE);
        this.writeAttribute(manifest, "Bundle-Vendor", settings.getBundleVendor());
        this.writeAttribute(manifest, "Bundle-RequiredExecutionEnvironment", ImportUtils.getExecutionEnvironment(settings.getRequiredExecutionEnvironmentIndex()));
        this.writeAttribute(manifest, "Export-Package", EXPORT_PACKAGE_VALUE);
        this.writeAttribute(manifest, "Bundle-ActivationPolicy", "lazy");
        return manifest.toString().getBytes("UTF-8");
    }

    private byte[] createFragmentManifestFile(JCo3ImportSettings settings) throws IOException {
        StringBuilder manifest = new StringBuilder();
        this.writeAttribute(manifest, Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        this.writeAttribute(manifest, "Bundle-ManifestVersion", "2");
        this.writeAttribute(manifest, "Bundle-Name", settings.getFragmentBundleName());
        this.writeAttribute(manifest, "Bundle-SymbolicName", settings.getFragmentSymbolicName());
        this.writeAttribute(manifest, "Bundle-Version", settings.getBundleVersion());
        this.writeAttribute(manifest, "Bundle-Vendor", settings.getBundleVendor());
        this.writeAttribute(manifest, "Fragment-Host", settings.getFragmentHost());
        this.writeAttribute(manifest, "Bundle-RequiredExecutionEnvironment", ImportUtils.getExecutionEnvironment(settings.getRequiredExecutionEnvironmentIndex()));
        this.writeAttribute(manifest, "Bundle-NativeCode", settings.getBundleNativeLibraryEntry());
        this.writeAttribute(manifest, ECLIPSE_PLATFORM_FILTER, settings.getPlatformFilter());
        return manifest.toString().getBytes("UTF-8");
    }

    public static enum JCoArchiveType {
        JCO_INVALID_ARCHIVE("Invalid JCo 3 Archive", "", "", "", "", "", "", ""),
        JCO_WIN32_X86_ARCHIVE("Microsoft Windows (x86 32 bit)", "NTintel", "sapjco3.dll", "com.sap.conn.jco.win32.x86", "(& (osgi.os=win32) (osgi.arch=x86))", "win32", "x86", "win32"),
        JCO_WIN32_IA64_ARCHIVE("Microsoft Windows (Itanium 64 bit)", "NTia64", "sapjco3.dll", "com.sap.conn.jco.win32.ia64", "(& (osgi.os=win32) (osgi.arch=ia64n))", "win32", "ia64", "win32"),
        JCO_WIN32_X86_64_ARCHIVE("Microsoft Windows (x86 64 bit)", "NTAMD64", "sapjco3.dll", "com.sap.conn.jco.win32.x86_64", "(& (osgi.os=win32) (osgi.arch=x86_64))", "win32", "x86_64", "win32"),
        JCO_LINUX_X86_ARCHIVE("Linux (x86 32 bit)", "linuxintel", "libsapjco3.so", "com.sap.conn.jco.linux.x86", "(& (osgi.os=linux) (osgi.arch=x86))", "linux", "x86", "gtk"),
        JCO_LINUX_IA64_ARCHIVE("Linux (Itanium 64 bit)", "linuxia64", "libsapjco3.so", "com.sap.conn.jco.linux.ia64", "(& (osgi.os=linux) (osgi.arch=ia64n))", "linux", "ia64", "gtk"),
        JCO_LINUX_X86_64_ARCHIVE("Linux (x86 64 bit)", "linuxx86_64", "libsapjco3.so", "com.sap.conn.jco.linux.x86_64", "(& (osgi.os=linux) (osgi.arch=x86_64))", "linux", "x86_64", "gtk"),
        JCO_OSX_X86_ARCHIVE("Apple MacOS X (x86 32 bit)", "darwinintel", "libsapjco3.jnilib", "com.sap.conn.jco.osx.x86", "(& (osgi.os=macosx) (osgi.arch=x86))", "macosx", "x86", "cocoa"),
        JCO_OSX_X86_64_ARCHIVE("Apple MacOS X (x86 64 bit)", "darwinintel64", "libsapjco3.jnilib", "com.sap.conn.jco.osx.x86_64", "(& (osgi.os=macosx) (osgi.arch=x86_64))", "macosx", "x86_64", "cocoa");

        private String description;
        private String sapjcoOs;
        private String nativeArchiveName;
        private String fragmentName;
        private String platformFilter;
        private String eclipseOS;
        private String eclipseArch;
        private String eclipseWS;

        private JCoArchiveType(String description, String sapjcoOs, String nativeArchiveName, String fragmentName, String platformFilter, String eclipseOS, String eclipseArch, String eclipseWS) {
            this.description = description;
            this.nativeArchiveName = nativeArchiveName;
            this.sapjcoOs = sapjcoOs;
            this.fragmentName = fragmentName;
            this.platformFilter = platformFilter;
            this.eclipseOS = eclipseOS;
            this.eclipseArch = eclipseArch;
            this.eclipseWS = eclipseWS;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSapjcoOs() {
            return this.sapjcoOs;
        }

        public String getNativeArchiveName() {
            return this.nativeArchiveName;
        }

        public String getPluginName() {
            return JCo3Archive.PLUGIN_JCO;
        }

        public String getFragmentName() {
            return this.fragmentName;
        }

        public String getPlatformFilter() {
            return this.platformFilter;
        }

        public String getEclipseOS() {
            return this.eclipseOS;
        }

        public String getEclipseArch() {
            return this.eclipseArch;
        }

        public String getEclipseWS() {
            return this.eclipseWS;
        }

        public static JCoArchiveType getType(String sapjcoOsCode) {
            if ((sapjcoOsCode = sapjcoOsCode.trim()).equals(JCO_WIN32_X86_ARCHIVE.getSapjcoOs())) {
                return JCO_WIN32_X86_ARCHIVE;
            }
            if (sapjcoOsCode.equals(JCO_WIN32_IA64_ARCHIVE.getSapjcoOs())) {
                return JCO_WIN32_IA64_ARCHIVE;
            }
            if (sapjcoOsCode.equals(JCO_WIN32_X86_64_ARCHIVE.getSapjcoOs())) {
                return JCO_WIN32_X86_64_ARCHIVE;
            }
            if (sapjcoOsCode.equals(JCO_LINUX_X86_ARCHIVE.getSapjcoOs())) {
                return JCO_LINUX_X86_ARCHIVE;
            }
            if (sapjcoOsCode.equals(JCO_LINUX_IA64_ARCHIVE.getSapjcoOs())) {
                return JCO_LINUX_IA64_ARCHIVE;
            }
            if (sapjcoOsCode.equals(JCO_LINUX_X86_64_ARCHIVE.getSapjcoOs())) {
                return JCO_LINUX_X86_64_ARCHIVE;
            }
            if (sapjcoOsCode.equals(JCO_OSX_X86_ARCHIVE.getSapjcoOs())) {
                return JCO_OSX_X86_ARCHIVE;
            }
            if (sapjcoOsCode.equals(JCO_OSX_X86_64_ARCHIVE.getSapjcoOs())) {
                return JCO_OSX_X86_64_ARCHIVE;
            }
            return JCO_INVALID_ARCHIVE;
        }

        public static JCoArchiveType getTypeForCurrentPlatform() {
            String os = Platform.getOS();
            String arch = Platform.getOSArch();
            if (os.equals("win32")) {
                if (arch.equals("x86")) {
                    return JCO_WIN32_X86_ARCHIVE;
                }
                if (arch.equals("ia64")) {
                    return JCO_WIN32_IA64_ARCHIVE;
                }
                if (arch.equals("x86_64")) {
                    return JCO_WIN32_X86_64_ARCHIVE;
                }
            } else if (os.equals("linux")) {
                if (arch.equals("x86")) {
                    return JCO_LINUX_X86_ARCHIVE;
                }
                if (arch.equals("ia64")) {
                    return JCO_LINUX_IA64_ARCHIVE;
                }
                if (arch.equals("x86_64")) {
                    return JCO_LINUX_X86_64_ARCHIVE;
                }
            } else if (os.equals("macosx")) {
                if (arch.equals("x86")) {
                    return JCO_OSX_X86_ARCHIVE;
                }
                if (arch.equals("x86_64")) {
                    return JCO_OSX_X86_64_ARCHIVE;
                }
            }
            return JCO_INVALID_ARCHIVE;
        }
    }
}

